﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page
{
    BLL.T_userbll bt = new BLL.T_userbll();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Redirect("Login.aspx");
        }
        else  if (!IsPostBack)
        {
            GetGridView();
        }
    }
    public void GetGridView()
    {
        string MyUserID = this.txtusername.Text.Trim();
        string AType = drpFieldName.SelectedValue.ToString();
        if (MyUserID == "")
        {
            this.GridView1.DataSource = bt.selectAllT_user();
            this.GridView1.DataBind();
        }
        else
        {
            this.GridView1.DataSource = bt.selectT_userWhere_UserID(AType, MyUserID);
            this.GridView1.DataBind();
        }
    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        string UserID =GridView1.DataKeys[e.RowIndex].Value.ToString();
        int row =bt.DeleteT_user(UserID);
        GetGridView();
    }
    protected void select_Click(object sender, EventArgs e)
    {
        GetGridView();
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        e.Row.Attributes.Add("onMouseOver", "Color=this.style.backgroundColor;this.style.backgroundColor='lightBlue'");
        e.Row.Attributes.Add("onMouseOut", "this.style.backgroundColor=Color;");
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.GridView1.PageIndex = e.NewPageIndex;
        GetGridView();
    }
}
