﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Model;
using SQLServerDAL;

namespace BLL
{
    public class AssetBll
    {
        public static AssetDAL assetDal=new AssetDAL();
        #region 资产入库
        public int AddAssetInfo(AssetInfo assetInfo)
        {
            return assetDal.AddAssetInfo(assetInfo);
        }
        #endregion
        #region 根据资产编号查询资产信息
        public AssetInfo1 GetAssetById(int assetId)
        {
            return assetDal.GetAssetById(assetId);
        }
         #endregion
        #region 购买资产
        public int BuyAssetInfo(AssetInfo assetInfo)
        {
            return assetDal.BuyAssetInfo(assetInfo);
        }
         #endregion
        #region 根据资产名称查询资产信息
        public List<AssetInfo1> GetAssetByName(string assetName)
        {
            return assetDal.GetAssetByName(assetName);
        }
        #endregion
        #region 对资产的现有数量不为0的进行操作
        public List<AssetInfo1> GetAssetByNowNum()
        {
            return assetDal.GetAssetByNowNum();
        }
        #endregion
        #region 领用资产
        public int TakeAssetInfo(TakeInfo takeInfo)
        {
            return assetDal.TakeAssetInfo(takeInfo);
        }
         #endregion
        #region 根据时间或价格显示资产的信息
        public vw_Lairage GetAssetByTimeOrPrice(int assetId, DateTime date, decimal price)
        {
            return assetDal.GetAssetByTimeOrPrice(assetId, date, price);
        }
         #endregion
        #region 根据资产编号显示该资产的详细信息
        public AssetInfo  GetAssetInfoById(int assetId)
        {
            return assetDal.GetAssetInfoById(assetId);
        }
        #endregion
        #region 显示资产领用的详细信息
        public List<vw_TakeOrReturn> TakeAsset()
        {
            return assetDal.TakeAsset();
        }
        #endregion
        #region 资产调拨
        public int MoveAsset(MoveInfo moveInfo)
        {
            return assetDal.MoveAsset(moveInfo);
        }
        #endregion
        //#region 根据资产名称或入库时间来查询资产信息
        //public List<vw_Lairage> SelectAssetByNameOrTime(string name, DateTime beginTime, DateTime endTime)
        //{
        //    return assetDal.SelectAssetByNameOrTime(name,beginTime,endTime);
        //}
        //#endregion
        #region 查询资产编号的最大标识列
        public  int getIdentity()
        {
            return assetDal.getIdentity();
        }
        #endregion
        #region 资产维修
        public int RepairAsset(RepairInfo repairInfo)
        {
            return assetDal.RepairAsset(repairInfo);
        }
         #endregion
        #region 资产报废
        public int BadAsset(BadInfo badInfo)
        {
            return assetDal.BadAsset(badInfo);
        }
         #endregion

        //根据编号查名称
        public string GetNameByAssetId(int assetId)
        {
            return assetDal.GetNameByAssetId(assetId);
        }


        //根据类别查询资产信息
        public List<vw_Lairage> GetAssetByType(string typeId)
        {
            return assetDal.GetAssetByType(typeId);
        }
    }
}
