﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Model;

namespace IDAL
{
   public interface IAssetInfo
   {
       #region 资产入库
       int AddAssetInfo(AssetInfo assetInfo);
       #endregion


       #region 根据资产编号查询资产信息
       AssetInfo1 GetAssetById(int assetId);
       #endregion


       #region 购买资产
       int BuyAssetInfo(AssetInfo assetInfo);
       #endregion


       #region 根据资产名称查询资产信息
       List<AssetInfo1> GetAssetByName(string assetName);
       #endregion


       #region 对资产的现有数量不为0的进行操作
       List<AssetInfo1> GetAssetByNowNum();
       #endregion


       #region 根据时间或价格显示资产的信息 
       vw_Lairage GetAssetByTimeOrPrice(int assetId,DateTime date,decimal price);
       #endregion


       #region 领用资产
       int TakeAssetInfo(TakeInfo takeInfo);
       #endregion

       #region 根据资产编号显示该资产的详细信息
       AssetInfo GetAssetInfoById(int assetId);
       #endregion

       #region 显示资产领用的详细信息
       List<vw_TakeOrReturn> TakeAsset();
       #endregion

       #region 资产调拨
       int MoveAsset(MoveInfo moveInfo);
       #endregion

       //#region 根据资产名称或入库时间来查询资产信息
       //List<vw_Lairage> SelectAssetByNameOrTime(string name, DateTime beginTime,DateTime endTime);
       //#endregion
       #region 查询资产编号的最大标识列
        int getIdentity();
       #endregion

       #region 资产维修
        int RepairAsset(RepairInfo repairInfo);
       #endregion

        #region 资产报废
        int BadAsset(BadInfo badInfo);
        #endregion

   }
}
