﻿using System;
using System.Workflow.Activities;
using Model;

namespace IDAL
{
    public class Project : IProject
    {

        #region IProject 成员

        public event EventHandler<ExternalDataEventArgs> OnAdminSubmit;

        public event EventHandler<StockInfo> OnAdminDelete;

        public event EventHandler<StockInfo> OnSMSubmit;

        public event EventHandler<StockInfo> OnCMSubMit;

        public event EventHandler<StockInfo> OnSMReject;

        public event EventHandler<StockInfo> OnCMReject;

        #endregion



        public void RaiseAdminSubmit(StockInfo info)
        {
            if(OnAdminSubmit !=null)
            {
                OnAdminSubmit(null, info);
            }
        }

        public void RaiseAdminDelete(StockInfo info)
        {
            if(OnAdminDelete !=null)
            {
                OnAdminDelete(null, info);
            }
        }

        public void RaiseSMSubmit(StockInfo info)
        {
            if (OnSMSubmit != null)
            {
                OnSMSubmit(null, info);
            }
        }

        public void RaiseCMSubMit(StockInfo info)
        {
            if (OnCMSubMit != null)
            {
                OnCMSubMit(null, info);
            }
        }

        public void RaiseSMReject(StockInfo info)
        {
            if (OnSMReject != null)
            {
                OnSMReject(null, info);
            }
        }


        public void RaiseCMReject(StockInfo info)
        {
            if (OnCMReject != null)
            {
                OnCMReject(null, info);
            }
        }

    }
}
