﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using IDAL;
using DBUtility;
using Model;
using System.Data.SqlClient;
using System.Data;

namespace SQLServerDAL
{
    public class AddressDAL:IAddressInfo
    {

        public List<AddressInfo> getAllAddressInfo()
        {
            string SQL_SEL_ADDRESS = "select * from AddressInfo";
            SqlDataReader dr=SQLHelper.ExecuteReader(SQLHelper.ConnectionString, System.Data.CommandType.Text,SQL_SEL_ADDRESS,null);
            List<AddressInfo> list = new List<AddressInfo>();
            while (dr.Read())
            {
                AddressInfo ai = new AddressInfo();
                ai.AddressId=dr.GetInt32(0);
                ai.AddressName= dr.GetString(1);
                OrganDAL od = new OrganDAL();
                ai.OrganId.OrganName=od.getOrganInfo(dr.GetInt32(2)).OrganName;
                list.Add(ai);
            }
            return list;
        }

        public List<AddressInfo> getAddressInfo(int id)
        {
            string SQL_SEL_ADDRESS = "select * from AddressInfo where AddressId="+id;
            SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_SEL_ADDRESS, null);
            List<AddressInfo> list = new List<AddressInfo>();
            while (dr.Read())
            {
                AddressInfo ai = new AddressInfo();
                ai.AddressId = dr.GetInt32(0);
                ai.AddressName = dr.GetString(1);
                OrganDAL od = new OrganDAL();
                ai.OrganId = od.getOrganInfo(dr.GetInt32(2));
                list.Add(ai);
            }
            return list;
        }


        //添加存放地点
        
        public int addAddressInfo(string an, int val)
        {
            string SQL_INS_ADDRESS = string.Format("insert into AddressInfo(AddressName,OrganId) values('{0}',{1})",an,val);
            return SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, System.Data.CommandType.Text,SQL_INS_ADDRESS,null);
        }



        //修改
        public int amendAddressInfo(string an, int val,int ai)
        {
            string SQL_INS_ADDRESS = string.Format("update AddressInfo set AddressName='{0}',OrganId={1} where AddressId={2}", an, val,ai);
            return SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_INS_ADDRESS, null);
        }


        //地址名是否存在
        public bool getAddressInfo(string an,int val)
        {
            string SQL_SEL_ADDRESS = "select AddressName,OrganId from AddressInfo";
            SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_SEL_ADDRESS, null);
            while (dr.Read())
            {
                if (dr.GetString(0).Equals(an)&&dr.GetInt32(1).Equals(val))
                {
                    return false;
                }
                
            }
            return true;
        }

        //分页
        public List<AddressInfo> setPaging(int id)
        {
            string SQL_SEL_ADDRESS =string.Format("select top 10 * from AddressInfo where AddressId not in (select top (10 * ({0}-1)) AddressId from AddressInfo)",id);
            SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_SEL_ADDRESS, null);
            List<AddressInfo> list = new List<AddressInfo>();
            while (dr.Read())
            {
                AddressInfo ai = new AddressInfo();
                ai.AddressId = dr.GetInt32(0);
                ai.AddressName = dr.GetString(1);
                OrganDAL od = new OrganDAL();
                ai.OrganId = od.getOrganInfo(dr.GetInt32(2));
                list.Add(ai);
            }
            return list;
        }



        #region 查询所有的存放地点
        public List<OrganInfo> GetAllOrgan()
        {
            List<OrganInfo> organList = new List<OrganInfo>();
            string sql = "select * from OrganInfo";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    OrganInfo organInfo = new OrganInfo();
                    organInfo.OrganId = (int)reader["OrganId"];
                    organInfo.OrganName = (string)reader["OrganName"];
                    organList.Add(organInfo);
                }
                return organList;
            }
        }
        #endregion

        #region 根据编号查询存放地点
        public OrganInfo GetOrganById(int id)
        {
            OrganInfo organInfo = new OrganInfo();
            string sql = "select * from OrganInfo where OrganId=" + id;
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                if (reader.Read())
                {
                    organInfo.OrganId = (int)reader["OrganId"];
                    organInfo.OrganName = (string)reader["OrganName"];
                    return organInfo;
                }
                else
                {
                    return null;
                }

            }
        }
        #endregion

        #region 根据存放地点查找仓库地点
        public List<StorageInfo> GetStorageByorgId(int organId)
        {
            List<StorageInfo> storageList = new List<StorageInfo>();
            string sql = "select * from StorageInfo where OrganId=" + organId;
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    StorageInfo storageInfo = new StorageInfo();
                    storageInfo.StorageId = (int)reader["StorageId"];
                    storageInfo.StorageName = (string)reader["StorageName"];
                    storageInfo.OrganInfo = GetOrganById((int)reader["OrganId"]);
                    storageList.Add(storageInfo);
                }
                return storageList;
            }
        }
        #endregion

        #region 根据机构查询使用地点
        public List<AddressInfo> GetAddressByorgId(int organId)
        {
            List<AddressInfo> addressList = new List<AddressInfo>();
            string sql = "select * from AddressInfo where OrganId=" + organId;
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    AddressInfo addressInfo = new AddressInfo();
                    addressInfo.AddressId = (int)reader["AddressId"];
                    addressInfo.AddressName = (string)reader["AddressName"];
                    addressInfo.OrganId = GetOrganById((int)reader["OrganId"]);
                    addressList.Add(addressInfo);
                }
                return addressList;
            }
        }
        #endregion
    }
}
