﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Model;
using IDAL;
using DBUtility;
using System.Data;
using System.Data.SqlClient;


namespace SQLServerDAL
{
    public class AssetDAL
    {
        public static TypeDAL typeDal = new TypeDAL();
        #region 资产入库
        public int AddAssetInfo(AssetInfo assetInfo)
        {
            string sql = "update AssetInfo set AssetName=@AssetName,TypeId=@TypeId,Model=@Model,StorageId=@StorageId,TotalNum=@TotalNum,NowNum=@NowNum,TakeNum=@TakeNum,RepairNum=@RepairNum,BadNum=@BadNum,MoveNum=@MoveNum where AssetId=@AssetId";
            try
            {
                SqlParameter[] par = new SqlParameter[] { 
                    new SqlParameter("@AssetName",assetInfo.AssetName),
                    new SqlParameter("@TypeId",assetInfo.TypeInfo.TypeId),
                    new SqlParameter("@Model",assetInfo.Model1),
                    new SqlParameter("@StorageId",assetInfo.StorageId),
                    new SqlParameter("@TotalNum",assetInfo.TotalNum),
                    new SqlParameter("@NowNum",assetInfo.NowNum),
                    new SqlParameter("@TakeNum",assetInfo.TakeNum),
                    new SqlParameter("@RepairNum",assetInfo.RepairNum),
                    new SqlParameter("@BadNum",assetInfo.BadNum),
                    new SqlParameter("@MoveNum",assetInfo.MoveNum),
                    new SqlParameter("@AssetId",assetInfo.AssetId)
            };
                int assetId = SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, sql, par);
                return assetId;
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                throw e;
            }
        }
        #endregion
        #region 根据资产编号查询资产信息
        public AssetInfo1 GetAssetById(int assetId)
        {
            AssetInfo1 assetInfo = new AssetInfo1();
            string sql = "select * from vw_Asset where AssetId=" + assetId;
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                if (reader.Read())
                {
                    assetInfo.AssetId = (int)reader["AssetId"];
                    assetInfo.AssetName = (string)reader["AssetName"];
                    assetInfo.TypeName=(string)reader["TypeName"];
                    assetInfo.Model1 = (string)reader["Model"];
                    assetInfo.OrganName = (string)reader["OrganName"];
                    assetInfo.StorageName = (string)reader["StorageName"];
                    assetInfo.TotalNum = (int)reader["TotalNum"];
                    assetInfo.NowNum = (int)reader["NowNum"];
                    assetInfo.TakeNum = (int)reader["TakeNum"];
                    assetInfo.RepairNum = (int)reader["RepairNum"];
                    assetInfo.BadNum = (int)reader["BadNum"];
                    assetInfo.MoveNum = (int)reader["MoveNum"];
                    return assetInfo;
                }
                else
                {
                    return null;
                }
            }

        }
        #endregion
        #region 购买资产
        public int BuyAssetInfo(AssetInfo assetInfo)
        {
            string sql = "insert into AssetInfo values(@AssetName,@TypeId,@Model,@StorageId,@TotalNum,@NowNum,@TakeNum,@RepairNum,@BadNum,@MoveNum)";

            try
            {
                SqlParameter[] par = new SqlParameter[] { 
                  new SqlParameter("@AssetName",assetInfo.AssetName),
                  new SqlParameter("@TypeId",assetInfo.TypeInfo.TypeId),
                  new SqlParameter("@Model",assetInfo.Model1),
                  new SqlParameter("@StorageId",assetInfo.StorageId),
                  new SqlParameter("@TotalNum",assetInfo.TotalNum),
                  new SqlParameter("@NowNum",assetInfo.NowNum),
                  new SqlParameter("@TakeNum",assetInfo.TakeNum),
                  new SqlParameter("@RepairNum",assetInfo.RepairNum),
                  new SqlParameter("@BadNum",assetInfo.BadNum),
                  new SqlParameter("@MoveNum",assetInfo.MoveNum)
            };
                int assetId = 0;
                //int assetId = SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, sql, par);
                SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, par);
                if (dr.Read())
                {
                    return assetId= dr.GetInt32(0);
                }
                //if (assetId > 0)
                //{
                //    string sql1 = "select top 1 assetId from AssetInfo where order by desc";
                //}
                //return assetId;
                else
                {
                    return 0;
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                throw e;
            }
        }
        #endregion
        #region 根据资产名称查询资产信息
        public List<AssetInfo1> GetAssetByName(string assetName)
        {
            List<AssetInfo1> assetList = new List<AssetInfo1>();
            string sql = "select * from vw_Asset where AssetName='" + assetName + "'";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    AssetInfo1 assetInfo = new AssetInfo1();
                    assetInfo.AssetId = (int)reader["AssetId"];
                    assetInfo.AssetName = (string)reader["AssetName"];
                    assetInfo.TypeName = (string)reader["TypeName"];
                    assetInfo.Model1 = (string)reader["Model"];
                    assetInfo.OrganName = (string)reader["OrganName"];
                    assetInfo.StorageName = (string)reader["StorageName"];
                    assetInfo.TotalNum = (int)reader["TotalNum"];
                    assetInfo.NowNum = (int)reader["NowNum"];
                    assetInfo.TakeNum = (int)reader["TakeNum"];
                    assetInfo.RepairNum = (int)reader["RepairNum"];
                    assetInfo.BadNum = (int)reader["BadNum"];
                    assetInfo.MoveNum = (int)reader["MoveNum"];
                    assetList.Add(assetInfo);
                }
                return assetList;
            }
        }
        #endregion
        #region 对资产的现有数量不为0的进行操作
        public List<AssetInfo1> GetAssetByNowNum()
        {
            List<AssetInfo1> assetList = new List<AssetInfo1>();
            string sql = "select * from vw_Asset where NowNum>0";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    AssetInfo1 assetInfo = new AssetInfo1();
                    assetInfo.AssetId = (int)reader["AssetId"];
                    assetInfo.AssetName = (string)reader["AssetName"];
                    assetInfo.TypeName = (string)reader["TypeName"];
                    assetInfo.Model1 = (string)reader["Model"];
                    assetInfo.OrganName = (string)reader["OrganName"];
                    assetInfo.StorageName = (string)reader["StorageName"];
                    assetInfo.TotalNum = (int)reader["TotalNum"];
                    assetInfo.NowNum = (int)reader["NowNum"];
                    assetInfo.TakeNum = (int)reader["TakeNum"];
                    assetInfo.RepairNum = (int)reader["RepairNum"];
                    assetInfo.BadNum = (int)reader["BadNum"];
                    assetInfo.MoveNum = (int)reader["MoveNum"];
                    assetList.Add(assetInfo);
                }
                return assetList;
            }
        }
        #endregion
        #region 根据时间或价格显示资产的信息
        public vw_Lairage GetAssetByTimeOrPrice(int assetId, DateTime date, decimal price)
        {
            vw_Lairage vwlairage = new vw_Lairage();
            string sql = "select * from vw_Lairage where 1=1";
            if (assetId != 0)
            {
                sql += " and AssetId=@AssetId";
            }
            if (date != null)
            {
                sql += " and LairageDate=@LairageDate";
            }
            if (price != 0)
            {
                sql += " and Price=@Price";
            }
            SqlParameter[] par = new SqlParameter[] { 
              new SqlParameter("@AssetId",assetId),
              new SqlParameter("@LairageDate",date),
              new SqlParameter("@Price",price)
            };
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, par))
            {
                if (reader.Read())
                {
                    vwlairage.AssetId = (int)reader["AssetId"];
                    vwlairage.AssetName = (string)reader["AssetName"];
                    vwlairage.TypeId = (int)reader["TypeId"];
                    vwlairage.TypeName = (string)reader["TypeName"];
                    vwlairage.LairageDate = (DateTime)reader["LairageDate"];
                    vwlairage.OrganName = (string)reader["OrganName"];
                    vwlairage.StorageId = (int)reader["StorageId"];
                    vwlairage.StorageName = (string)reader["StorageName"];
                    vwlairage.Model = (string)reader["Model"];
                    vwlairage.Account = (int)reader["Account"];
                    vwlairage.Price = (decimal)reader["Price"];
                    vwlairage.TotalNum = (int)reader["TotalNum"];
                    vwlairage.NowNum = (int)reader["NowNum"];
                    vwlairage.TakeNum = (int)reader["TakeNum"];
                    vwlairage.RepairNum = (int)reader["RepairNum"];
                    vwlairage.BadNum = (int)reader["BadNum"];
                    vwlairage.MoveNum = (int)reader["MoveNum"];
                    return vwlairage;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion
        #region 领用资产
        public int TakeAssetInfo(TakeInfo takeInfo)
        {
            string sql = "insert into TakeInfo values(@AssetId,@TakeAccount,@ReturnAccount,@AddressId,@TakeUser,@TakeDate)";
            try
            {
                SqlParameter[] par = new SqlParameter[] { 
                  new SqlParameter("@AssetId",takeInfo.AssetId),
                  new SqlParameter("@TakeAccount",takeInfo.TakeAccount),
                  new SqlParameter("@ReturnAccount",takeInfo.ReturnAccount),
                  new SqlParameter("@AddressId",takeInfo.AddressId),
                  new SqlParameter("@TakeUser",takeInfo.TakeUser),
                  new SqlParameter("@TakeDate",takeInfo.TakeDate) 
            };
                int takeId = SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, sql, par);
                return takeId;
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                throw e;
            }
        }
        #endregion
        #region 根据资产编号显示该资产的详细信息
        public AssetInfo GetAssetInfoById(int assetId)
        {
            AssetInfo assetInfo = new AssetInfo();
            string sql = "select * from AssetInfo where AssetId=" + assetId;
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                if (reader.Read())
                {
                    assetInfo.AssetId = (int)reader["AssetId"];
                    assetInfo.AssetName = (string)reader["AssetName"];
                    assetInfo.TypeInfo = typeDal.GetTypeById((int)reader["TypeId"]);
                    assetInfo.Model1 = (string)reader["Model"];
                    assetInfo.StorageId = (int)reader["StorageId"];
                    assetInfo.TotalNum = (int)reader["TotalNum"];
                    assetInfo.NowNum = (int)reader["NowNum"];
                    assetInfo.TakeNum = (int)reader["TakeNum"];
                    assetInfo.RepairNum = (int)reader["RepairNum"];
                    assetInfo.BadNum = (int)reader["BadNum"];
                    assetInfo.MoveNum = (int)reader["MoveNum"];
                    return assetInfo;
                }
                else
                {
                    return null;
                }
            }
        }
        #endregion
        #region 显示资产领用的详细信息
        public List<vw_TakeOrReturn> TakeAsset()
        {
            List<vw_TakeOrReturn> vwTRList = new List<vw_TakeOrReturn>();
            string sql = "select * from vw_TakeOrReturn";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    vw_TakeOrReturn vwTR = new vw_TakeOrReturn();
                    vwTR.AssetId = (int)reader["AssetId"];
                    vwTR.AssetName = (string)reader["AssetName"];
                    vwTR.TakeId = (int)reader["TakeId"];
                    vwTR.TypeName = (string)reader["TypeName"];
                    vwTR.ParentId = (int)reader["ParentTypeId"];
                    vwTR.Model1 = (string)reader["Model"];
                    vwTR.TakeAccount = (int)reader["TakeAccount"];
                    vwTR.ReturnAccount = (int)reader["ReturnAccount"];
                    vwTR.TakeTime = (DateTime)reader["TakeDate"];
                    vwTR.TakeUser = (string)reader["TakeUser"];
                    vwTR.OrganName = (string)reader["OrganName"];
                    vwTR.AddressName = (string)reader["AddressName"];
                    vwTRList.Add(vwTR);
                }
                return vwTRList;
            }
        }
        #endregion
        #region 资产调拨
        public int MoveAsset(MoveInfo moveInfo)
        {
            string sql = "insert into MoveInfo values(@AssetId,@StorageOutId,@StorageInId,@MoveNum,@MoveDate,@MoveCase)";
            SqlParameter[] par = new SqlParameter[] { 
               new SqlParameter("@AssetId",moveInfo.AssetId),
               new SqlParameter("@StorageOutId",moveInfo.StorageOutId),
               new SqlParameter("@StorageInId",moveInfo.StorageInId),
               new SqlParameter("@MoveNum",moveInfo.MoveNum),
               new SqlParameter("@MoveDate",moveInfo.MoveDate),
               new SqlParameter("@MoveCase",moveInfo.MoveCase)
            };
            int moveId = SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString,CommandType.Text,sql,par);
            return moveId;
        }
        #endregion
        //#region 根据资产名称或入库时间来查询资产信息
        //public List<vw_Lairage> SelectAssetByNameOrTime(string name, DateTime beginTime,DateTime endTime)
        //{
        //    List<vw_Lairage> vw_LairageList = new List<vw_Lairage>();
        //    string sql = "select * from vw_Lairage where 1=1";
        //    if (name != null && name != "")
        //    {
        //        sql += " and AssetName='"+name+"'";
        //    }
        //    if (endTime != null && !endTime.Equals(""))
        //    {
        //        sql += " and LairageDate between '" + beginTime + "' and '" + endTime + "'";
        //    }
        //    else if ((beginTime == null || beginTime.Equals("")) && (endTime == null || endTime.Equals("")))
        //    {

        //    }
        //    else
        //    {
        //        sql += " and LairageDate > beginTime";
        //    }
        //    using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
        //    {
        //        while (reader.Read())
        //        {
        //            vw_Lairage vwlairage = new vw_Lairage();
        //            vwlairage.AssetId = (int)reader["AssetId"];
        //            vwlairage.AssetName = (string)reader["AssetName"];
        //            vwlairage.TypeId = (int)reader["TypeId"];
        //            vwlairage.TypeName = (string)reader["TypeName"];
        //            vwlairage.LairageDate = (DateTime)reader["LairageDate"];
        //            vwlairage.OrganName = (string)reader["OrganName"];
        //            vwlairage.StorageId = (int)reader["StorageId"];
        //            vwlairage.StorageName = (string)reader["StorageName"];
        //            vwlairage.Model = (string)reader["Model"];
        //            vwlairage.Account = (int)reader["Account"];
        //            vwlairage.Price = (decimal)reader["Price"];
        //            vw_LairageList.Add(vwlairage);
        //        }
        //        return vw_LairageList;
        //    }
        //}
        //#endregion
        #region 查询资产编号的最大标识列
        public int getIdentity()
        {
            int id = 0;
            string sql = "select max(AssetId) from AssetInfo";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    id = Convert.ToInt32(reader[0]);
                }
            }
            return id;
        }
        #endregion
        #region 资产维修
        public int RepairAsset(RepairInfo repairInfo)
        {
            string sql = "insert into RepairInfo values(@AssetId,@RepairNum,@RepairDate,@RepairCase)";
            SqlParameter[] par = new SqlParameter[] { 
               new SqlParameter("@AssetId",repairInfo.AssetId),
               new SqlParameter("@RepairNum",repairInfo.RepairNum),
               new SqlParameter("@RepairDate",repairInfo.RepairDate),
               new SqlParameter("@RepairCase",repairInfo.RepairCase)
            };
            int repairId = SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString,CommandType.Text,sql,par);
            return repairId;
        }
        #endregion
        #region 资产报废
        public int BadAsset(BadInfo badInfo)
        {
            string sql = "insert into BadInfo values(@AssetId,@BadNum,@BadDate,@Remark)";
            SqlParameter[] par = new SqlParameter[] { 
               new SqlParameter("@AssetId",badInfo.AssetId),
               new SqlParameter("@BadNum",badInfo.BadNum),
               new SqlParameter("@BadDate",badInfo.BadDate),
               new SqlParameter("@Remark",badInfo.Remark)
            };
            int badId = SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, sql, par);
            return badId;
        }
        #endregion



        //根据编号查名称
        public string GetNameByAssetId(int assetId)
        {
            string assetName = null;
            string sql = "select AssetName from AssetInfo where AssetId=@AssetId";
            SqlParameter parm = new SqlParameter("@AssetId",assetId);
            
            using(SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql,parm))
            {
                if (dr.Read())
                {
                    assetName = dr.GetString(0);
                }
            }
            return assetName;
        }



        //根据类别查询资产信息
        public List<vw_Lairage> GetAssetByType(string typeId)
        {
            List<vw_Lairage> vw_LairageList = new List<vw_Lairage>();
            string sql = "select * from vw_Lairage where TypeId='" + typeId + "'";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    vw_Lairage vwlairage = new vw_Lairage();
                    vwlairage.AssetId = (int)reader["AssetId"];
                    vwlairage.AssetName = (string)reader["AssetName"];
                    vwlairage.TypeId = (int)reader["TypeId"];
                    vwlairage.TypeName = (string)reader["TypeName"];
                    vwlairage.LairageDate = (DateTime)reader["LairageDate"];
                    vwlairage.OrganName = (string)reader["OrganName"];
                    vwlairage.StorageId = (int)reader["StorageId"];
                    vwlairage.StorageName = (string)reader["StorageName"];
                    vwlairage.Model = (string)reader["Model"];
                    vwlairage.Account = (int)reader["Account"];
                    vwlairage.Price = (decimal)reader["Price"];
                    vw_LairageList.Add(vwlairage);
                }
                return vw_LairageList;
            }
        }
    }
}


