﻿using System;
using System.Collections.Generic;
using Model;
using IDAL;
using DBUtility;
using System.Data;
using System.Data.SqlClient;
//51a/s/px
namespace SQLServerDAL
{
    public class EmpDAL : IEmpInfo
    {
        private const string SQL_SELECT_ALL_EMPS = "select * from EmpInfo";
        private const string SQL_SELECT_EMP_BY_NAMEPWD = "select * from EmpInfo where EmpName=@EmpName and EmpPwd=@EmpPwd";
        private const string PARM_EMPNAME = "@EmpName";
        private const string PARM_EMPPWD = "@EmpPwd";
        private const string SQL_INSERT_EMP = "insert into EmpInfo values(@EmpName,@EmpPwd,@Sex,@Address,@Phone,@RoleId)";


        private const string SQL_UPDATE_EMP = "update EmpInfo set EmpName=@EmpName,EmpPwd=@EmpPwd,Sex=@Sex,Address=@Address,Phone=@Phone,RoleId=@RoleId where EmpId=@EmpId";

        
        //获取所有员工信息
        public List<EmpInfo> GetAllEmps()
        {
            List<EmpInfo> list = new List<EmpInfo>();

            using(SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, SQL_SELECT_ALL_EMPS,null))
            {
                while(dr.Read())
                {
                    EmpInfo item = new EmpInfo();
                    item.EmpId = dr.GetInt32(0);
                    item.EmpName = dr.GetString(1);
                    item.EmpPwd = dr.GetString(2);
                    item.Sex = dr.GetString(3);
                    if (dr[4] is System.DBNull)
                        item.Address = string.Empty;
                    else
                        item.Address = dr.GetString(4);
                    if (dr[5] is System.DBNull)
                        item.Phone = string.Empty;
                    else
                        item.Phone = dr.GetString(5);
                    item.RoleId = dr.GetInt32(6);
                    list.Add(item);
                }
            }
            return list;
        }




        //根据员工姓名和密码登陆
        public EmpInfo GetEmpByNamePwd(string name, string pwd)
        {
            EmpInfo item = null;
            SqlParameter[] parms = new SqlParameter[]
            {
                new SqlParameter(PARM_EMPNAME, SqlDbType.VarChar,50),
                new SqlParameter(PARM_EMPPWD, SqlDbType.VarChar,50)
            };
            parms[0].Value = name;
            parms[1].Value = pwd;
            using(SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, SQL_SELECT_EMP_BY_NAMEPWD,parms))
            {
                if(dr.Read())
                {
                    item = new EmpInfo();
                    item.EmpId = dr.GetInt32(0);
                    item.EmpName = dr.GetString(1);
                    item.EmpPwd = dr.GetString(2);
                    item.Sex = dr.GetString(3);
                    if (dr[4] is System.DBNull)
                        item.Address = string.Empty;
                    else
                        item.Address = dr.GetString(4);
                    if (dr[5] is System.DBNull)
                        item.Phone = string.Empty;
                    else
                        item.Phone = dr.GetString(5);
                    item.RoleId = dr.GetInt32(6);
                }
            }
            return item;
        }



        //添加新员工
        public void AddEmpInfo(EmpInfo empInfo)
        {
            SqlParameter[] parms = new SqlParameter[]
            {
                new SqlParameter("@EmpName",empInfo.EmpName),
                new SqlParameter("@EmpPwd", empInfo.EmpPwd),
                new SqlParameter("@Sex", empInfo.Sex),
                new SqlParameter("@Address", empInfo.Address),
                new SqlParameter("@Phone", empInfo.Phone),
                new SqlParameter("@RoleId", empInfo.RoleId)
            };
            if(SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, SQL_INSERT_EMP,parms)!=1)
            {
                throw new ApplicationException("添加员工失败!");
            }
        }




        //修改员工
        public void UpdateEmp(EmpInfo empInfo)
        {
            SqlParameter[] parms = new SqlParameter[]
            {
                new SqlParameter("@EmpName",empInfo.EmpName),
                new SqlParameter("@EmpPwd", empInfo.EmpPwd),
                new SqlParameter("@Sex", empInfo.Sex),
                new SqlParameter("@Address", empInfo.Address),
                new SqlParameter("@Phone", empInfo.Phone),
                new SqlParameter("@RoleId", empInfo.RoleId),
                new SqlParameter("@EmpId", empInfo.EmpId)
            };
            if(SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, SQL_UPDATE_EMP, parms)!=1)
            {
                throw new ApplicationException("修改员工失败!");
            }
        }

    }
}
