﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Model;
using IDAL;
using DBUtility;
using System.Data;
using System.Data.SqlClient;

namespace SQLServerDAL
{
    public class LariageDAL
    {
        #region 资产入库
        public int AddLairage(LairageInfo lairageInfo)
        {
            string sql = "insert into LairageInfo values(@AssetId,@Price,@Account,@LairageDate)";
            try
            {
                SqlParameter[] par = new SqlParameter[] { 
                    new SqlParameter("@AssetId",lairageInfo.AssetInfo.AssetId),
                    new SqlParameter("@Price",lairageInfo.Price),
                    new SqlParameter("@Account",lairageInfo.Account),
                    new SqlParameter("@LairageDate",lairageInfo.LairageDate)
            };
                int lairageId = SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, sql, par);
                return lairageId;
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                throw e;
            }
        }
        #endregion
        #region 显示入库信息
        public List<vw_Lairage> ShowLariage(string AssetName)
        {
            List<vw_Lairage> vw_LairageList = new List<vw_Lairage>();
            string sql = "select * from vw_Lairage where AssetName='"+AssetName+"'";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    vw_Lairage vwlairage = new vw_Lairage();
                    vwlairage.AssetId = (int)reader["AssetId"];
                    vwlairage.AssetName = (string)reader["AssetName"];
                    vwlairage.TypeId = (int)reader["TypeId"];
                    vwlairage.TypeName = (string)reader["TypeName"];
                    vwlairage.LairageDate = (DateTime)reader["LairageDate"];
                    vwlairage.OrganName = (string)reader["OrganName"];
                    vwlairage.StorageId = (int)reader["StorageId"];
                    vwlairage.StorageName = (string)reader["StorageName"];
                    vwlairage.Model = (string)reader["Model"];
                    vwlairage.Account = (int)reader["Account"];
                    vwlairage.Price = (decimal)reader["Price"];
                    vw_LairageList.Add(vwlairage);
                }
                return vw_LairageList;
            }
        }
        #endregion
        #region 根据编号显示入库信息
        public List<vw_Lairage> ShowLairageById(int assetId)
        {
            List<vw_Lairage> vwList = new List<vw_Lairage>();
            string sql = "select * from vw_Lairage where AssetId=" + assetId+"order by AssetId desc";
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    vw_Lairage vwlairage = new vw_Lairage();
                    vwlairage.AssetId = (int)reader["AssetId"];
                    vwlairage.AssetName = (string)reader["AssetName"];
                    vwlairage.TypeId = (int)reader["TypeId"];
                    vwlairage.TypeName = (string)reader["TypeName"];
                    vwlairage.LairageDate = (DateTime)reader["LairageDate"];
                    vwlairage.OrganName = (string)reader["OrganName"];
                    vwlairage.StorageId = (int)reader["StorageId"];
                    vwlairage.StorageName = (string)reader["StorageName"];
                    vwlairage.Model = (string)reader["Model"];
                    vwlairage.Account = (int)reader["Account"];
                    vwlairage.Price = (decimal)reader["Price"];
                    vwList.Add(vwlairage);
                }
                return vwList;
            }
        }
        #endregion
    }
}
