﻿using System;
using System.Collections.Generic;
using Model;
using IDAL;
using DBUtility;
using System.Data;
using System.Data.SqlClient;


namespace SQLServerDAL
{
    public class StockDAL
    {
        public List<StockInfo> GetStockInfoByNoStatus(string noState)
        {
            string sql = "select * from StockInfo where StockState!=@StockState";
            SqlParameter parm = new SqlParameter("@StockState", noState);
            List<StockInfo> list = new List<StockInfo>();

            using (SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, parm))
            {
                while (dr.Read())
                {
                    StockInfo item = new StockInfo(dr.GetGuid(0), dr.GetGuid(1), dr.GetString(2), dr.GetString(3), dr.GetString(4), dr.GetString(5));
                    list.Add(item);
                }
            }
            return list;
        }

        //通过状态查询记录
        public List<StockInfo> GetStockInfoByStatus(string state)
        {
            string sql = "select * from StockInfo where StockState=@StockState";
            SqlParameter parm = new SqlParameter("@StockState", state);
            List<StockInfo> list = new List<StockInfo>();

            using(SqlDataReader dr=SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text,sql,parm))
            {
                while(dr.Read())
                {
                    StockInfo item = new StockInfo(dr.GetGuid(0), dr.GetGuid(1), dr.GetString(2), dr.GetString(3), dr.GetString(4), dr.GetString(5));
                    list.Add(item);
                }
            }
            return list;
        }

        //通过状态查询记录2
        public List<StockInfo> GetStockInfoByStatus(string state1,string state2)
        {
            string sql = "select * from StockInfo where StockState=@StockState1 or StockState=@StockState2";
            SqlParameter[] parms = new SqlParameter[]
            {
                new SqlParameter("@StockState1", state1),
                new SqlParameter("@StockState2", state2)
            };
            List<StockInfo> list = new List<StockInfo>();

            using (SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, parms))
            {
                while (dr.Read())
                {
                    StockInfo item = new StockInfo(dr.GetGuid(0), dr.GetGuid(1), dr.GetString(2), dr.GetString(3), dr.GetString(4), dr.GetString(5));
                    list.Add(item);
                }
            }
            return list;
        }


        //通过StockId获取StockInfo
        public StockInfo GetStockInfoById(Guid stockId)
        {
            string sql = "select * from StockInfo where StockId=@StockId";
            SqlParameter parm = new SqlParameter("@StockId", stockId);
            StockInfo item = null;

            using(SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text,sql,parm))
            {
                if(dr.Read())
                {
                    item = new StockInfo(dr.GetGuid(0),dr.GetGuid(1), dr.GetString(2), dr.GetString(3), dr.GetString(4), dr.GetString(5));
                }
            }
            return item;
        }


        //添加StockInfo
        public void AddStockInfo(StockInfo stockInfo)
        {
            string sql = "insert into StockInfo values(@StockId,@WFId,@StockPerson,@StockDetail,@StockDate,@StockState)";
            SqlParameter[] parms = new SqlParameter[]
            {
                new SqlParameter("@StockId",stockInfo.StockId),
                new SqlParameter("@WFId",stockInfo.WfId),
                new SqlParameter("@StockPerson",stockInfo.StockPerson),
                new SqlParameter("@StockDetail",stockInfo.StockDetail),
                new SqlParameter("@StockDate",stockInfo.StockDate),
                new SqlParameter("@StockState",stockInfo.StockState)
            };

            if(SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text,sql,parms)!=1)
            {
                throw new ApplicationException("添加失败!");
            }
        }


        //更新StockInfo
        public void UpdateStockInfo(StockInfo stockInfo)
        {
            string sql = "update StockInfo set StockState=@StockState   where WFId=@WFId";
            SqlParameter[] parms = new SqlParameter[]
            {
                new SqlParameter("@WFId",stockInfo.WfId),
                new SqlParameter("@StockState",stockInfo.StockState)
            };
            if (SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, CommandType.Text, sql, parms) != 1)
            {
                throw new ApplicationException("更新失败!");
            }
        }
    }
}
