﻿using System;
using System.Collections.Generic;
using IDAL;
using Model;
using DBUtility;
using System.Data.SqlClient;
using System.Data;

namespace SQLServerDAL
{
    public class StorageInfoDAL
    {
        public string GetNameByStorageId(int id)
        {
            string name = null;
            string sql = "select StorageName from StorageInfo where StorageId=@StorageId";
            SqlParameter parm = new SqlParameter("@StorageId",id);

            using(SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql,parm))
            {
                if (dr.Read())
                    name = dr.GetString(0);
            }
            return name;
        }


        public List<StorageInfo> GetAllStorageInfo()
        {
            string sql = "select * from StorageInfo";
            List<StorageInfo> list = new List<StorageInfo>();

            using (SqlDataReader dr = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (dr.Read())
                {
                    StorageInfo item = new StorageInfo();
                    item.StorageId = dr.GetInt32(0);
                    item.StorageName = dr.GetString(1);
                    item.OrganInfo.OrganId = dr.GetInt32(2);
                    list.Add(item);
                }
            }
            return list;
        }
    }
}
