﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using IDAL;
using Model;
using DBUtility;
using System.Data.SqlClient;
using System.Data;

namespace SQLServerDAL
{
    public  class TypeDAL : ITypeInfo
    {
        public List<TypeInfo> getAllTypeInfo()
        {
            string SQL_TYPE_NAME = "select * from TypeInfo";
            using (SqlDataReader read = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_TYPE_NAME, null))
            {
                List<TypeInfo> list = new List<TypeInfo>();
                while (read.Read())
                {
                    TypeInfo ti = new TypeInfo();
                    ti.TypeId = read.GetInt32(0);
                    ti.TypeName = read.GetString(1);
                    ti.ParentTypeId = read.GetInt32(2);
                    list.Add(ti);
                }
                return list;
            }
        }

        //根据TypeId或ParentTypeId获取相应类别信息
        public List<TypeInfo> getParentTypeName(int Id)
        {
            string SQL_TYPE_NAME = "select * from TypeInfo where ParentTypeId=" + Id;
            using (SqlDataReader read = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_TYPE_NAME, null))
            {
                List<TypeInfo> list = new List<TypeInfo>();
                while (read.Read())
                {
                    TypeInfo ti = new TypeInfo();
                    ti.TypeId = read.GetInt32(0);
                    ti.TypeName = read.GetString(1);
                    ti.ParentTypeId = read.GetInt32(2);
                    list.Add(ti);
                }
                 return list;
            }
           
        }

        //添加
        public int addTypeInfo(string tn, int pt)
        {
            string SQL_ADD_TYPE_INFO =string.Format("insert into TypeInfo(TypeName,ParentTypeId) values('{0}','{1}')",tn,pt);
            return  SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_ADD_TYPE_INFO, null);
        }

        //删除
        public int removeTypeInfo(int val)
        {
            string SQL_DEL_TYPE_NAME = "delete TypeInfo where TypeId=" + val;
            return SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString,System.Data.CommandType.Text,SQL_DEL_TYPE_NAME,null);
        }

        //修改
        public int updateTypeInfo(string tn, int ti)
        {
            string SQL_UPDATE_TYPE_INFO = string.Format("update TypeInfo set TypeName = '{0}' where TypeId={1}",tn,ti);
            return SQLHelper.ExecuteNonQuery(SQLHelper.ConnectionString, System.Data.CommandType.Text, SQL_UPDATE_TYPE_INFO, null);
        }



        //判断某类别是否存在
        public bool checkTypeInfo(string typeName, int ParentTypeId,int st)
        {
            string SQL_SEL_TYPE = "select * from TypeInfo ";
            SqlDataReader dr= SQLHelper.ExecuteReader(SQLHelper.ConnectionString, System.Data.CommandType.Text,SQL_SEL_TYPE,null);
            while (dr.Read())
            {
                if (st == 1)
                {
                    if (dr.GetString(1).Equals(typeName) && dr.GetInt32(0).Equals(ParentTypeId))//修改判断
                    {
                        return false;
                    }
                }
                else if(st == 2)
                {
                    if (dr.GetString(1).Equals(typeName) && dr.GetInt32(2).Equals(ParentTypeId))//修改判断
                    {
                        return false;
                    }
                }
            } 
            return true;
        }




        #region 根据编号查询类别信息
        public TypeInfo GetTypeById(int typeId)
        {
            TypeInfo typeInfo = new TypeInfo();
            string sql = "select * from TypeInfo where TypeId=" + typeId;
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                if (reader.Read())
                {
                    typeInfo.TypeId = (int)reader["TypeId"];
                    typeInfo.TypeName = (string)reader["TypeName"];
                    typeInfo.ParentTypeId = (int)reader["ParentTypeId"];
                    return typeInfo;
                }
                else
                {
                    return null;
                }
            }


        }
        #endregion

        #region 查询类别信息
        public List<TypeInfo> GetTypeInfo(int praentId)
        {
            List<TypeInfo> typeList = new List<TypeInfo>();
            string sql = "select * from TypeInfo where ParentTypeId=" + praentId;
            using (SqlDataReader reader = SQLHelper.ExecuteReader(SQLHelper.ConnectionString, CommandType.Text, sql, null))
            {
                while (reader.Read())
                {
                    TypeInfo typeInfo = new TypeInfo();
                    typeInfo.TypeId = (int)reader["TypeId"];
                    typeInfo.TypeName = (string)reader["TypeName"];
                    typeInfo.ParentTypeId = (int)reader["ParentTypeId"];
                    typeList.Add(typeInfo);
                }
                return typeList;
            }
        }
        #endregion

    }
}
