﻿using System;
using AssetWorkflow;
using BLL;
using IDAL;
using System.Workflow.Activities;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Configuration;
////51/a/spx/.com/
public  class WorkFlowHelper
{
    //运行环境
    public WorkflowRuntime runtime;
    //运行实例
    public WorkflowInstance instance =null;
    //外部数据交换
    public ExternalDataExchangeService service;
    //SQL数据持久
    public WorkflowPersistenceService perService;

    public Project project;




    public WorkFlowHelper()
    { 
        //加载工作流的环境
        runtime = new WorkflowRuntime();
        project = new Project();
        service = new ExternalDataExchangeService();
        perService = new SqlWorkflowPersistenceService(ConfigurationManager.ConnectionStrings["perstr"].ConnectionString.ToString());
        //服务不能重复加入
        if (runtime.GetService(service.GetType()) == null)//服务不能重复加入
        {
            runtime.AddService(service);
        }
        if (runtime.GetService(perService.GetType()) == null)
        {
            runtime.AddService(perService);
        }
        if (service.GetService(project.GetType()) == null)
        {
            service.AddService(project);//将此类加入外部数据交换服务
        }

        runtime.WorkflowIdled += OnWorkflowIdled;
        runtime.StartRuntime();
    }

    protected void OnWorkflowIdled(object sender, WorkflowEventArgs e)
    {
        e.WorkflowInstance.TryUnload();
    }
}
