﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using Model;
using BLL;
using IDAL;
using System.Drawing;

public partial class Task_Admin : System.Web.UI.Page
{


    protected void Page_Load(object sender, EventArgs e)
    {
        if(!Page.IsPostBack)//当页面首次加载时
        {
            BindData();
        }
    }




    //显示数据
    private void BindData()
    {
        this.GridView1.DataSource = StockInfoBLL.GetStockInfoByNoStatus("结束");
        this.GridView1.DataBind();
    }






    //提交采购事件
    protected void btnOk_Click(object sender, EventArgs e)
    {
        WorkFlowHelper wfh = new WorkFlowHelper();
        wfh.instance = wfh.runtime.CreateWorkflow(typeof(AssetWorkflow.Workflow1));
        wfh.instance.Start();

        StockInfo info = new StockInfo(Guid.NewGuid(), wfh.instance.InstanceId, "后勤管理员", this.txtStockDetail.Text.Trim(), DateTime.Now.ToShortDateString(), "等待校长审批");
        wfh.project.RaiseAdminSubmit(info);

        Page.ClientScript.RegisterStartupScript(this.GetType(), "", "<script>alert('提交成功');location.href=location.href;</script>");
        
    }


  

    //行邦定事件
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if(e.Row.RowType == DataControlRowType.DataRow)//如果当前是数据行
        {
            CheckBox cb = e.Row.FindControl("CheckBox1") as CheckBox;
            int index = e.Row.RowIndex+2;
            string n = "0";
            if (index <= 9)
                n = "0" + index.ToString();
            else
                n = index.ToString(); 
            string value = string.Format("GetAllCheckBox(this,GridView1_ctl{0}_HiddenField1)",n);
            cb.Attributes.Add("onclick", value);
        }
    }


    //删除事件
    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            Guid wfId = new Guid(this.HiddenWfId.Value.Trim());
            WorkFlowHelper wfh = new WorkFlowHelper();
            wfh.runtime.GetWorkflow(wfId);
            StockInfo info = new StockInfo(Guid.NewGuid(), wfId, "", "", "", "结束");
            wfh.project.RaiseAdminDelete(info);
            wfh.runtime.GetWorkflow(wfId).TryUnload();

            Page.ClientScript.RegisterStartupScript(this.GetType(), "", "<script>alert('删除成功');location.href=location.href;</script>");
        }
        catch
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(), "", "<script>alert('只能删除被拒绝项');</script>");
        }
    }
}
