﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using Model;
using BLL;
using IDAL;

public partial class Task_CM : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)//当页面首次加载时
        {
            BindData();
        }
    }


    //显示数据
    private void BindData()
    {
        this.GridView1.DataSource = StockInfoBLL.GetStockInfoByStatus("等待董事长审批");
        this.GridView1.DataBind();
    }




    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)//如果当前是数据行
        {
            CheckBox cb = e.Row.FindControl("CheckBox1") as CheckBox;
            int index = e.Row.RowIndex + 2;
            string n = "0";
            if (index <= 9)
                n = "0" + index.ToString();
            else
                n = index.ToString();
            string value = string.Format("GetAllCheckBox(this,GridView1_ctl{0}_HiddenField1)", n);
            cb.Attributes.Add("onclick", value);
        }
    }



    //董事长通过
    protected void btnAddNewStock_Click(object sender, EventArgs e)
    {
        Guid wfId = new Guid(this.HiddenWfId.Value.Trim());

        WorkFlowHelper wfh = new WorkFlowHelper();
        wfh.runtime.GetWorkflow(wfId);
        StockInfo info = new StockInfo(Guid.NewGuid(), wfId, "", "", "", "董事长通过");
        wfh.project.RaiseCMSubMit(info);


        Page.ClientScript.RegisterStartupScript(this.GetType(), "", "<script>alert('提交成功');location.href=location.href;</script>");
    }


    //董事长拒绝
    protected void Button1_Click(object sender, EventArgs e)
    {
        Guid wfId = new Guid(this.HiddenWfId.Value.Trim());
        WorkFlowHelper wfh = new WorkFlowHelper();
        wfh.runtime.GetWorkflow(wfId);
        StockInfo info = new StockInfo(Guid.NewGuid(), wfId, "", "", "", "董事长拒绝");
        wfh.project.RaiseCMReject(info);
        wfh.runtime.GetWorkflow(wfId).TryUnload();

        Page.ClientScript.RegisterStartupScript(this.GetType(), "", "<script>alert('提交成功');location.href=location.href;</script>");
    }
}
