﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Generic;
using AjaxControlToolkit;
using Model;
using BLL;

public partial class AssetManage_AddAsset : System.Web.UI.Page
{
    public static TypeBLL typeBll = new TypeBLL();
    public static AddressBLL addressBll = new AddressBLL();
    public static AssetBll assetBll = new AssetBll();
    public static LariageBLL lariageBll = new LariageBLL();
    protected  bool temp = false;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            ShowOrgan();
            this.TreeView1.Nodes.Clear();
            TreeNode node = new TreeNode();
            node.Text = "资产类别";
            node.Value = "0";
            this.TreeView1.Nodes.Add(node);
            GetTreeNode(node);
        }
      
        
    }
    protected void GetTreeNode(TreeNode node)
    {
        int nodeId = Convert.ToInt32(node.Value);
        List<TypeInfo> list = typeBll.GetTypeInfo(nodeId);
        foreach (TypeInfo item in list)
        {
            TreeNode treeNode = new TreeNode();
            treeNode.Value = item.TypeId.ToString();
            treeNode.Text = item.TypeName.ToString();
            node.ChildNodes.Add(treeNode);
            GetTreeNode(treeNode);

        }
    }
    //显示所有存放地点
    protected void ShowOrgan()
    {
        List<OrganInfo> organList = addressBll.GetAllOrgan();
        foreach (OrganInfo organ in organList)
        {
            ListItem item = new ListItem();
            item.Value = organ.OrganId.ToString();
            item.Text = organ.OrganName;
            drpad1.Items.Add(item);
        }
    }
    //显示仓库
    protected void ShowStorage(int organId)
    {
        List<StorageInfo> storageList = addressBll.GetStorageByorgId(organId);
        foreach (StorageInfo storage in storageList)
        {
            ListItem item = new ListItem();
            item.Value = storage.StorageId.ToString();
            item.Text = storage.StorageName;
            drpad2.Items.Add(item);
        }
    }
    protected void drpad1_SelectedIndexChanged(object sender, EventArgs e)
    {
        drpad2.Items.Clear();
        int organId = Convert.ToInt32(drpad1.SelectedValue);
        ShowStorage(organId);
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        bool b = Convert.ToBoolean(Session["a"]);
        if (b == true)
        {
            int assetId = 0;
            for (int i = 0; i < gvAsset.Rows.Count; i++)
            {
                assetId = Convert.ToInt32((gvAsset.Rows[i].FindControl("lblId") as Label).Text);
            }
            //资产入库--更新数量
            AssetInfo asset = assetBll.GetAssetInfoById(assetId);
            AssetInfo assetInfo = new AssetInfo();
            assetInfo.AssetId = assetId;
            assetInfo.AssetName = asset.AssetName;
            assetInfo.TypeInfo = asset.TypeInfo;
            assetInfo.Model1 = asset.Model1;
            assetInfo.StorageId = asset.StorageId;
            assetInfo.TotalNum = Convert.ToInt32(txtAccount.Text) + asset.TotalNum;
            assetInfo.NowNum = Convert.ToInt32(txtAccount.Text) + asset.NowNum;
            assetInfo.TakeNum = asset.TakeNum;
            assetInfo.RepairNum = asset.RepairNum;
            assetInfo.BadNum = asset.BadNum;
            assetInfo.MoveNum = asset.MoveNum;
            int aId = assetBll.AddAssetInfo(assetInfo);

            decimal price = Convert.ToDecimal(txtPrice.Text);
            DateTime date = Convert.ToDateTime(txtDate.Text);
            int nowNum = Convert.ToInt32(txtAccount.Text);
            LairageInfo lairageInfo = new LairageInfo();
            lairageInfo.AssetInfo = asset;
            lairageInfo.Account = asset.NowNum+nowNum;
            lairageInfo.Price = price;
            lairageInfo.LairageDate = date;
            int lairageId = lariageBll.AddLairage(lairageInfo);
        }
        else
        {
            int typeId = Convert.ToInt32(this.TreeView1.SelectedNode.Value.ToString());
            lblTypeId.Text = typeId.ToString();
            //购买资产
            decimal price = Convert.ToDecimal(txtPrice.Text);
            DateTime date = Convert.ToDateTime(txtDate.Text);
            string assetName = txtAssetName.Text;
            string model = txtModel.Text;
            string type = txtType.Text;
            int temps = drpad2.SelectedIndex;
            int temp1 = Convert.ToInt32(drpad2.Items[temps].Value.ToString());

            int totalNum = Convert.ToInt32(txtAccount.Text);
            int nowNum = Convert.ToInt32(txtAccount.Text);

            AssetInfo assetInfo=new AssetInfo();
            assetInfo.AssetName=assetName;
            assetInfo.Model1=model;
            assetInfo.TypeInfo = typeBll.GetTypeById(Convert.ToInt32(lblTypeId.Text));
            assetInfo.StorageId = temp1;
            assetInfo.TotalNum = totalNum;
            assetInfo.NowNum = nowNum;
            assetInfo.RepairNum = 0;
            assetInfo.MoveNum = 0;
            assetInfo.BadNum = 0;
            assetInfo.TakeNum = 0;
            int assetId1=assetBll.BuyAssetInfo(assetInfo);


            int identityId = assetBll.getIdentity();
            LairageInfo lairageInfo = new LairageInfo();
            lairageInfo.AssetInfo = assetBll.GetAssetInfoById(identityId);
            lairageInfo.Account = nowNum;
            lairageInfo.Price = price;
            lairageInfo.LairageDate = date;
            int lairageId = lariageBll.AddLairage(lairageInfo);
            ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "确定", "alert('添加成功！');", true);
        }


    }
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        Label1.Text = "";
        string assetName = txtAssetName.Text;
        List<AssetInfo1> assetList = assetBll.GetAssetByName(assetName);
        if (assetList.Count != 0)
        {
            foreach (AssetInfo1 asset in assetList)
            {
                if (asset.AssetName.Equals(assetName))
                {
                    gvAsset.DataSource = lariageBll.ShowLariage(assetName);
                    gvAsset.DataBind();
                }
            }
            temp = true;
            Session["a"] = temp;
        }
        else
        {
            Label1.Text = "对不起,此资产不存在";
        }
    }

     protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
     {
         TreeNode s = this.TreeView1.SelectedNode.Parent;
         if (s != null)
         {
             TreeNode f = s.Parent;
             if (f != null)
             {
                 string name = this.TreeView1.SelectedNode.Text.ToString();
                 this.txtType.Text = name;
             }
             else
             {
                 lblAsset.Text = "请选择子类别";
             }
         }
         else
         {
             lblAsset.Text = "请选择子类别";
         }
     }
     protected void gvAsset_SelectedIndexChanged(object sender, EventArgs e)
     {
         GridViewRow row = this.gvAsset.SelectedRow;
          
         txtAssetName.Text = row.Cells[2].Text;
         txtModel.Text = row.Cells[7].Text;
         this.txtDate.Text = row.Cells[4].Text;
         this.txtPrice.Text = row.Cells[9].Text;
         txtType.Text = row.Cells[3].Text;
         txtAccount.Text = row.Cells[8].Text;
         drpad1.Items.Clear();
         drpad2.Items.Clear();
         ListItem item = new ListItem();
         item.Text = row.Cells[5].Text;
         drpad1.Items.Add(item);
         ListItem item1 = new ListItem();
         item1.Text = row.Cells[6].Text;
         drpad2.Items.Add(item1);
     }
     protected void Button1_Click(object sender, EventArgs e)
     {
         this.txtAssetName.Text = "";
         this.txtType.Text = "";
         this.txtModel.Text = "";
         this.txtAccount.Text = "";
         this.txtDate.Text = "";
         this.drpad1.Items.Clear();
         this.drpad2.Items.Clear();
         this.txtPrice.Text = "";
         gvAsset.DataSource = null;
         gvAsset.DataBind();
     }
}
