﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Generic;
using Model;
using BLL;


public partial class AssetManage_AssetInfo : System.Web.UI.Page
{
    protected static AssetBll assetBll = new AssetBll();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            gvAsset.DataSource = assetBll.GetAssetByNowNum();
            gvAsset.DataBind();
            if ((Session["emp"] as EmpInfo).RoleId == 3 || (Session["emp"] as EmpInfo).RoleId == 4)
            {
                this.btnBad.Visible = false;
                this.btnDiao.Visible = false;
                this.btnRepair.Visible = false;
                this.btnTake.Visible = false;
            }
        }
    }
    protected void gvAsset_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvAsset.PageIndex = e.NewPageIndex;
        gvAsset.DataSource = assetBll.GetAssetByNowNum();
        gvAsset.DataBind();
    }
    protected void btnTake_Click(object sender, EventArgs e)
    {
        int assetId=Convert.ToInt32(this.HiddenAssetId.Value);
        AssetInfo1 assetInfo = assetBll.GetAssetById(assetId);
        Response.Redirect("TakeAsset.aspx?Id=" + assetId);
    }
    protected void btnDiao_Click(object sender, EventArgs e)
    {
        int assetId=Convert.ToInt32(this.HiddenAssetId.Value);
        AssetInfo1 assetInfo = assetBll.GetAssetById(assetId);
       Response.Redirect("MoveAsset.aspx?Id=" + assetId); 
    }
    protected void btnRepair_Click(object sender, EventArgs e)
    {
        int assetId=Convert.ToInt32(this.HiddenAssetId.Value);
        AssetInfo1 assetInfo = assetBll.GetAssetById(assetId);
        Response.Redirect("RepairAsset.aspx?Id=" + assetId);
    }
    protected void btnBad_Click(object sender, EventArgs e)
    {
        int assetId=Convert.ToInt32(this.HiddenAssetId.Value);
        AssetInfo1 assetInfo = assetBll.GetAssetById(assetId);
        Response.Redirect("BadInfo.aspx?Id=" + assetId);
    }
    protected void gvAsset_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)//如果当前是数据行
        {
            CheckBox cb = e.Row.FindControl("CheckBox1") as CheckBox;
            int index = e.Row.RowIndex + 2;
            string n = "0";
            if (index <= 9)
                n = "0" + index.ToString();
            else
                n = index.ToString();
            string value = string.Format("GetAllCheckBox(this,gvAsset_ctl{0}_HiddenField1)", n);
            cb.Attributes.Add("onclick", value);
        }
    }
}
