﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Generic;
using Model;
using BLL;

public partial class AssetManage_MoveAsset : System.Web.UI.Page
{
    protected static AssetBll assetBll = new AssetBll();
    protected static AddressBLL addressBll = new AddressBLL();
    protected static TypeBLL typeBll = new TypeBLL();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            ShowOrgan();
            ShowAssetInfo();
        }

    }
    protected void ShowAssetInfo()
    {
        int assetId = Convert.ToInt32(Request.QueryString["Id"]);
        AssetInfo1 assetInfo = assetBll.GetAssetById(assetId);
        AssetInfo asset = assetBll.GetAssetInfoById(assetId);
        lblName.Text = assetInfo.AssetName;
        string datetime = DateTime.Now.ToString();
        txtTime.Text = datetime;
        txtAccount.Text = assetInfo.NowNum.ToString();
        lblOutOrgan.Text = assetInfo.OrganName;
        lblOutStorage.Text = assetInfo.StorageName;
        lblSId.Text = asset.StorageId.ToString();
    }
    //显示所有存放地点
    protected void ShowOrgan()
    {
        List<OrganInfo> organList = addressBll.GetAllOrgan();
        foreach (OrganInfo organ in organList)
        {
            ListItem item = new ListItem();
            item.Value = organ.OrganId.ToString();
            item.Text = organ.OrganName;
            drp1.Items.Add(item);
        }
    }
    //显示仓库
    protected void ShowStorage(int organId)
    {
        List<StorageInfo> storageList = addressBll.GetStorageByorgId(organId);
        foreach (StorageInfo storage in storageList)
        {
            ListItem item = new ListItem();
            item.Value = storage.StorageId.ToString();
            item.Text = storage.StorageName;
            drp2.Items.Add(item);
        }
    }
    protected void drp1_SelectedIndexChanged(object sender, EventArgs e)
    {
        drp2.Items.Clear();
        int organId = Convert.ToInt32(drp1.SelectedValue);
        ShowStorage(organId);
    }
    protected void btnFan_Click(object sender, EventArgs e)
    {
        Response.Redirect("AssetInfo.aspx");
    }
    protected void btnMove_Click(object sender, EventArgs e)
    {
        string assetName = lblName.Text;
        int account = Convert.ToInt32(txtAccount.Text);

        int assetId = Convert.ToInt32(Request.QueryString["Id"]);
        AssetInfo1 asset1 = assetBll.GetAssetById(assetId);
        if (account > asset1.NowNum)
        {
            lblShow.Text = "调拨数量不能大于库存数量";
        }
        int outStorageId = Convert.ToInt32(lblSId.Text);
        int temp = drp2.SelectedIndex;
        int inStorageId = Convert.ToInt32(drp2.Items[temp].Value);
        DateTime time = Convert.ToDateTime(txtTime.Text);
        string remark = txtRemark.Text;
        MoveInfo move = new MoveInfo();
        move.AssetId = assetId;
        move.StorageOutId = outStorageId;
        move.StorageInId = inStorageId;
        move.MoveNum = account;
        move.MoveDate = time;
        move.MoveCase = remark;
        int moveId = assetBll.MoveAsset(move);

        AssetInfo ass = assetBll.GetAssetInfoById(assetId);
        AssetInfo assetInfo = new AssetInfo();
        assetInfo.AssetId = ass.AssetId;
        assetInfo.AssetName = ass.AssetName;
        assetInfo.TypeInfo = ass.TypeInfo;
        assetInfo.Model1 = ass.Model1;
        assetInfo.StorageId = inStorageId;
        assetInfo.TotalNum = ass.TotalNum;
        assetInfo.NowNum = ass.NowNum-account;
        assetInfo.TakeNum = ass.TakeNum ;
        assetInfo.RepairNum = ass.RepairNum;
        assetInfo.BadNum = ass.BadNum;
        assetInfo.MoveNum =ass.MoveNum+account;
        int aId = assetBll.AddAssetInfo(assetInfo);
        ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "确定", "alert('调拨成功！');", true);
    }
}
