﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using Model;
using BLL;
using System.IO;

public partial class AssetManage_QueryMain : System.Web.UI.Page
{
    public static TypeBLL typeBll = new TypeBLL();


    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            this.TreeView1.Nodes.Clear();
            TreeNode node = new TreeNode();
            node.Text = "资产类别";
            node.Value = "0";
            this.TreeView1.Nodes.Add(node);
            GetTreeNode(node);
    
        }
    }



    protected void GetTreeNode(TreeNode node)
    {
        int nodeId = Convert.ToInt32(node.Value);
        List<TypeInfo> list = typeBll.GetTypeInfo(nodeId);
        foreach (TypeInfo item in list)
        {
            TreeNode treeNode = new TreeNode();
            treeNode.Value = item.TypeId.ToString();
            treeNode.Text = item.TypeName.ToString();
            node.ChildNodes.Add(treeNode);
            GetTreeNode(treeNode);

        }
    }



    protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
    {
        TreeNode s = this.TreeView1.SelectedNode.Parent;
        if (s !=null)
        {
            //TreeNode f = s.Parent;
            //if (f != null)
            //{
                string name = this.TreeView1.SelectedNode.Text.ToString();
                this.txtType.Text = name;
                //string sss = string.Format("alert('{0}');",this.TreeView1.SelectedNode.Value);
                //ScriptManager.RegisterStartupScript(this, this.GetType(), "确定", sss, true);
            //}
            //else
            //{
            //    lblAsset.Text = "请选择子类别";
            //}
        }
        else
        {
            lblAsset.Text = "请选择类别";
        }
    }





    public override void VerifyRenderingInServerForm(Control control)
    {

    }

    protected void btnExcel_Click(object sender, EventArgs e)
    {
        if (this.GridView1.Rows.Count != 0)
        {
            Response.ClearContent();
            Response.AddHeader("content-disposition", "attachment; filename=MyExcelFile.xls");
            Response.ContentType = "application/excel";

            StringWriter sw = new StringWriter();
            HtmlTextWriter htw = new HtmlTextWriter(sw);
            GridView1.RenderControl(htw);
            Response.Write(sw.ToString());
            Response.End(); 
        }
    }

    //开始查询
    protected void btnBeginSearch_Click1(object sender, EventArgs e)
    {
        string typeId = this.TreeView1.SelectedValue;
        if (this.TreeView1.SelectedValue != "" && this.TreeView1.SelectedValue != null)
        {
            this.GridView1.DataSource = new AssetBll().GetAssetByType(typeId);
            this.GridView1.DataBind();
        }
        
    }
}
