﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Generic;
using Model;
using BLL;

public partial class AssetManage_RepairAsset : System.Web.UI.Page
{
    protected static AssetBll assetBll = new AssetBll();
    protected static AddressBLL addressBll = new AddressBLL();
    protected static TypeBLL typeBll = new TypeBLL();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            ShowAssetInfo();
        }
    }
    protected void ShowAssetInfo()
    {
        int assetId = Convert.ToInt32(Request.QueryString["Id"]);
        AssetInfo1 assetInfo = assetBll.GetAssetById(assetId);
        lblName.Text = assetInfo.AssetName;
        string datetime = DateTime.Now.ToString();
        txtTime.Text = datetime;
        txtAccount.Text = assetInfo.NowNum.ToString();
    }
    protected void btnRepair_Click(object sender, EventArgs e)
    {
        int account = Convert.ToInt32(txtAccount.Text);

        int assetId = Convert.ToInt32(Request.QueryString["Id"]);
        AssetInfo1 asset1 = assetBll.GetAssetById(assetId);
        if (account > asset1.NowNum)
        {
            lblShow.Text = "维修数量不能大于库存数量";
        }
        DateTime time = Convert.ToDateTime(txtTime.Text);
        string remark = txtRemark.Text;
        RepairInfo repair = new RepairInfo();
        repair.AssetId = assetId;
        repair.RepairNum = account;
        repair.RepairDate = time;
        repair.RepairCase = remark;
        int repairId = assetBll.RepairAsset(repair);

        AssetInfo ass = assetBll.GetAssetInfoById(assetId);
        AssetInfo assetInfo = new AssetInfo();
        assetInfo.AssetId = ass.AssetId;
        assetInfo.AssetName = ass.AssetName;
        assetInfo.TypeInfo = ass.TypeInfo;
        assetInfo.Model1 = ass.Model1;
        assetInfo.StorageId = ass.StorageId;
        assetInfo.TotalNum = ass.TotalNum;
        assetInfo.NowNum = ass.NowNum - account;
        assetInfo.TakeNum = ass.TakeNum;
        assetInfo.RepairNum = ass.RepairNum+account;
        assetInfo.BadNum = ass.BadNum;
        assetInfo.MoveNum = ass.MoveNum;
        int aId = assetBll.AddAssetInfo(assetInfo);
        //ScriptManager.RegisterStartupScript(this.di, this.GetType(), "确定", "alert('维修成功！');", true);
    }
    protected void btnFan_Click(object sender, EventArgs e)
    {
        Response.Redirect("AssetInfo.aspx");
    }
}
