﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Generic;
using Model;
using BLL;

public partial class AssetManage_ReturnAsset : System.Web.UI.Page
{
    protected static AssetBll assetBll = new AssetBll();
    protected static AddressBLL addressBll = new AddressBLL();
    protected static TypeBLL typeBll = new TypeBLL();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            ShowAssetInfo();
            ShowOrgan();
        }
    }
    protected void ShowAssetInfo()
    {
        int assetId = Convert.ToInt32(Request.QueryString["Id"]);
        AssetInfo1 assetInfo = assetBll.GetAssetById(assetId);
        lblId.Text = assetInfo.AssetId.ToString();
        lblName.Text = assetInfo.AssetName;
        string datetime = DateTime.Now.ToString();
        txtTime.Text = datetime;
        txtAccount.Text = assetInfo.NowNum.ToString();
    }
    //显示所有存放地点
    protected void ShowOrgan()
    {
        List<OrganInfo> organList = addressBll.GetAllOrgan();
        foreach (OrganInfo organ in organList)
        {
            ListItem item = new ListItem();
            item.Value = organ.OrganId.ToString();
            item.Text = organ.OrganName;
            drpOrgan.Items.Add(item);

        }
    }
    //显示使用地点
    protected void ShowAddress(int organId)
    {
        List<AddressInfo> addressList = addressBll.GetAddressByorgId(organId);
        foreach (AddressInfo address in addressList)
        {
            ListItem item = new ListItem();
            item.Value = address.AddressId.ToString();
            item.Text = address.AddressName;
            drpAddress.Items.Add(item);
        }
    }
    protected void drpOrgan_SelectedIndexChanged(object sender, EventArgs e)
    {
        drpAddress.Items.Clear();
        int organId = Convert.ToInt32(drpOrgan.SelectedValue);
        ShowAddress(organId);
    }
    protected void btnFan_Click(object sender, EventArgs e)
    {
        Response.Redirect("Take.aspx");
    }
    protected void btnTake_Click(object sender, EventArgs e)
    {
        int assetId = Convert.ToInt32(lblId.Text);
        string assetName = lblName.Text;
        int account = Convert.ToInt32(txtAccount.Text);

        AssetInfo1 asset1 = assetBll.GetAssetById(assetId);
        if (account > asset1.NowNum)
        {
            lblShow.Text = "归还数量不能大于库存数量";
        }
        DateTime time = Convert.ToDateTime(txtTime.Text.ToString());
        int temp = drpAddress.SelectedIndex;
        int temp1 = Convert.ToInt32(drpAddress.Items[temp].Value);
        string takeuser = txtUser.Text;
        TakeInfo takeInfo = new TakeInfo();
        takeInfo.AssetId = assetId;
        takeInfo.ReturnAccount = account;
        takeInfo.TakeAccount = 0;
        takeInfo.AddressId = temp1;
        takeInfo.TakeDate = time;
        takeInfo.TakeUser = takeuser;
        int takeId = assetBll.TakeAssetInfo(takeInfo);

        AssetInfo ass = assetBll.GetAssetInfoById(assetId);
        AssetInfo assetInfo = new AssetInfo();
        assetInfo.AssetName = ass.AssetName;
        assetInfo.TypeInfo = ass.TypeInfo;
        assetInfo.Model1 = ass.Model1;
        assetInfo.StorageId = ass.StorageId;
        assetInfo.TotalNum = ass.TotalNum;
        assetInfo.NowNum = ass.NowNum - account;
        assetInfo.TakeNum = ass.TakeNum - account;
        assetInfo.RepairNum = ass.RepairNum;
        assetInfo.BadNum = ass.BadNum;
        assetInfo.MoveNum = ass.MoveNum;
        int aId = assetBll.AddAssetInfo(assetInfo);
        ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "确定", "alert('归还成功！');", true);
    }
}
