﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using BLL;
using Model;

public partial class BaseManage_BranchManage : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            GridBind();
            this.GridView1.PageIndex = 0;
            OrganBLL ob = new OrganBLL();
            this.DropDownList1.DataSource = ob.getOrganInfo();
            this.DropDownList1.DataTextField = "OrganName";//指定绑定的字段项
            this.DropDownList1.DataValueField = "OrganId";//指定绑定的项值   
            this.DropDownList1.Items.Insert(0, new ListItem("--请选择--"));//设置提示文本（设置此项时要将AppendDataBoundItems属性改为true）
            this.DropDownList1.DataBind();
            this.TextBox1.Attributes.Add("OnClick","this.value='';");
        }
    }

    AddressBLL ab=null;
    private void GridBind()
    {
        ab = new AddressBLL();
        GridView1.DataSource= ab.getAddressInfo();
        GridView1.DataBind();
    }
 
    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        int id=Convert.ToInt32( e.CommandArgument.ToString());
        Response.Cookies["ck"].Value=id.ToString();//将AddressId存入Cookie
        if (e.CommandName == "Oprate")
        {
            ab = new AddressBLL();
            List<AddressInfo> list=ab.getAddressInfo(id);
            foreach (AddressInfo ai in list)
            {
               this.TextBox1.Text= ai.AddressName;
               this.DropDownList1.SelectedValue =ai.OrganId.OrganId.ToString();
                
            }
            
        }
    }

    //添加
    protected void Button1_Click(object sender, EventArgs e)
    {
        
        ab = new AddressBLL();
        string val=this.TextBox1.Text.Trim();
        string val2=this.DropDownList1.SelectedValue;
        string val3 = this.DropDownList1.SelectedItem.Text;
        if (!val.Equals("") && val != null && !val2.Equals("--请选择--"))
        {
            if (ab.getAddressInfo(val,Convert.ToInt32(val2)))
            {
                if (ab.addAddressInfo(val, Convert.ToInt32(val2)))
                {
                    ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('操作成功！');", true);
                    this.TextBox1.Text = "";
                    this.DropDownList1.SelectedValue = "--请选择--";
                    GridBind();
                }
                else
                {
                    ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('操作有误！');", true);
                    GridBind();
                }
            }
            else
            {
                ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('您要录入的信息已存在！');", true);
                GridBind();    
            }
        }
        else
        {
            ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('提交的信息不完成！');", true);
            GridBind();
        }
    }

    //修改
    protected void Button2_Click(object sender, EventArgs e)
    {
        ab = new AddressBLL();
        string val = this.TextBox1.Text.Trim();
        string val2 = this.DropDownList1.SelectedValue;
       
        if (!val.Equals("") && val != null && !val2.Equals("--请选择--"))
        { 
            string cookie = Request.Cookies["ck"].Value;
            if (ab.getAddressInfo(val, Convert.ToInt32(val2)))
            {
                if (ab.amendAddressInfo(val, Convert.ToInt32(val2), Convert.ToInt32(cookie)))
                {
                    ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('操作成功！');", true);
                    this.TextBox1.Text = "";
                    this.DropDownList1.SelectedValue = "--请选择--";
                    GridBind();
                }
                else
                {
                    ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('操作有误！');", true);
                    GridBind();
                }
            }
            else
            {
                ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('操作无修改！');", true);
                GridBind();
            }
        }
        else
        {
            ScriptManager.RegisterStartupScript(this.UpdatePanel1, this.GetType(), "警告", "alert('提交的信息不完全！');", true);
            GridBind();
        }
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onmouseover", "currentcolor=this.style.backgroundColor;this.style.backgroundColor='#6699ff'");
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor");

        }
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        int index=e.NewPageIndex;
        //ab = new AddressBLL();  this.GridView1.AllowPaging = true;
        //this.GridView1.DataSource= ab.setPaging(index);
        //this.GridView1.DataBind();
        this.GridView1.PageIndex = index;
        GridBind();
    }
}
