using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using RedGlovePermission.DBUtility;

namespace RedGlovePermission.DAL
{
	/// <summary>
	/// ݷRGP_ModuleType
	/// </summary>
	public class RGP_ModuleType
	{
		public RGP_ModuleType()
		{}

        /// <summary>
        /// жģǷ
        /// </summary>
        /// <param name="ModuleTypeName">ģ</param>
        /// <returns></returns>
        public bool Exists(string ModuleTypeName)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from RGP_ModuleType");
            strSql.Append(" where ModuleTypeName=@ModuleTypeName ");
			SqlParameter[] parameters = {
					new SqlParameter("@ModuleTypeName", SqlDbType.NVarChar,30)};
            parameters[0].Value = ModuleTypeName;

			return SqlServerHelper.Exists(strSql.ToString(),parameters);
		}

        /// <summary>
        /// һģ
        /// </summary>
        /// <param name="model">ģʵ</param>
        /// <returns></returns>
        public bool CreateModuleType(RedGlovePermission.Model.RGP_ModuleType model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into RGP_ModuleType(");
			strSql.Append("ModuleTypeName,ModuleTypeOrder,ModuleTypeDescription)");
			strSql.Append(" values (");
			strSql.Append("@ModuleTypeName,@ModuleTypeOrder,@ModuleTypeDescription)");
			SqlParameter[] parameters = {
					new SqlParameter("@ModuleTypeName", SqlDbType.NVarChar,30),
					new SqlParameter("@ModuleTypeOrder", SqlDbType.Int,4),
					new SqlParameter("@ModuleTypeDescription", SqlDbType.NVarChar,50)};
			parameters[0].Value = model.ModuleTypeName;
			parameters[1].Value = model.ModuleTypeOrder;
			parameters[2].Value = model.ModuleTypeDescription;

            if (SqlServerHelper.ExecuteSql(strSql.ToString(), parameters) >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
		}

        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model">ģʵ</param>
        /// <returns></returns>
        public bool UpdateModuleType(RedGlovePermission.Model.RGP_ModuleType model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update RGP_ModuleType set ");
			strSql.Append("ModuleTypeName=@ModuleTypeName,");
			strSql.Append("ModuleTypeOrder=@ModuleTypeOrder,");
			strSql.Append("ModuleTypeDescription=@ModuleTypeDescription");
			strSql.Append(" where ModuleTypeID=@ModuleTypeID");
			SqlParameter[] parameters = {
					new SqlParameter("@ModuleTypeID", SqlDbType.Int,4),
					new SqlParameter("@ModuleTypeName", SqlDbType.NVarChar,30),
					new SqlParameter("@ModuleTypeOrder", SqlDbType.Int,4),
					new SqlParameter("@ModuleTypeDescription", SqlDbType.NVarChar,50)};
			parameters[0].Value = model.ModuleTypeID;
			parameters[1].Value = model.ModuleTypeName;
			parameters[2].Value = model.ModuleTypeOrder;
			parameters[3].Value = model.ModuleTypeDescription;

            if (SqlServerHelper.ExecuteSql(strSql.ToString(), parameters) >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
		}

        /// <summary>
        /// ɾһ
        /// </summary>
        /// <param name="ModuleTypeID">ģID</param>
        /// <returns></returns>
        public int DeleteModuleType(int ModuleTypeID)
		{
            int ret = 0;
            string strSql1 = "Select ModuleID from RGP_Modules where ModuleTypeID=@ModuleTypeID";
            string strSql2 = "delete RGP_ModuleType where ModuleTypeID=@ModuleTypeID";

			SqlParameter[] parameters = {
					new SqlParameter("@ModuleTypeID", SqlDbType.Int,4)};
			parameters[0].Value = ModuleTypeID;

            if (!SqlServerHelper.Exists(strSql1, parameters))
            {
                if (SqlServerHelper.ExecuteSql(strSql2, parameters) >= 1) { ret = 1; }
            }
            else
            {
                ret = 2;
            }
            return ret;
		}

        /// <summary>
        /// õһģʵ
        /// </summary>
        /// <param name="ModuleTypeID">ģID</param>
        /// <returns></returns>
        public RedGlovePermission.Model.RGP_ModuleType GetModuleTypeModel(int ModuleTypeID)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 ModuleTypeID,ModuleTypeName,ModuleTypeOrder,ModuleTypeDescription from RGP_ModuleType ");
			strSql.Append(" where ModuleTypeID=@ModuleTypeID ");
			SqlParameter[] parameters = {
					new SqlParameter("@ModuleTypeID", SqlDbType.Int,4)};
			parameters[0].Value = ModuleTypeID;

			RedGlovePermission.Model.RGP_ModuleType model=new RedGlovePermission.Model.RGP_ModuleType();
			DataSet ds=SqlServerHelper.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["ModuleTypeID"].ToString()!="")
				{
					model.ModuleTypeID=int.Parse(ds.Tables[0].Rows[0]["ModuleTypeID"].ToString());
				}
				model.ModuleTypeName=ds.Tables[0].Rows[0]["ModuleTypeName"].ToString();
				if(ds.Tables[0].Rows[0]["ModuleTypeOrder"].ToString()!="")
				{
					model.ModuleTypeOrder=int.Parse(ds.Tables[0].Rows[0]["ModuleTypeOrder"].ToString());
				}
				model.ModuleTypeDescription=ds.Tables[0].Rows[0]["ModuleTypeDescription"].ToString();
				return model;
			}
			else
			{
				return null;
			}
		}

        /// <summary>
        /// ģб
        /// </summary>
        /// <param name="strWhere">Where</param>
        /// <param name="strOrder"></param>
        /// <returns></returns>
        public DataSet GetModuleTypeList(string strWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * FROM RGP_ModuleType ");

            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }
            strSql.Append(" order by ModuleTypeOrder asc");

            return SqlServerHelper.Query(strSql.ToString());
        }
	}
}

