using System;
using System.Collections;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using RedGlovePermission.DBUtility;

namespace RedGlovePermission.DAL
{
	/// <summary>
    /// ɫݷ
	/// </summary>
	public class RGP_Roles
	{
		public RGP_Roles()
		{}

        /// <summary>
        /// жϽɫǷ
        /// </summary>
        /// <param name="RoleName">ɫ</param>
        /// <param name="RoleGroupID">ɫID</param>
        /// <returns></returns>
        public bool Exists(string RoleName,int RoleGroupID)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from RGP_Roles");
            strSql.Append(" where RoleName=@RoleName and RoleGroupID=@RoleGroupID ");
			SqlParameter[] parameters = {
					new SqlParameter("@RoleName", SqlDbType.NVarChar,30),
                    new SqlParameter("@RoleGroupID", SqlDbType.Int,4)};
            parameters[0].Value = RoleName;
            parameters[1].Value = RoleGroupID;

			return SqlServerHelper.Exists(strSql.ToString(),parameters);
		}

        /// <summary>
        /// ӽɫ
        /// </summary>
        /// <param name="model">ɫʵ</param>
        /// <returns></returns>
		public bool CreateRole(RedGlovePermission.Model.RGP_Roles model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into RGP_Roles(");
            strSql.Append("RoleGroupID,RoleName,RoleDescription)");
			strSql.Append(" values (");
            strSql.Append("@RoleGroupID,@RoleName,@RoleDescription)");
			SqlParameter[] parameters = {
					new SqlParameter("@RoleGroupID", SqlDbType.Int,4),
					new SqlParameter("@RoleName", SqlDbType.NVarChar,30),
					new SqlParameter("@RoleDescription", SqlDbType.NVarChar,50)};
			parameters[0].Value = model.RoleGroupID;
			parameters[1].Value = model.RoleName;
			parameters[2].Value = model.RoleDescription;

            if (SqlServerHelper.ExecuteSql(strSql.ToString(), parameters) >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
		}

        /// <summary>
        /// ½ɫ
        /// </summary>
        /// <param name="model">ɫʵ</param>
        /// <returns></returns>
        public bool UpdateRole(RedGlovePermission.Model.RGP_Roles model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update RGP_Roles set ");
            strSql.Append("RoleGroupID=@RoleGroupID,");
			strSql.Append("RoleName=@RoleName,");
			strSql.Append("RoleDescription=@RoleDescription");
			strSql.Append(" where RoleID=@RoleID ");
			SqlParameter[] parameters = {
					new SqlParameter("@RoleID", SqlDbType.Int,4),
					new SqlParameter("@RoleGroupID", SqlDbType.Int,4),
					new SqlParameter("@RoleName", SqlDbType.NVarChar,30),
					new SqlParameter("@RoleDescription", SqlDbType.NVarChar,50)};
			parameters[0].Value = model.RoleID;
            parameters[1].Value = model.RoleGroupID;
			parameters[2].Value = model.RoleName;
			parameters[3].Value = model.RoleDescription;

            if (SqlServerHelper.ExecuteSql(strSql.ToString(), parameters) >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
		}

        /// <summary>
        /// ɾɫ
        /// </summary>
        /// <param name="RoleID">ɫID</param>
        /// <returns></returns>
        public int DeleteRole(int RoleID)
		{	
            int ret=0;
			SqlParameter[] parameters = {
					new SqlParameter("@RoleID", SqlDbType.Int,4)};
			parameters[0].Value = RoleID;

            string strSql1 = "Select userid from Users where RoleID=@RoleID";
            
            //ɾɫͬʱɾصȨ
            ArrayList list = new ArrayList();
            list.Add("delete RGP_RoleAuthorityList where RoleID=" + RoleID.ToString());
            list.Add("delete RGP_Roles where RoleID=" + RoleID.ToString());            

            if (!SqlServerHelper.Exists(strSql1, parameters))
            {
                try
                {
                    SqlServerHelper.ExecuteSqlTran(list);
                    ret = 1;
                }
                catch
                {
                    ;
                }
            }
            else
            {
                ret = 2;
            }
            return ret;
		}

        /// <summary>
        /// ȡɫʵ
        /// </summary>
        /// <param name="RoleID">ɫID</param>
        /// <returns></returns>
        public RedGlovePermission.Model.RGP_Roles GetRoleModel(int RoleID)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select top 1 * from RGP_Roles ");
			strSql.Append(" where RoleID=@RoleID ");
			SqlParameter[] parameters = {
					new SqlParameter("@RoleID", SqlDbType.Int,4)};
			parameters[0].Value = RoleID;

			RedGlovePermission.Model.RGP_Roles model=new RedGlovePermission.Model.RGP_Roles();
			DataSet ds=SqlServerHelper.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["RoleID"].ToString()!="")
				{
					model.RoleID=int.Parse(ds.Tables[0].Rows[0]["RoleID"].ToString());
				}
				if(ds.Tables[0].Rows[0]["RoleRoleID"].ToString()!="")
				{
                    model.RoleGroupID = int.Parse(ds.Tables[0].Rows[0]["RoleGroupID"].ToString());
				}
				model.RoleName=ds.Tables[0].Rows[0]["RoleName"].ToString();
				model.RoleDescription=ds.Tables[0].Rows[0]["RoleDescription"].ToString();
				return model;
			}
			else
			{
				return null;
			}
		}

        /// <summary>
        /// ýɫб
        /// </summary>
        /// <param name="strWhere">Where</param>
        /// <param name="strOrder"></param>
        /// <returns></returns>
        public DataSet GetRoleList(string strWhere,string strOrder)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * FROM RGP_Roles ");

            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }

            if (strOrder.Trim() != "")
            {
                strSql.Append(" " + strOrder);
            }

            return SqlServerHelper.Query(strSql.ToString());
        }
	}
}

