using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using RedGlovePermission.DBUtility;

namespace RedGlovePermission.DAL
{
	/// <summary>
	/// ݷUsers
	/// </summary>
	public class Users
	{
		public Users()
		{}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
        public bool Exists(string UserName)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from Users");
            strSql.Append(" where UserName=@UserName ");
			SqlParameter[] parameters = {
					new SqlParameter("@UserName", SqlDbType.NVarChar,128)};
            parameters[0].Value = UserName;

			return SqlServerHelper.Exists(strSql.ToString(),parameters);
		}
        
		/// <summary>
        /// һû
		/// </summary>
		/// <param name="model"></param>
		/// <returns></returns>
		public int CreateUser(RedGlovePermission.Model.Users model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into Users(");
			strSql.Append("UserName,Password,Question,Answer,RoleID,UserGroup,CreateTime,IsLimit)");
			strSql.Append(" values (");
			strSql.Append("@UserName,@Password,@Question,@Answer,@RoleID,@UserGroup,@CreateTime,@IsLimit)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@UserName", SqlDbType.NVarChar,128),
					new SqlParameter("@Password", SqlDbType.NVarChar,128),
					new SqlParameter("@Question", SqlDbType.NVarChar,100),
					new SqlParameter("@Answer", SqlDbType.NVarChar,100),
					new SqlParameter("@RoleID", SqlDbType.Int,4),
					new SqlParameter("@UserGroup", SqlDbType.Int,4),
					new SqlParameter("@CreateTime", SqlDbType.DateTime),
					new SqlParameter("@IsLimit", SqlDbType.Bit,1)};
			parameters[0].Value = model.UserName;
			parameters[1].Value = model.Password;
			parameters[2].Value = model.Question;
			parameters[3].Value = model.Answer;
			parameters[4].Value = model.RoleID;
			parameters[5].Value = model.UserGroup;
			parameters[6].Value = DateTime.Now;
			parameters[7].Value = model.IsLimit;

			object obj = SqlServerHelper.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 0;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}

        /// <summary>
        /// û¼
        /// </summary>
        public bool CheckLogin(string UserName, string pwd)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select count(1) from Users");
            strSql.Append(" where UserName=@UserName and Password=@Password");
            SqlParameter[] parameters = {
                     new SqlParameter("@UserName", SqlDbType.NVarChar,128),
					 new SqlParameter("@Password", SqlDbType.NVarChar,128)};
            parameters[0].Value = UserName;
            parameters[1].Value = pwd;

            return SqlServerHelper.Exists(strSql.ToString(), parameters);
        }

        /// <summary>
        /// жûԭǷȷ
        /// </summary>
        /// <param name="id">ûID</param>
        /// <param name="pwd">ԭ</param>
        /// <returns></returns>
        public bool VerifyPassword(int id, string pwd)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select count(1) from Users");
            strSql.Append(" where UserID=@UserID and Password=@Password");
            SqlParameter[] parameters = {
                     new SqlParameter("@UserID", SqlDbType.Int,4),
					 new SqlParameter("@Password", SqlDbType.NVarChar,128)};
            parameters[0].Value = id;
            parameters[1].Value = pwd;

            return SqlServerHelper.Exists(strSql.ToString(), parameters);
        }

        /// <summary>
        /// û
        /// </summary>
        /// <param name="id">ûID</param>
        /// <param name="pwd"></param>
        /// <returns></returns>
        public bool ChangePassword(int id, string pwd)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update Users set ");
            strSql.Append("Password=@Password");
            strSql.Append(" where UserID=@UserID");

            SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.Int,4),
					new SqlParameter("@Password", SqlDbType.NVarChar,128)};
            parameters[0].Value = id;
            parameters[1].Value = pwd;

            if (SqlServerHelper.ExecuteSql(strSql.ToString(), parameters) >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// °ȫϢ
        /// </summary>
        /// <param name="id">ûID</param>
        /// <param name="question"></param>
        /// <param name="answer"></param>
        /// <returns></returns>
        public bool ChangeSecureInfo(int id, string question, string answer)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update Users set ");
            strSql.Append("Question=@Question,Answer=@Answer");
            strSql.Append(" where UserID=@UserID");

            SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.Int,4),
					new SqlParameter("@Question", SqlDbType.NVarChar,100),
					new SqlParameter("@Answer", SqlDbType.NVarChar,100)};
            parameters[0].Value = id;
            parameters[1].Value = question;
            parameters[2].Value = answer;

            if (SqlServerHelper.ExecuteSql(strSql.ToString(), parameters) >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

		/// <summary>
		/// ɾû
		/// </summary>
		/// <param name="UserID">ûID</param>
		public bool DeleteUser(int UserID)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete Users ");
			strSql.Append(" where UserID=@UserID ");
			SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.Int,4)};
			parameters[0].Value = UserID;

            if (SqlServerHelper.ExecuteSql(strSql.ToString(), parameters) >= 1)
            {
                return true;
            }
            else
            {
                return false;
            }
		}

		/// <summary>
		/// IDõûʵ
		/// </summary>
		public RedGlovePermission.Model.Users GetUserModel(int UserID)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 UserID,UserName,Password,Question,Answer,RoleID,UserGroup,CreateTime,LastLoginTime,Status,IsOnline,IsLimit from Users ");
			strSql.Append(" where UserID=@UserID ");
			SqlParameter[] parameters = {
					new SqlParameter("@UserID", SqlDbType.Int,4)};
			parameters[0].Value = UserID;

			RedGlovePermission.Model.Users model=new RedGlovePermission.Model.Users();
			DataSet ds=SqlServerHelper.Query(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["UserID"].ToString()!="")
				{
					model.UserID=int.Parse(ds.Tables[0].Rows[0]["UserID"].ToString());
				}
				model.UserName=ds.Tables[0].Rows[0]["UserName"].ToString();
				model.Password=ds.Tables[0].Rows[0]["Password"].ToString();
				model.Question=ds.Tables[0].Rows[0]["Question"].ToString();
				model.Answer=ds.Tables[0].Rows[0]["Answer"].ToString();
				if(ds.Tables[0].Rows[0]["RoleID"].ToString()!="")
				{
					model.RoleID=int.Parse(ds.Tables[0].Rows[0]["RoleID"].ToString());
				}
				if(ds.Tables[0].Rows[0]["UserGroup"].ToString()!="")
				{
					model.UserGroup=int.Parse(ds.Tables[0].Rows[0]["UserGroup"].ToString());
				}
				if(ds.Tables[0].Rows[0]["CreateTime"].ToString()!="")
				{
					model.CreateTime=DateTime.Parse(ds.Tables[0].Rows[0]["CreateTime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["LastLoginTime"].ToString()!="")
				{
					model.LastLoginTime=DateTime.Parse(ds.Tables[0].Rows[0]["LastLoginTime"].ToString());
				}
                if (ds.Tables[0].Rows[0]["Status"].ToString() != "")
                {
                    model.Status = int.Parse(ds.Tables[0].Rows[0]["Status"].ToString());
                }				
				if(ds.Tables[0].Rows[0]["IsOnline"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["IsOnline"].ToString()=="1")||(ds.Tables[0].Rows[0]["IsOnline"].ToString().ToLower()=="true"))
					{
						model.IsOnline=true;
					}
					else
					{
						model.IsOnline=false;
					}
				}
				if(ds.Tables[0].Rows[0]["IsLimit"].ToString()!="")
				{
					if((ds.Tables[0].Rows[0]["IsLimit"].ToString()=="1")||(ds.Tables[0].Rows[0]["IsLimit"].ToString().ToLower()=="true"))
					{
						model.IsLimit=true;
					}
					else
					{
						model.IsLimit=false;
					}
				}
				return model;
			}
			else
			{
				return null;
			}
		}

        /// <summary>
        /// ûõûʵ
        /// </summary>
        public RedGlovePermission.Model.Users GetUserModel(string UserName)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select  top 1 UserID,UserName,Password,Question,Answer,RoleID,UserGroup,CreateTime,LastLoginTime,Status,IsOnline,IsLimit from Users ");
            strSql.Append(" where UserName=@UserName ");
            SqlParameter[] parameters = {
					new SqlParameter("@UserName", SqlDbType.NVarChar,128)};
            parameters[0].Value = UserName;

            RedGlovePermission.Model.Users model = new RedGlovePermission.Model.Users();
            DataSet ds = SqlServerHelper.Query(strSql.ToString(), parameters);
            if (ds.Tables[0].Rows.Count > 0)
            {
                if (ds.Tables[0].Rows[0]["UserID"].ToString() != "")
                {
                    model.UserID = int.Parse(ds.Tables[0].Rows[0]["UserID"].ToString());
                }
                model.UserName = ds.Tables[0].Rows[0]["UserName"].ToString();
                model.Password = ds.Tables[0].Rows[0]["Password"].ToString();
                model.Question = ds.Tables[0].Rows[0]["Question"].ToString();
                model.Answer = ds.Tables[0].Rows[0]["Answer"].ToString();
                if (ds.Tables[0].Rows[0]["RoleID"].ToString() != "")
                {
                    model.RoleID = int.Parse(ds.Tables[0].Rows[0]["RoleID"].ToString());
                }
                if (ds.Tables[0].Rows[0]["UserGroup"].ToString() != "")
                {
                    model.UserGroup = int.Parse(ds.Tables[0].Rows[0]["UserGroup"].ToString());
                }
                if (ds.Tables[0].Rows[0]["CreateTime"].ToString() != "")
                {
                    model.CreateTime = DateTime.Parse(ds.Tables[0].Rows[0]["CreateTime"].ToString());
                }
                if (ds.Tables[0].Rows[0]["LastLoginTime"].ToString() != "")
                {
                    model.LastLoginTime = DateTime.Parse(ds.Tables[0].Rows[0]["LastLoginTime"].ToString());
                }
                if (ds.Tables[0].Rows[0]["Status"].ToString() != "")
                {
                    model.Status = int.Parse(ds.Tables[0].Rows[0]["Status"].ToString());
                }
                if (ds.Tables[0].Rows[0]["IsOnline"].ToString() != "")
                {
                    if ((ds.Tables[0].Rows[0]["IsOnline"].ToString() == "1") || (ds.Tables[0].Rows[0]["IsOnline"].ToString().ToLower() == "true"))
                    {
                        model.IsOnline = true;
                    }
                    else
                    {
                        model.IsOnline = false;
                    }
                }
                if (ds.Tables[0].Rows[0]["IsLimit"].ToString() != "")
                {
                    if ((ds.Tables[0].Rows[0]["IsLimit"].ToString() == "1") || (ds.Tables[0].Rows[0]["IsLimit"].ToString().ToLower() == "true"))
                    {
                        model.IsLimit = true;
                    }
                    else
                    {
                        model.IsLimit = false;
                    }
                }
                return model;
            }
            else
            {
                return null;
            }
        }

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetUserList(string strWhere,string strOrder)
		{
			StringBuilder strSql=new StringBuilder();
            strSql.Append("SELECT dbo.Users.UserID, dbo.Users.UserName, dbo.Users.Password, dbo.Users.Question, dbo.Users.Answer,"); 
            strSql.Append("dbo.Users.RoleID, dbo.Users.UserGroup,dbo.Users.CreateTime, dbo.Users.LastLoginTime, dbo.Users.Status,");
            strSql.Append("dbo.Users.IsOnline, dbo.Users.IsLimit, dbo.RGP_Groups.GroupName, dbo.RGP_Roles.RoleName "); 
            strSql.Append("FROM dbo.Users INNER JOIN "); 
            strSql.Append("dbo.RGP_Roles ON dbo.Users.RoleID = dbo.RGP_Roles.RoleID INNER JOIN ");
            strSql.Append("dbo.RGP_Groups ON dbo.Users.UserGroup = dbo.RGP_Groups.GroupID"); 
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}

            if (strOrder.Trim() != "")
            {
                strSql.Append(" " + strOrder);
            }
			return SqlServerHelper.Query(strSql.ToString());
		}
	}
}

