﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

namespace RedGlovePermission.Web.Admin.Frameset
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!SessionBox.CheckUserSession())
            {
                Response.Redirect("~/WebManage/Default.aspx");
            }
            else
            {
                try
                {
                    if (!IsPostBack)
                    {
                        loginname.Text = SessionBox.GetUserSession().LoginName;
                        LoadModuleTree();//加载菜单
                    }
                }
                catch
                {
                    MenuTreeView.Nodes.Clear();
                }
            }
        }

        /// <summary>
        /// 加载菜单
        /// </summary>
        private void LoadModuleTree()
        {
            //获取当前登录的会员信息。
            UserSession user = SessionBox.GetUserSession();

            RedGlovePermission.BLL.RGP_ModuleType MTbll = new RedGlovePermission.BLL.RGP_ModuleType();
            RedGlovePermission.BLL.RGP_Modules Mbll = new RedGlovePermission.BLL.RGP_Modules();

            //获取所有顶层模块。
            DataSet ModuleType = MTbll.GetModuleTypeList("");

            //增加模块分类和模块。
            if (ModuleType.Tables[0].Rows.Count > 0)
            {
                foreach (DataRow dr in ModuleType.Tables[0].Rows)
                {
                    //添加顶级分类
                    TreeNode masterNode = new TreeNode(dr["ModuleTypeName"].ToString());
                    MenuTreeView.Nodes.Add(masterNode);
                    masterNode.SelectAction = TreeNodeSelectAction.Expand;
                    masterNode.Expanded = false;
                    int i = 0;
                    //增加子模块分类
                    DataSet Module = Mbll.GetModuleList("ModuleTypeID=" + dr["ModuleTypeID"].ToString());
                    foreach (DataRow child_dr in Module.Tables[0].Rows)
                    {
                        if ((user.IsLimit == true 
                            || (child_dr["ModuleDisabled"].ToString().ToLower() == "true"
                            && UserHandle.ValidationModule(int.Parse(child_dr["ModuleID"].ToString()), RGP_Tag.Browse))) 
                            && child_dr["IsMenu"].ToString().ToLower() == "true")
                        {
                            TreeNode childNode = new TreeNode(child_dr["ModuleName"].ToString());
                            childNode.Expanded = false;
                            childNode.NavigateUrl = child_dr["ModuleURL"].ToString();
                            childNode.Target = "modulePanel";
                            childNode.ToolTip = child_dr["ModuleDescription"].ToString();
                            masterNode.ChildNodes.Add(childNode);
                            i++;
                        }
                    }
                    //删除不必要的模块分类节点。
                    if (i == 0)
                    {
                        MenuTreeView.Nodes.Remove(masterNode);
                    }
                }

                MenuTreeView.CollapseImageToolTip = "";
                MenuTreeView.ExpandImageToolTip = "";
            }
        }

        /// <summary>
        /// 退出系统
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void lnkbtnLogout_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Logout.aspx");
        }
    }
}
