﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace RedGlovePermission.Web.Admin
{
    public partial class Login : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                Session["userLanguage"] = "zh-cn";
                UserName.Focus();
                btn_login.Attributes.Add("onclick", "return checklogin()");
            }
        }

        protected void btn_login_Click(object sender, ImageClickEventArgs e)
        {
            RedGlovePermission.BLL.Users bll = new RedGlovePermission.BLL.Users();
            RedGlovePermission.Model.Users model = new RedGlovePermission.Model.Users();

            if (UserName.Text.Trim() == "" || Password.Text.Trim() == "")
            {
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "", "alert('请输入完整的登录信息!');", true);
            }
            else
            {
                if (bll.CheckLogin(UserName.Text.Trim(), RedGlovePermission.Lib.SecurityEncryption.MD5(Password.Text.Trim(), 32)))
                {
                    model = bll.GetUserModel(UserName.Text.Trim());
                    if (model.RoleID != 0)
                    {
                        if (model.Status != 0)
                        {
                            SessionBox.CreateUserSession(new UserSession(model.UserID, model.UserName, model.RoleID, model.IsLimit, model.Status));
                            Response.Redirect("~/Admin/Frameset/Default.aspx");
                        }
                        else
                        {
                            ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "", "alert('用户或密码错误!');", true);
                        }
                    }
                    else
                    {
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "", "alert('用户还未激活,请与管理员联系!');", true);
                    }
                }
                else
                {
                    ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "", "alert('用户或密码错误!');", true);
                }
            }
        }
    }
}
