﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace RedGlovePermission.Web.Admin.Modubles.SysConfig
{
    public partial class ConfigPage : System.Web.UI.Page
    {
        RedGlovePermission.BLL.RGP_Configuration bll = new RedGlovePermission.BLL.RGP_Configuration();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!SessionBox.CheckUserSession())
            {
                Response.Redirect("~/Admin/Login.aspx");
            }
            else
            {
                //初始化模块权限
                UserHandle.InitModule("Mod_Config");
                if (!IsPostBack)
                {
                    BindOrder();
                }
            }
        }

        /// <summary>
        /// 将数据绑定到DataSet
        /// </summary>
        public void BindOrder()
        {
            DataSet ds = bll.GetItemList("");
            ConfigList.DataSource = ds;
            ConfigList.DataBind();
        }

        protected void ConfigList_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            ConfigList.PageIndex = e.NewPageIndex;
            BindOrder(); //重新绑定GridView数据的函数 
        }

        protected void ConfigList_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            ConfigList.EditIndex = -1;
            BindOrder();
        }

        protected void ConfigList_RowEditing(object sender, GridViewEditEventArgs e)
        {
            ConfigList.EditIndex = e.NewEditIndex;
            BindOrder();
        }

        protected void ConfigList_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {            
            int id = int.Parse(ConfigList.DataKeys[e.RowIndex].Values[0].ToString());
            string s = ((TextBox)ConfigList.Rows[e.RowIndex].FindControl("txt_value")).Text.Trim();

            if (!bll.UpdateItem(id,s))
            {
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('更新操作失败！')", true);
            }
            //返回浏览狀態
            ConfigList.EditIndex = -1;
            BindOrder();

        }

        protected void ConfigList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)//判定当前的行是否属于datarow类型的行
            {
                //当鼠标放上去的时候 先保存当前行的背景颜色 并给附一颜色
                e.Row.Attributes.Add("onmouseover", "currentcolor=this.style.backgroundColor;this.style.backgroundColor='#ffffcd',this.style.fontWeight='';");
                //当鼠标离开的时候 将背景颜色还原的以前的颜色
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor,this.style.fontWeight='';");
            }
        }
    }
}
