﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

/**************************************
 * 模块：模块分类数据管理
 * 作者：Nick.Yan
 * 日期: 2008-11-13
 * 网址：www.redglove.com.cn
 * ***********************************/

namespace RedGlovePermission.Web.Admin.Modubles.SysConfig
{
    public partial class ModuleTypePage : System.Web.UI.Page
    {
        RedGlovePermission.BLL.RGP_ModuleType bll = new RedGlovePermission.BLL.RGP_ModuleType();

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!SessionBox.CheckUserSession())
            {
                Response.Redirect("~/Admin/Login.aspx");
            }
            else
            {
                //初始化模块权限
                UserHandle.InitModule("Mod_ModuleType");
                if (!IsPostBack)
                {
                    btn_add.Attributes.Add("onclick", "return CheckAdd()");//加入验证
                    BindOrder();
                }
            }
        }

        /// <summary>
        /// 将数据绑定到DataSet
        /// </summary>
        public void BindOrder()
        {
            DataSet ds = bll.GetModuleTypeList("");

            if (ds.Tables[0].Rows.Count == 0)
                GridViewMsg.InnerText = "无相关记录";
            else
                GridViewMsg.InnerText = "共有" + ds.Tables[0].Rows.Count + "条记录";

            ModuleTypeList.DataSource = ds;
            ModuleTypeList.DataBind();
        }

        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ModuleTypeList_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            ModuleTypeList.PageIndex = e.NewPageIndex;
            BindOrder(); //重新绑定GridView数据的函数 
        }

        /// <summary>
        /// 退出编辑状态
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ModuleTypeList_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            ModuleTypeList.EditIndex = -1;
            BindOrder();
        }

        /// <summary>
        /// 执行事件（删除操作）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ModuleTypeList_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName.ToString() == "Del")
            {
                int ret = bll.DeleteModuleType(int.Parse(e.CommandArgument.ToString()));
                switch (ret)
                {
                    case 1:
                        BindOrder();
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('删除成功');", true);
                        break;
                    case 2:
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('分类下还存在模块，不能进行删除操作!');", true);
                        break;
                    default:
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('删除失败!');", true);
                        break;
                }
            }
        }

        /// <summary>
        /// 变更到编辑状态
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ModuleTypeList_RowEditing(object sender, GridViewEditEventArgs e)
        {
            ModuleTypeList.EditIndex = e.NewEditIndex;
            BindOrder();
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ModuleTypeList_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            RedGlovePermission.Model.RGP_ModuleType model = new RedGlovePermission.Model.RGP_ModuleType();
            model.ModuleTypeID = int.Parse(ModuleTypeList.DataKeys[e.RowIndex].Values[0].ToString());
            model.ModuleTypeName = ((TextBox)ModuleTypeList.Rows[e.RowIndex].FindControl("txt_name")).Text.Trim();
            model.ModuleTypeDescription = ((TextBox)ModuleTypeList.Rows[e.RowIndex].FindControl("txt_Description")).Text.Trim();
            model.ModuleTypeOrder = int.Parse(((TextBox)ModuleTypeList.Rows[e.RowIndex].FindControl("txt_order")).Text);

            if (!bll.UpdateModuleType(model))
            {
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('更新操作失败！')", true);
            }
            //返回浏览狀態
            ModuleTypeList.EditIndex = -1;
            BindOrder();
        }

        /// <summary>
        /// 数据绑定到表格
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ModuleTypeList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)//判定当前的行是否属于datarow类型的行
            {
                //当鼠标放上去的时候 先保存当前行的背景颜色 并给附一颜色
                e.Row.Attributes.Add("onmouseover", "currentcolor=this.style.backgroundColor;this.style.backgroundColor='#ffffcd',this.style.fontWeight='';");
                //当鼠标离开的时候 将背景颜色还原的以前的颜色
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor,this.style.fontWeight='';");

                LinkButton btnDel = ((LinkButton)e.Row.FindControl("btn_del"));

                btnDel.Attributes.Add("onclick", "return confirm('您确认要删除该记录吗?')");
            }
        }

        /// <summary>
        /// 添加数据
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btn_add_Click(object sender, EventArgs e)
        {
            if (txt_Name.Text.Trim() != "" || txt_order.Text.Trim() != "" || Lib.TypeParse.IsUnsign(txt_order.Text.Trim()))
            {
                RedGlovePermission.Model.RGP_ModuleType model = new RedGlovePermission.Model.RGP_ModuleType();

                model.ModuleTypeName = txt_Name.Text.Trim();
                model.ModuleTypeDescription = txt_Description.Text.Trim();
                model.ModuleTypeOrder = int.Parse(txt_order.Text.Trim());

                if (!bll.Exists(txt_Name.Text.Trim()))
                {
                    if (bll.CreateModuleType(model))
                    {
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('添加成功！')", true);
                    }
                    else
                    {
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('添加操作失败！')", true);
                    }
                    txt_Name.Text = "";
                    txt_Description.Text = "";
                    txt_order.Text = "";
                    BindOrder();
                }
                else
                {
                    ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('分类已经存在，请更换后重试！')", true);
                }
            }
        }
    }
}
