﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ModulesPage.aspx.cs" Inherits="RedGlovePermission.Web.Admin.Modubles.SysConfig.ModulesPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>模块管理</title>
    <link href="../../../Inc/Style/default/css/indexControl.css" rel="stylesheet" type="text/css" />
    <link href="../../../Inc/Style/default/css/GridView.css" rel="stylesheet" type="text/css" />

    <script src="../../../Inc/Script/pub.js" type="text/javascript"></script>

    <script type="text/javascript">

        //新增数据合法性检测
        function CheckAdd() {
            var ret = true;

            if ($id("txt_name").value == "") {
                alert('请输入名称!');
                ret = false;
            }
            else if ($id("txt_Tag").value == "") {
                alert('请输入标识!');
                ret = false;
            }
            else if ($id("txt_order").value == "") {
                alert('请输入排序编号!');
                ret = false;
            }
            else if (!IsPlusInt($id("txt_order").value)) {
                alert('排序编号必须为正整数!');
                ret = false;
            }
            return ret;
        }
        
    </script>

</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <div id="divToolBar" class="topBar">
        <div class="toolBar">
        </div>
        <div class="moduleName">
            模块管理</div>
    </div>
    <asp:UpdatePanel ID="CustomPanel1" runat="server">
        <ContentTemplate>
            <div id="title" class="childtoolbar">
                <div class="rowdiv" style="margin-left: 3px;">
                    选择分类:</div>
                <div class="rowdiv">
                    <asp:DropDownList ID="ModuleType" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ModuleType_SelectedIndexChanged">
                    </asp:DropDownList>
                </div>
                <div class="rowdiv" style="margin-left: 3px;">
                    <asp:Button ID="btn_add" class="button" runat="server" Text=" 新 增 " OnClick="btn_add_Click" /></div>
            </div>
            <div id="Glist" runat="server" style="margin: 10px; width: 460px; float: left; border: 0px solid #a9bfd3;">
                <asp:GridView ID="ModuleList" Width="460px" runat="server" DataKeyNames="ModuleID"
                    CssClass="Grid" AllowSorting="True" OnRowCommand="ModuleList_RowCommand" OnRowDataBound="ModuleList_RowDataBound"
                    AllowPaging="True" PageSize="15" AutoGenerateColumns="False">
                    <FooterStyle CssClass="GridFooter" />
                    <RowStyle CssClass="Row" />
                    <Columns>
                        <asp:BoundField DataField="ModuleID" HeaderText="编号" Visible="false">
                            <ItemStyle HorizontalAlign="Center" Wrap="false" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="名称">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbtn_name" CommandArgument='<%# Eval("ModuleID")%>' CommandName="EditView"
                                    runat="server" Text='<%# Eval("ModuleName") %>' ToolTip='<%# Eval("ModuleDescription") %>'></asp:LinkButton>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Left" Width="350px" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="状态">
                            <ItemTemplate>
                                <asp:Label ID="Lab_state" runat="server" Text='<%# (Convert.ToBoolean(Eval("ModuleDisabled"))==false)?"关闭":"启用" %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Wrap="False"/>
                            <ItemStyle HorizontalAlign="Center" Wrap="False" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="显示到菜单">
                            <ItemTemplate>
                                <asp:Label ID="Lab_menu" runat="server" Text='<%# (Convert.ToBoolean(Eval("IsMenu"))==false)?"不显示":"显示" %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Wrap="False"/>
                            <ItemStyle HorizontalAlign="Center" Wrap="False" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="排序">
                            <ItemTemplate>
                                <asp:Label ID="lab_order" runat="server" Text='<%# Eval("ModuleOrder") %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Wrap="False"/>
                            <ItemStyle HorizontalAlign="Center" Wrap="False" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="删除" ShowHeader="False">
                            <ItemTemplate>
                                <asp:LinkButton ID="btn_del" runat="server" CausesValidation="False" CommandName="Del"
                                    Text="删除" CommandArgument='<%# Eval("ModuleID")%>'></asp:LinkButton>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Wrap="False"/>
                            <ItemStyle HorizontalAlign="Center" Wrap="False" />
                        </asp:TemplateField>
                    </Columns>
                    <HeaderStyle CssClass="HeadingCell" />
                    <AlternatingRowStyle BorderStyle="None" CssClass="AlternatingRow" />
                </asp:GridView>
                <div id="GridViewMsg" style="padding: 5px;" runat="server">
                </div>
            </div>
            <asp:Panel ID="AddPanel" runat="server" Visible="false" Style="margin: 10px; float: left;
                border: 1px solid #d0d0d0; padding: 10px;">
                <table width="230" border="0" cellpadding="0" cellspacing="2">
                    <tr>
                        <td width="40">
                            名称：
                        </td>
                        <td width="190">
                            <asp:TextBox ID="txt_Name" Width="180" MaxLength="30" CssClass="inputbox" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            标识：
                        </td>
                        <td>
                            <asp:TextBox ID="txt_tag" Width="180" MaxLength="30" CssClass="inputbox" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            地址：
                        </td>
                        <td>
                            <asp:TextBox ID="txt_url" Width="180" CssClass="inputbox" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            状态：
                        </td>
                        <td>
                            <asp:RadioButtonList ID="txt_state" runat="server" RepeatDirection="Horizontal">
                                <asp:ListItem Selected="True" Value="1">启用</asp:ListItem>
                                <asp:ListItem Value="0">关闭</asp:ListItem>
                            </asp:RadioButtonList>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            排序：
                        </td>
                        <td>
                            <asp:TextBox ID="txt_order" Width="180" MaxLength="6" CssClass="inputbox" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            说明：
                        </td>
                        <td>
                            <asp:TextBox ID="txt_Description" Width="180px" MaxLength="120" CssClass="inputbox"
                                runat="server" Height="60px" TextMode="MultiLine"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2"><div class="rowdiv" style="line-height:28px;">显示到菜单：</div>
                        <div class="rowdiv">
                        <asp:RadioButtonList ID="IsMenu" runat="server" RepeatDirection="Horizontal">
                                <asp:ListItem Selected="True" Value="1">显示</asp:ListItem>
                                <asp:ListItem Value="0">不显示</asp:ListItem>
                            </asp:RadioButtonList></div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            权限：
                        </td>
                        <td>
                            <asp:Label ID="AuthorityNum" runat="server" Text="0" Style="display: none"></asp:Label>
                            <asp:Label ID="M_ID" runat="server" Text="" Style="display: none"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <div style="background-color: #fff; margin-top: 10px; margin-bottom: 10px; border: 1px solid #ccc;">
                                <div style="border-top: 1px solid #666; border-left: 1px solid #666; border-right: 1px solid #fff;
                                    border-bottom: 1px solid #fff;">
                                    <div style="border-top: 1px solid #666; border-left: 1px solid #666; border-right: 1px solid #c1c1c1;
                                        border-bottom: 1px solid #c1c1c1;">
                                        <table border="0" cellpadding="0" cellspacing="2">
                                            <tr>
                                                <td>
                                                    &nbsp;
                                                </td>
                                                <td width="100">
                                                    <div id="divstate" runat="server">
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="center">
                            <asp:Button ID="btn_save" class="button" runat="server" Text=" 保 存 " OnClick="btn_save_Click" />
                            <asp:Button ID="btn_update" class="button" runat="server" Text=" 更 新 " OnClick="btn_update_Click" />
                            &nbsp;&nbsp;
                            <asp:Button ID="btn_cancel" class="button" runat="server" Text=" 取 消 " OnClick="btn_cancel_Click" />
                        </td>
                    </tr>
                </table>
            </asp:Panel>
        </ContentTemplate>
    </asp:UpdatePanel>
    </form>
</body>
</html>
