﻿using System;
using System.Collections;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace RedGlovePermission.Web.Admin.Modubles.SysConfig
{
    public partial class RoleAuthorizedPage : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!SessionBox.CheckUserSession())
            {
                Response.Redirect("~/Admin/Login.aspx");
            }
            else
            {
                //初始化模块权限
                UserHandle.InitModule("Mod_RoleAuthority");

                if (!IsPostBack)
                {
                    BindGroups();
                    BindModuleType();
                    BindRoles();
                }
            }
        }

        //获取角色列表
        protected void BindRoles()
        {
            RedGlovePermission.BLL.RGP_Roles Rolsebll = new RedGlovePermission.BLL.RGP_Roles();
            DataSet ds = Rolsebll.GetRoleList("RoleGroupID=" + GroupList.SelectedValue, "");
            RoleView.DataSource = ds;
            RoleView.DataBind();
        }

        //获取模块权限列表
        protected void BindModules()
        {
            if (Rid.Text != "")
            {
                RedGlovePermission.BLL.RGP_Modules Mbll = new RedGlovePermission.BLL.RGP_Modules();
                DataSet ds = Mbll.GetModuleList("ModuleDisabled=1 and ModuleTypeID=" + ModuleTypeList.SelectedValue);
                ModuleView.DataSource = ds;
                ModuleView.DataBind();
            }
            else
            {
                ModuleView.DataSource = null;
                ModuleView.DataBind();
            }
        }

        //绑定分组数据
        protected void BindGroups()
        {
            RedGlovePermission.BLL.RGP_Groups Groupbll = new RedGlovePermission.BLL.RGP_Groups();
            DataSet ds = Groupbll.GetGroupList("", "order by GroupOrder asc");

            GroupList.DataSource = ds;
            GroupList.DataTextField = "GroupName";
            GroupList.DataValueField = "GroupID";
            GroupList.DataBind();
        }

        //绑定分组数据
        protected void BindModuleType()
        {
            RedGlovePermission.BLL.RGP_ModuleType MTbll = new RedGlovePermission.BLL.RGP_ModuleType();
            DataSet ds = MTbll.GetModuleTypeList("");

            ModuleTypeList.DataSource = ds;
            ModuleTypeList.DataTextField = "ModuleTypeName";
            ModuleTypeList.DataValueField = "ModuleTypeID";
            ModuleTypeList.DataBind();
        }

        //查看角权限
        protected void RoleView_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName.ToString() == "EditView")
            {
                Rid.Text = e.CommandArgument.ToString();
                if (!ModuleTypeList.Enabled)
                    ModuleTypeList.Enabled = true;
                //int.Parse(e.CommandArgument.ToString());

                BindModules();
            }
        }

        protected void GroupList_SelectedIndexChanged(object sender, EventArgs e)
        {
            Rid.Text = "";
            ModuleTypeList.Enabled = false;
            BindRoles();
            BindModules();
        }

        protected void ModuleTypeList_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindModules();
        }

        protected void ModuleView_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                RedGlovePermission.BLL.RGP_AuthorityDir AD = new RedGlovePermission.BLL.RGP_AuthorityDir();
                RedGlovePermission.BLL.RGP_ModuleAuthorityList MAL = new RedGlovePermission.BLL.RGP_ModuleAuthorityList();
                RedGlovePermission.BLL.RGP_RoleAuthorityList RAL = new RedGlovePermission.BLL.RGP_RoleAuthorityList();

                CheckBoxList AuthorityList = (CheckBoxList)e.Row.FindControl("AuthorityList");
                Label lab_ID = (Label)e.Row.FindControl("lab_ID");
                Label lab_Verify = (Label)e.Row.FindControl("lab_Verify");

                DataSet ds = AD.GetAuthorityList("", "order by AuthorityOrder asc");
                DataSet MALDS = MAL.GetAuthorityList(int.Parse(lab_ID.Text));
                DataSet RALDS= RAL.GetRoleAuthorityList(int.Parse(Rid.Text),int.Parse(lab_ID.Text));

                int n = ds.Tables[0].Rows.Count;//系统权限个数

                string[] vstate = new string[n];

                //获取系统配置的权限列表，如果模块没有该权限，则禁用该权限
                for (int i = 0; i < n; i++)
                {
                    AuthorityList.Items.Add(new ListItem(ds.Tables[0].Rows[i]["AuthorityName"].ToString(), ds.Tables[0].Rows[i]["AuthorityTag"].ToString()));
                    AuthorityList.Items[i].Enabled = false;
                    for (int k = 0; k < MALDS.Tables[0].Rows.Count; k++)
                    {
                        if (ds.Tables[0].Rows[i]["AuthorityTag"].ToString() == MALDS.Tables[0].Rows[k]["AuthorityTag"].ToString())
                        {
                            AuthorityList.Items[i].Enabled = true;
                            break;
                        }
                    }
                    vstate[i] = "0";//初始状态数组;
                }
                AuthorityList.DataBind();

                //将模块权限付值
                for (int j = 0; j < RALDS.Tables[0].Rows.Count; j++)
                {
                    for (int l = 0; l < AuthorityList.Items.Count; l++)
                    {
                        if (RALDS.Tables[0].Rows[j]["AuthorityTag"].ToString() == AuthorityList.Items[l].Value)
                        {
                            if (AuthorityList.Items[l].Enabled)
                                vstate[l] = "1";//权限存在
                                AuthorityList.Items[l].Selected = true;
                            break;
                        }
                    }
                }

                lab_Verify.Text = RedGlovePermission.Lib.TypeParse.StringArrayToString(vstate, ',');
            }
        }

        //保存所有修改的权限
        protected void btn_AllSave_Click(object sender, EventArgs e)
        {
            RedGlovePermission.BLL.RGP_RoleAuthorityList RAL = new RedGlovePermission.BLL.RGP_RoleAuthorityList();

            ArrayList list = new ArrayList();//建立事务列表
            for (int i = 0; i <= ModuleView.Rows.Count - 1; i++)
            {
                CheckBoxList cal = (CheckBoxList)this.ModuleView.Rows[i].Cells[1].FindControl("AuthorityList");
                Label lab_Verify = (Label)this.ModuleView.Rows[i].Cells[0].FindControl("lab_Verify");
                string[] vstate = lab_Verify.Text.Split(',');//获取原始状态

                for (int j = 0; j < cal.Items.Count; j++)
                {
                    if (cal.Items[j].Enabled)
                    {
                        if (cal.Items[j].Selected)
                        {
                            if (vstate[j] != "1")//检查数据有没有变化
                            {
                                string item = string.Empty;
                                item = item + Rid.Text + "|"
                                    + this.ModuleView.DataKeys[i].Values[0].ToString() + "|"
                                    + cal.Items[j].Value + "|1";//设置为1，加入权限
                                list.Add(item);
                            }
                        }
                        else
                        {
                            if (vstate[j] != "0")//检查数据有没有变化
                            {
                                string item = string.Empty;
                                item = item + Rid.Text + "|"
                                    + this.ModuleView.DataKeys[i].Values[0].ToString() + "|"
                                    + cal.Items[j].Value + "|0";//设置为0，删除删除
                                list.Add(item);
                            }
                        }
                    }
                }
            }

            if (RAL.UpdateRoleAuthority(list))
            {
                BindModules();
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('设置成功！')", true);
            }
            else
            {
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('设置操作失败！')", true);
            }
        }

        protected void ModuleView_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            ArrayList list = new ArrayList();//建立事务列表
            RedGlovePermission.BLL.RGP_RoleAuthorityList RAL = new RedGlovePermission.BLL.RGP_RoleAuthorityList();
            CheckBoxList cal = (CheckBoxList)this.ModuleView.Rows[e.NewSelectedIndex].Cells[1].FindControl("AuthorityList");
            Label lab_Verify = (Label)this.ModuleView.Rows[e.NewSelectedIndex].Cells[0].FindControl("lab_Verify");
            string[] vstate = lab_Verify.Text.Split(',');//获取原始状态

            for (int i = 0; i < cal.Items.Count; i++)
            {
                if (cal.Items[i].Enabled)
                {
                    if (cal.Items[i].Selected)
                    {
                        if (vstate[i] != "1")//检查数据有没有变化
                        {
                            string item = string.Empty;
                            item = item + Rid.Text + "|"
                                + this.ModuleView.DataKeys[e.NewSelectedIndex].Values[0].ToString() + "|"
                                + cal.Items[i].Value + "|1";//设置为1，加入权限
                            list.Add(item);
                        }
                    }
                    else
                    {
                        if (vstate[i] != "0")//检查数据有没有变化
                        {
                            string item = string.Empty;
                            item = item + Rid.Text + "|"
                                + this.ModuleView.DataKeys[e.NewSelectedIndex].Values[0].ToString() + "|"
                                + cal.Items[i].Value + "|0";//设置为0，删除删除
                            list.Add(item);
                        }
                    }
                }
            }

            if (RAL.UpdateRoleAuthority(list))
            {
                BindModules();
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('设置成功！')", true);
            }
            else
            {
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('设置操作失败！')", true);
            }

        }
    }
}
