﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

/**************************************
 * 模块：角色数据管理
 * 作者：Nick.Yan
 * 日期:2008-11-13
 * 网址：www.redglove.com.cn
 * ***********************************/

namespace RedGlovePermission.Web.Admin.Modubles.SysConfig
{
    public partial class RolesPage : System.Web.UI.Page
    {
        RedGlovePermission.BLL.RGP_Roles bll = new RedGlovePermission.BLL.RGP_Roles();

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!SessionBox.CheckUserSession())
            {
                Response.Redirect("~/Admin/Login.aspx");
            }
            else
            {
                //初始化模块权限
                UserHandle.InitModule("Mod_Roles");

                if (!IsPostBack)
                {
                    btn_add.Attributes.Add("onclick", "return CheckAdd()");//加入验证

                    //绑定组信息
                    RedGlovePermission.BLL.RGP_Groups Groupbll = new RedGlovePermission.BLL.RGP_Groups();
                    GroupList.DataSource = Groupbll.GetGroupList("", "order by GroupOrder asc");
                    GroupList.DataTextField = "GroupName";
                    GroupList.DataValueField = "GroupID";
                    GroupList.DataBind();

                    BindOrder();
                }
            }
        }

        /// <summary>
        /// 将数据绑定到DataSet
        /// </summary>
        public void BindOrder()
        {
            DataSet ds = bll.GetRoleList("RoleGroupID=" + GroupList.SelectedValue, "");

            if (ds.Tables[0].Rows.Count == 0)
                GridViewMsg.InnerText = "无相关记录";
            else
                GridViewMsg.InnerText = "共有" + ds.Tables[0].Rows.Count + "条记录";

            RolesLists.DataSource = ds;
            RolesLists.DataBind();
        }

        /// <summary>
        /// 分页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void RolesLists_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            RolesLists.PageIndex = e.NewPageIndex;
            BindOrder(); //重新绑定GridView数据的函数 
        }

        /// <summary>
        /// 退出编辑状态
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void RolesLists_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            RolesLists.EditIndex = -1;
            BindOrder();
        }

        /// <summary>
        /// 执行事件（删除操作）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void RolesLists_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName.ToString() == "Del")
            {
                int ret = bll.DeleteRole(int.Parse(e.CommandArgument.ToString()));
                switch (ret)
                {
                    case 1:
                        BindOrder();
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('删除成功');", true);
                        break;
                    case 2:
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('角色中还有用户存在，不能进行删除操作!');", true);
                        break;
                    default:
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('删除失败!');", true);
                        break;
                }

            }
        }

        /// <summary>
        /// 变更到编辑状态
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void RolesLists_RowEditing(object sender, GridViewEditEventArgs e)
        {
            RolesLists.EditIndex = e.NewEditIndex;
            BindOrder();
        }

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void RolesLists_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            RedGlovePermission.Model.RGP_Roles model = new RedGlovePermission.Model.RGP_Roles();
            model.RoleID = int.Parse(RolesLists.DataKeys[e.RowIndex].Values[0].ToString());
            model.RoleName = ((TextBox)RolesLists.Rows[e.RowIndex].FindControl("txt_name")).Text.Trim();
            model.RoleDescription = ((TextBox)RolesLists.Rows[e.RowIndex].FindControl("txt_Description")).Text.Trim();
            model.RoleGroupID = int.Parse(((DropDownList)RolesLists.Rows[e.RowIndex].FindControl("GroupID")).SelectedValue);
            if (!bll.UpdateRole(model))
            {
                ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('更新操作失败！')", true);
            }
            //返回浏览狀態
            RolesLists.EditIndex = -1;
            BindOrder();
        }

        /// <summary>
        /// 数据绑定到表格
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void RolesLists_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)//判定当前的行是否属于datarow类型的行
            {
                RedGlovePermission.BLL.RGP_Groups Groupbll = new RedGlovePermission.BLL.RGP_Groups();
                DataSet Groups1 = Groupbll.GetGroupList("", "order by GroupOrder asc");
                //当鼠标放上去的时候 先保存当前行的背景颜色 并给附一颜色
                e.Row.Attributes.Add("onmouseover", "currentcolor=this.style.backgroundColor;this.style.backgroundColor='#ffffcd',this.style.fontWeight='';");
                //当鼠标离开的时候 将背景颜色还原的以前的颜色
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor,this.style.fontWeight='';");

                LinkButton btnDel = ((LinkButton)e.Row.FindControl("btn_del"));
                Label Lab_GroupID = ((Label)e.Row.FindControl("Lab_GroupID"));
                Label hid_GroupID = ((Label)e.Row.FindControl("hid_GroupID"));
                for (int i = 0; i < Groups1.Tables[0].Rows.Count; i++)
                {
                    if (Groups1.Tables[0].Rows[i]["GroupID"].ToString() == hid_GroupID.Text)
                    {
                        Lab_GroupID.Text = Groups1.Tables[0].Rows[i]["GroupName"].ToString();
                    }
                }

                btnDel.Attributes.Add("onclick", "return confirm('您确认要删除该记录吗?')");
            }

            if ((e.Row.RowState & DataControlRowState.Edit) != 0)
            {
                RedGlovePermission.BLL.RGP_Groups Groupbll = new RedGlovePermission.BLL.RGP_Groups();
                DataSet Groups2 = Groupbll.GetGroupList("", "order by GroupOrder asc");

                Label hid_GroupID = ((Label)e.Row.FindControl("hid_GroupID"));
                DropDownList GroupID = ((DropDownList)e.Row.FindControl("GroupID"));

                GroupID.DataSource = Groups2;
                GroupID.DataTextField = "GroupName";
                GroupID.DataValueField = "GroupID";
                GroupID.DataBind();

                GroupID.SelectedValue = hid_GroupID.Text;
            }
        }

        /// <summary>
        /// 添加数据
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btn_add_Click(object sender, EventArgs e)
        {
            if (txt_Name.Text.Trim() != "")
            {
                RedGlovePermission.Model.RGP_Roles model = new RedGlovePermission.Model.RGP_Roles();

                model.RoleName = txt_Name.Text.Trim();
                model.RoleDescription = txt_Description.Text.Trim();
                model.RoleGroupID = int.Parse(GroupList.SelectedValue);

                if (!bll.Exists(txt_Name.Text.Trim(), int.Parse(GroupList.SelectedValue)))
                {
                    if (bll.CreateRole(model))
                    {
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('添加成功！')", true);
                    }
                    else
                    {
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('添加操作失败！')", true);
                    }
                    txt_Name.Text = "";
                    txt_Description.Text = "";
                    BindOrder();
                }
                else
                {
                    ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('分组已经存在，请更换后重试！')", true);
                }
            }
        }

        /// <summary>
        /// 选择分类
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void GroupList_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindOrder();
        }
    }
}
