﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace RedGlovePermission.Web.Admin.Modubles.Users
{
    public partial class ListUsers : System.Web.UI.Page
    {
        RedGlovePermission.BLL.Users bll = new RedGlovePermission.BLL.Users();

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGroup();
                BindOrder();
            }
        }

        /// <summary>
        /// 绑定用户组数据
        /// </summary>
        protected void BindGroup()
        {
            RedGlovePermission.BLL.RGP_Groups GroupBll = new RedGlovePermission.BLL.RGP_Groups();

            DataSet ds = GroupBll.GetGroupList("", "order by GroupOrder asc");          
            GroupList.DataSource = ds;
            GroupList.DataTextField = "GroupName";
            GroupList.DataValueField = "GroupID";
            GroupList.DataBind();

            GroupList.Items.Insert(0, new ListItem("-显示全部-", "all"));
        }

        /// <summary>
        /// 绑定用户数据
        /// </summary>
        protected void BindOrder()
        {
            string strWhere = "(dbo.Users.RoleID <> 0)";
            if (GroupList.SelectedValue != "all")
            {
                strWhere = strWhere + " and dbo.Users.UserGroup=" + GroupList.SelectedValue;
            }
            DataSet ds = bll.GetUserList(strWhere, "ORDER BY dbo.Users.CreateTime DESC");

            if (ds.Tables[0].Rows.Count == 0)
                GridViewMsg.InnerText = "无相关记录";
            else
                GridViewMsg.InnerText = "共有" + ds.Tables[0].Rows.Count + "条记录";

            UserList.DataSource = ds;
            UserList.DataBind();
        }

        protected void UserList_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            switch (e.CommandName.ToString())
            {
                case "Del":
                    if (bll.DeleteUser(int.Parse(e.CommandArgument.ToString())))
                    {
                        BindOrder();
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('删除成功');", true);
                    }
                    else
                    {
                        ScriptManager.RegisterClientScriptBlock(CustomPanel1, this.GetType(), "MsgBox", "alert('删除失败!');", true);
                    }
                    break;
            }
        }

        protected void UserList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)//判定当前的行是否属于datarow类型的行
            {
                //当鼠标放上去的时候 先保存当前行的背景颜色 并给附一颜色
                e.Row.Attributes.Add("onmouseover", "currentcolor=this.style.backgroundColor;this.style.backgroundColor='#ffffcd',this.style.fontWeight='';");
                //当鼠标离开的时候 将背景颜色还原的以前的颜色
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=currentcolor,this.style.fontWeight='';");

                LinkButton btnDel = ((LinkButton)e.Row.FindControl("btn_del"));

                btnDel.Attributes.Add("onclick", "return confirm('您确认要删除该记录吗?')");
            }
        }

        protected void GroupList_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindOrder();
        }
    }
}
