CREATE TABLE Users (
    ID             INTEGER       NOT NULL,
    UserName       NVARCHAR2 (16) NOT NULL,
    Password       NVARCHAR2 (50)  NOT NULL,
    PassSalt       NVARCHAR2 (50)  NOT NULL,
    DisplayName    NVARCHAR2 (50)  NOT NULL,
    RegisterTime   DATE      NOT NULL,
    ApprovedTime   DATE,
    ApprovedBy     NVARCHAR2 (50),
    Description    NVARCHAR2 (500) NOT NULL,
    RejectedBy     NVARCHAR2 (50) ,
    RejectedTime   DATE,
    RejectedReason NVARCHAR2 (50),
    Icon           NVARCHAR2 (50),
    Css            NVARCHAR2 (50),
    App            NVARCHAR2 (50) 
);

CREATE TABLE UserRole (
	ID 		INTEGER NOT NULL,
	UserID 	INTEGER NOT NULL,
	RoleID 	INTEGER NOT NULL
);

CREATE TABLE UserGroup(
	ID 		INTEGER NOT NULL,
	UserID 	INTEGER NOT NULL,
	GroupID INTEGER NOT NULL
);

CREATE TABLE Roles(
	ID 			INTEGER NOT NULL,
	RoleName 	NVARCHAR2 (50) NOT NULL,
	Description NVARCHAR2 (500) NULL
);

CREATE TABLE RoleGroup(
	ID 		INTEGER NOT NULL,
	RoleID 	INTEGER NOT NULL,
	GroupID INTEGER NOT NULL
);

CREATE TABLE RoleApp(
	ID 		INTEGER NOT NULL,
	AppID 	NVARCHAR2 (50) NOT NULL,
	RoleID 	INTEGER NOT NULL
);

CREATE TABLE Notifications(
	ID 				INTEGER NOT NULL,
	Category 		NVARCHAR2 (50) NOT NULL,
	Title 			NVARCHAR2 (50) NOT NULL,
	Content 		NVARCHAR2 (50) NOT NULL,
	RegisterTime 	DATE NOT NULL,
	ProcessTime 	DATE NULL,
	ProcessBy 		NVARCHAR2 (50) NULL,
	ProcessResult 	NVARCHAR2 (50) NULL,
	Status 			NVARCHAR2 (50) DEFAULT 0
);

CREATE TABLE Navigations(
	ID 			INTEGER NOT NULL,
	ParentId 	INTEGER DEFAULT 0,
	Name 		NVARCHAR2 (50) NOT NULL,
	"ORDER" 	INTEGER DEFAULT 0 NOT NULL,
	Icon 		NVARCHAR2 (50) DEFAULT 'fa fa-fa',
	Url 		NVARCHAR2 (2000) NULL,
	Category 	NVARCHAR2 (50) DEFAULT 0,
	Target 		NVARCHAR2 (10) DEFAULT '_self',
	IsResource 	INTEGER DEFAULT 0,
	Application NVARCHAR2 (200) DEFAULT 'BA'
);

CREATE TABLE NavigationRole(
	ID INTEGER NOT NULL,
	NavigationID INTEGER NOT NULL,
	RoleID INTEGER NOT NULL
);

CREATE TABLE Logs(
	ID 			INTEGER NOT NULL,
	CRUD 		NVARCHAR2 (50) NOT NULL,
	UserName 	NVARCHAR2 (50) NOT NULL,
	LogTime 	DATE NOT NULL,
	Ip 			NVARCHAR2 (15) NOT NULL,
	Browser 	NVARCHAR2 (50) NULL,
	OS 			NVARCHAR2 (50) NULL,
	City 		NVARCHAR2 (50) NULL,
	RequestUrl 	NVARCHAR2 (500) NOT NULL,
	RequestData NVARCHAR2 (2000) NULL,
	UserAgent	NVARCHAR2 (2000) NULL,
    Referer     NVARCHAR2 (2000) NULL 
);

CREATE TABLE Groups(
	ID 			INTEGER NOT NULL,
	GroupCode 	NVARCHAR2 (50) NOT NULL,
	GroupName 	NVARCHAR2 (50) NOT NULL,
	Description NVARCHAR2 (500) NULL
);

CREATE TABLE Exceptions(
	ID 				INTEGER NOT NULL,
	AppDomainName 	NVARCHAR2 (50) NOT NULL,
	ErrorPage 		NVARCHAR2 (50) NOT NULL,
	UserID 			NVARCHAR2 (50) NULL,
	UserIp 			NVARCHAR2 (15) NULL,
	ExceptionType 	NVARCHAR2 (2000) NOT NULL,
	Message 		NVARCHAR2 (2000) NOT NULL,
	StackTrace 		NVARCHAR2 (2000) NULL,
	LogTime 		DATE NOT NULL,
	Category		NVARCHAR2 (50) NULL
);

CREATE TABLE Dicts(
	ID 			INTEGER NOT NULL,
	Category 	NVARCHAR2 (50) NOT NULL,
	Name 		NVARCHAR2 (50) NOT NULL,
	Code 		NVARCHAR2 (2000) NOT NULL,
	Define 		INTEGER DEFAULT 1 NOT NULL
);

CREATE TABLE Messages(
	ID 			INTEGER NOT NULL,
	Title 		NVARCHAR2 (50) NOT NULL,
	Content 	NVARCHAR2 (500) NOT NULL,
	"FROM" 		NVARCHAR2 (50) NOT NULL,
	"TO" 		NVARCHAR2 (50) NOT NULL,
	SendTime 	DATE NOT NULL,
	Status 		NVARCHAR2 (50) NOT NULL,
	Flag 		INTEGER DEFAULT 0,
	IsDelete 	INTEGER DEFAULT 0,
	Label 		NVARCHAR2 (50)
);

CREATE TABLE Tasks(
	ID 				INTEGER NOT NULL,
	TaskName 		NVARCHAR2 (500) NOT NULL,
	AssignName 		NVARCHAR2 (50) NOT NULL,
	UserName 		NVARCHAR2 (50) NOT NULL,
	TaskTime 		INTEGER NOT NULL,
	TaskProgress	INTEGER NOT NULL,
	AssignTime 		DATE NOT NULL
);

CREATE TABLE RejectUsers(
	ID 				INTEGER NOT NULL,
	UserName 		NVARCHAR2 (50) NOT NULL,
	DisplayName 	NVARCHAR2 (50) NOT NULL,
	RegisterTime 	DATE NOT NULL,
	RejectedBy 		NVARCHAR2 (50) NOT NULL,
	RejectedTime 	DATE NOT NULL,
	RejectedReason 	NVARCHAR2 (50) NULL
);

CREATE TABLE LoginLogs(
	ID 			INTEGER NOT NULL,
	UserName 	NVARCHAR2 (50) NOT NULL,
	LoginTime 	DATE NOT NULL,
	Ip 			NVARCHAR2 (15) NOT NULL,
	OS 			NVARCHAR2 (50) NULL,
	Browser 	NVARCHAR2 (50) NULL,
	City 		NVARCHAR2 (50) NULL,
	Result 		NVARCHAR2 (50) NOT NULL,
	UserAgent	NVARCHAR2 (2000) NULL
);

CREATE TABLE ResetUsers(
	ID 			INTEGER NOT NULL,
	UserName 	NVARCHAR2 (50) NOT NULL,
	DisplayName NVARCHAR2 (50) NOT NULL,
	Reason 		NVARCHAR2 (500) NOT NULL,
	ResetTime 	DATE NOT NULL
);

CREATE TABLE Traces(
    ID         INTEGER       NOT NULL,
    UserName   NVARCHAR2 (50)  NOT NULL,
    LogTime    DATE      NOT NULL,
    IP         NVARCHAR2 (15)  NOT NULL,
    Browser    NVARCHAR2 (50),
    OS         NVARCHAR2 (50),
    City       NVARCHAR2 (50),
    RequestUrl NVARCHAR2 (500) NOT NULL,
	UserAgent  NVARCHAR2 (2000),
    Referer    NVARCHAR2 (2000) 
);

CREATE TABLE DBLogs (
    ID       INTEGER            NOT NULL,
    UserName NVARCHAR2 (50),
    SQL      NVARCHAR2 (2000)   NOT NULL,
    LogTime  DATE               NOT NULL
);

CREATE SEQUENCE SEQ_USERS_ID;
CREATE SEQUENCE SEQ_USERROLE_ID;
CREATE SEQUENCE SEQ_USERGROUP_ID;
CREATE SEQUENCE SEQ_ROLES_ID;
CREATE SEQUENCE SEQ_ROLEGROUP_ID;
CREATE SEQUENCE SEQ_ROLEAPP_ID;
CREATE SEQUENCE SEQ_NOTIFICATIONS_ID;
CREATE SEQUENCE SEQ_NAVIGATIONS_ID;
CREATE SEQUENCE SEQ_NAVIGATIONROLE_ID;
CREATE SEQUENCE SEQ_LOGS_ID;
CREATE SEQUENCE SEQ_GROUPS_ID;
CREATE SEQUENCE SEQ_EXCEPTIONS_ID;
CREATE SEQUENCE SEQ_DICTS_ID;
CREATE SEQUENCE SEQ_MESSAGES_ID;
CREATE SEQUENCE SEQ_TASKS_ID;
CREATE SEQUENCE SEQ_REJECTUSERS_ID;
CREATE SEQUENCE SEQ_LOGINLOGS_ID;
CREATE SEQUENCE SEQ_RESETUSERS_ID;
CREATE SEQUENCE SEQ_TRACES_ID;
CREATE SEQUENCE SEQ_DBLOGS_ID;
