﻿CREATE TABLE Users (
    ID             INTEGER       PRIMARY KEY,
    UserName       NVARCHAR (16) NOT NULL COLLATE NOCASE,
    Password       VARCHAR (50)  NOT NULL,
    PassSalt       VARCHAR (50)  NOT NULL,
    DisplayName    VARCHAR (50)  NOT NULL,
    RegisterTime   DATETIME      NOT NULL,
    ApprovedTime   DATETIME,
    ApprovedBy     VARCHAR (50),
    Description    VARCHAR (500) NOT NULL,
    RejectedBy     VARCHAR (50)  COLLATE NOCASE,
    RejectedTime   DATETIME,
    RejectedReason VARCHAR (50),
    Icon           VARCHAR (50),
    Css            VARCHAR (50),
    App            VARCHAR (50) 
);

CREATE TABLE UserRole (
	ID 		INTEGER PRIMARY KEY,
	UserID 	INT NOT NULL,
	RoleID 	INT NOT NULL
);

CREATE TABLE UserGroup(
	ID 		INTEGER PRIMARY KEY,
	UserID 	INT NOT NULL,
	GroupID INT NOT NULL
);

CREATE TABLE Roles(
	ID 			INTEGER PRIMARY KEY,
	RoleName 	VARCHAR (50) NOT NULL COLLATE NOCASE,
	Description VARCHAR (500) NULL
);

CREATE TABLE RoleGroup(
	ID 		INTEGER PRIMARY KEY,
	RoleID 	INT NOT NULL,
	GroupID INT NOT NULL
);

CREATE TABLE RoleApp(
	ID 		INTEGER PRIMARY KEY,
	AppID 	VARCHAR (50) NOT NULL COLLATE NOCASE,
	RoleID 	INT NOT NULL
);

CREATE TABLE Notifications(
	ID 				INTEGER PRIMARY KEY,
	Category 		VARCHAR (50) NOT NULL,
	Title 			VARCHAR (50) NOT NULL,
	Content 		VARCHAR (50) NOT NULL,
	RegisterTime 	DATETIME NOT NULL,
	ProcessTime 	DATETIME NULL,
	ProcessBy 		VARCHAR (50) NULL,
	ProcessResult 	VARCHAR (50) NULL,
	Status 			VARCHAR (50) DEFAULT (0)
);

CREATE TABLE Navigations(
	ID 			INTEGER PRIMARY KEY,
	ParentId 	INT DEFAULT (0),
	Name 		VARCHAR (50) NOT NULL,
	[Order] 	INT NOT NULL DEFAULT (0),
	Icon 		VARCHAR (50) DEFAULT [fa fa-fa],
	Url 		VARCHAR (4000) NULL,
	Category 	VARCHAR (50) DEFAULT 0,
	Target 		VARCHAR (10) DEFAULT [_self],
	IsResource 	INT DEFAULT (0),
	Application VARCHAR (200) DEFAULT [BA] COLLATE NOCASE
);

CREATE TABLE NavigationRole(
	ID INTEGER PRIMARY KEY,
	NavigationID INT NOT NULL,
	RoleID INT NOT NULL
);

CREATE TABLE Logs(
	ID 			INTEGER PRIMARY KEY,
	CRUD 		VARCHAR (50) NOT NULL,
	UserName 	VARCHAR (50) NOT NULL COLLATE NOCASE,
	LogTime 	DATETIME NOT NULL,
	Ip 			VARCHAR (15) NOT NULL,
	Browser 	VARCHAR (50) NULL,
	OS 			VARCHAR (50) NULL,
	City 		VARCHAR (50) NULL,
	RequestUrl 	VARCHAR (500) NOT NULL,
	RequestData TEXT		 NULL,
	UserAgent	VARCHAR (2000) NULL,
    Referer     VARCHAR (2000) 
);

CREATE TABLE Groups(
	ID 			INTEGER PRIMARY KEY,
	GroupCode 	VARCHAR (50) NOT NULL,
	GroupName 	VARCHAR (50) NOT NULL COLLATE NOCASE,
	Description VARCHAR (500) NULL
);

CREATE TABLE Exceptions(
	ID 				INTEGER PRIMARY KEY,
	AppDomainName 	VARCHAR (50) NOT NULL,
	ErrorPage 		VARCHAR (50) NOT NULL,
	UserID 			VARCHAR (50) NULL,
	UserIp 			VARCHAR (15) NULL,
	ExceptionType 	TEXT NOT NULL,
	Message 		TEXT NOT NULL,
	StackTrace 		TEXT NULL,
	LogTime 		DATETIME NOT NULL,
	Category		VARCHAR (50) NULL
);

CREATE TABLE Dicts(
	ID 			INTEGER PRIMARY KEY,
	Category 	VARCHAR (50) NOT NULL,
	Name 		VARCHAR (50) NOT NULL,
	Code 		VARCHAR (2000) NOT NULL,
	Define 		INT NOT NULL DEFAULT (1)
);

CREATE TABLE Messages(
	ID 			INTEGER PRIMARY KEY,
	Title 		VARCHAR (50) NOT NULL,
	Content 	VARCHAR (500) NOT NULL,
	[From] 		VARCHAR (50) NOT NULL,
	[To] 		VARCHAR (50) NOT NULL,
	SendTime 	DATETIME NOT NULL,
	Status 		VARCHAR (50) NOT NULL,
	Flag 		INT DEFAULT (0),
	IsDelete 	INT DEFAULT (0),
	Label 		VARCHAR (50)
);

CREATE TABLE Tasks(
	ID 				INTEGER PRIMARY KEY,
	TaskName 		VARCHAR (500) NOT NULL COLLATE NOCASE,
	AssignName 		VARCHAR (50) NOT NULL COLLATE NOCASE,
	UserName 		VARCHAR (50) NOT NULL COLLATE NOCASE,
	TaskTime 		INT NOT NULL,
	TaskProgress	INT NOT NULL,
	AssignTime 		DATETIME NOT NULL
);

CREATE TABLE RejectUsers(
	ID 				INTEGER PRIMARY KEY,
	UserName 		VARCHAR (50) NOT NULL COLLATE NOCASE,
	DisplayName 	VARCHAR (50) NOT NULL,
	RegisterTime 	DATETIME NOT NULL,
	RejectedBy 		VARCHAR (50) NOT NULL COLLATE NOCASE,
	RejectedTime 	DATETIME NOT NULL,
	RejectedReason 	VARCHAR (50) NULL
);

CREATE TABLE LoginLogs(
	ID 			INTEGER PRIMARY KEY,
	UserName 	VARCHAR (50) NOT NULL COLLATE NOCASE,
	LoginTime 	DATETIME NOT NULL,
	Ip 			VARCHAR (15) NOT NULL,
	OS 			VARCHAR (50) NULL,
	Browser 	VARCHAR (50) NULL,
	City 		VARCHAR (50) NULL,
	Result 		VARCHAR (50) NOT NULL,
	UserAgent	VARCHAR (2000) NULL
);

CREATE TABLE ResetUsers(
	ID 			INTEGER PRIMARY KEY,
	UserName 	VARCHAR (50) NOT NULL COLLATE NOCASE,
	DisplayName VARCHAR (50) NOT NULL,
	Reason 		VARCHAR (500) NOT NULL,
	ResetTime 	DATETIME NOT NULL
);

CREATE TABLE Traces(
    ID         INTEGER       PRIMARY KEY,
    UserName   VARCHAR (50)  NOT NULL COLLATE NOCASE,
    LogTime    DATETIME      NOT NULL,
    IP         VARCHAR (15)  NOT NULL,
    Browser    VARCHAR (50),
    OS         VARCHAR (50),
    City       VARCHAR (50),
    RequestUrl VARCHAR (500) NOT NULL,
	UserAgent  VARCHAR (2000),
    Referer    VARCHAR (2000) 
);

CREATE TABLE DBLogs (
    ID       INTEGER      PRIMARY KEY,
    UserName VARCHAR (50) COLLATE NOCASE,
    SQL      VARCHAR      NOT NULL,
    LogTime  DATETIME     NOT NULL
);