﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using EKETEAM.Data;
using EKETEAM.FrameWork;

namespace eFrameWork.AppMobile
{
    public partial class Login : System.Web.UI.Page
    {

        private void setSession()
        {
            if (Session["LoginErrorCount"] == null)
            {
                Session["LoginErrorCount"] = 1;
            }
            else
            {
                Session["LoginErrorCount"] = Convert.ToInt32(Session["LoginErrorCount"]) + 1;
            }
        }
        private int getSession()
        {
            if (Session["LoginErrorCount"] == null) return 0;
            return Convert.ToInt32(Session["LoginErrorCount"]);
        }
        public bool isIphone()
        {
            if (Request.QueryString["app"] != null) return false;
            string userAgent = Request.ServerVariables["HTTP_USER_AGENT"].ToString().Replace(" ", "").ToLower();
            if (userAgent.IndexOf("iphone;") > -1) return true;
            return false;
        }
        public bool isIphoneSafari()
        {
            string userAgent = Request.ServerVariables["HTTP_USER_AGENT"].ToString().Replace(" ", "").ToLower();
            if (userAgent.IndexOf("iphone;") > -1 && userAgent.IndexOf("safari/") > -1) return true;
            return false;
        }
        public bool isAndroid()
        {
            if (Request.QueryString["app"] != null) return false;
            string userAgent = Request.ServerVariables["HTTP_USER_AGENT"].ToString().Replace(" ", "").ToLower();
            if (userAgent.IndexOf(";android") > -1) return true;
            return false;
        }

        public bool isAndroidBrowser()
        {

            string userAgent = Request.ServerVariables["HTTP_USER_AGENT"].ToString().Replace(" ", "").ToLower();
            if (userAgent.IndexOf("vivobrowser/") > -1) return true;
            if (userAgent.IndexOf("micromessenger/") > -1) return false;
            if (userAgent.IndexOf("alipayclient/") > -1) return false;
            if (userAgent.IndexOf("qqtheme/") > -1) return false;

            return true;
        }


        protected void Page_Load(object sender, EventArgs e)
        {
            string userAgent = Request.ServerVariables["HTTP_USER_AGENT"].ToString().Replace(" ", "").ToLower();
            //if (userAgent.IndexOf("wxwork/") > -1) Response.Redirect("qyLogin.aspx", true);


            if (getSession() > 2)
            {
                Response.Clear();
                Response.ContentType = "text/html; charset=utf-8";
                Response.Write("操作过于频繁,请稍后再试!");
                Response.End();
            }
            eUser user;
            string fromURL = eParameters.QueryString("fromURL");

            if (1 == 2 && Request.Url.Host.ToLower().IndexOf("192.168.") > -1)
            {
                user = new eUser("Application");
                user["id"] = "f14761ab-9504-4f71-b412-c45c2b4e5a1c";// "f9ca0e08-0ce6-433e-8c0a-b08b56c86e4b";
                user["nick"] = "admin";// "E客";
                user.Save();
                if (fromURL.Length > 0)
                {
                    Response.Redirect(HttpUtility.UrlDecode(fromURL), true);
                }
                else
                {
                    Response.Redirect("Default.aspx", true);
                }
            }
            if (Request.Url.Host.ToLower().IndexOf("application.eketeam.com") > -1 || Request.Url.Host.ToLower().IndexOf("192.168.") > -1 || Request.Url.Host.ToLower().IndexOf("127.0.") > -1 || Request.Url.Host.ToLower().IndexOf("localhost") > -1)
            {
                /*
                user = new eUser("Mobile");
                user["id"] = "f14761ab-9504-4f71-b412-c45c2b4e5a1c";// "f9ca0e08-0ce6-433e-8c0a-b08b56c86e4b";
                user["nick"] = "admin";// "E客";
                user.Save();
                if (fromURL.Length > 0)
                {
                    Response.Redirect(HttpUtility.UrlDecode(fromURL), true);
                }
                else
                {
                    Response.Redirect("Default.aspx", true);
                }
                */
            }


            string LoginFile = "Login.aspx";
            if (fromURL.Length > 0) LoginFile += "?fromURL=" + HttpUtility.UrlEncode(fromURL);
            if (Request.Form["yhm"] != null)
            {
                if (eConfig.openRndCode())
                {
                    if (Session["Plugins_RndCode"] == null)
                    {
                        setSession();
                        Response.Write("<script>alert('验证码超时！');document.location='" + fromURL + "';</script>");
                        Response.End();
                    }
                    if (Session["Plugins_RndCode"].ToString() != Request.Form["yzm"].ToString())
                    {
                        setSession();
                        Session.Remove("Plugins_RndCode");
                        Response.Write("<script>alert('验证码不正确！');document.location='" + fromURL + "';</script>");
                        Response.End();
                    }
                    Session.Remove("Plugins_RndCode");
                }
                string sql = "Select top 1 * From a_eke_sysUsers Where delTag=0 and Active=1 and YHM='" + Request.Form["yhm"].ToString() + "'";
                #region 绑定登录，防止DEMO用户密码被修改或禁用及删除
                if (Request.Url.Host.ToLower().IndexOf("demo.eketeam.com") > -1)
                {
                    sql = "Select top 1 UserID,YHM,MM,SiteID From a_eke_sysUsers Where YHM='" + Request.Form["yhm"].ToString() + "'";
                }
                #endregion
                DataTable tb = eBase.UserInfoDB.getDataTable(sql);
                if (tb.Rows.Count == 0)
                {
                    setSession();
                    Response.Write("<script>alert('登录信息不正确！');document.location='" + fromURL + "';</script>");
                    Response.End();
                }
                else
                {
                    string encpass = Request.Form["mm"].ToString();
                    string pass = eRSA.getPass(encpass);
                    if (eBase.getPassWord(pass) == tb.Rows[0]["mm"].ToString())
                    {
                        user = new eUser("Application");
                        user["id"] = tb.Rows[0]["UserID"].ToString();
                        user["name"] = tb.Rows[0]["YHM"].ToString();
                        user["siteid"] = tb.Rows[0]["siteid"].ToString() == "0" ? "1" : tb.Rows[0]["siteid"].ToString() ;
                        if (tb.Columns.Contains("code")) user["code"] = tb.Rows[0]["code"].ToString();
                        if (tb.Columns.Contains("datacode")) user["datacode"] = tb.Rows[0]["datacode"].ToString();
                        user["app"] = eParameters.Form("app");
                        user["iphoneapp"] = eParameters.Form("iphoneapp");
                        user.Save();
                        eBase.UserInfoDB.Execute("update a_eke_sysUsers set LastLoginTime=isnull(LoginTime,getdate()) where UserID='" + tb.Rows[0]["UserID"].ToString() + "'");
                        eBase.UserInfoDB.Execute("update a_eke_sysUsers set LoginCount=LoginCount+1,LoginTime=getdate() where UserID='" + tb.Rows[0]["UserID"].ToString() + "'");
                        //用户登录日志
                        eTable etb = new eTable("a_eke_sysUserLog");
                        etb.DataBase = eBase.UserInfoDB;
                        etb.Fields.Add("UserID", tb.Rows[0]["UserID"]);
                        etb.Fields.Add("Type", 1);
                        etb.Fields.Add("IP", eBase.getIP());
                        etb.Fields.Add("Area", "AppMobile");
                        etb.Add();
                        if (eParameters.Form("iphoneapp") == "1" || eParameters.Form("app")=="true")
                        {
                            Response.Write("<script>localStorage.cookie=document.cookie;document.location='Default.aspx';</script>");
                            Response.End();
                        }
                        if (eParameters.QueryString("fromURL").Length > 0)
                        {
                            Response.Redirect(HttpUtility.UrlDecode(eParameters.QueryString("fromURL")), true);
                        }
                        else
                        {
                            Response.Redirect("Default.aspx", true);
                        }
                    }
                    else
                    {
                        setSession();
                        Response.Write("<script>alert('登录信息不正确！');document.location='" + fromURL + "';</script>");
                        Response.End();
                    }
                }
            }
        }
    }
}