﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using EKETEAM.FrameWork;
using EKETEAM.Data;


/// <summary>
/// Apply 的摘要说明
/// </summary>
public class ApplicationMenu
{
    private eUser user;
    private string modelid = "";
    public string ModelID
    {
        get
        {
            return modelid;
        }
        set
        {
            modelid = value;
        }
    }
    private string applicationid="";
    public string ApplicationID
    {
        get 
        {
            return applicationid;
        }
        set
        {
            applicationid = value;
        }
    }
    private string applicationitemid = "";
    public string ApplicationItemID
    {
        get
        {
            return applicationitemid;
        }
        set
        {
            applicationitemid = value;
        }
    }
    //当前用户有权限的模块
    private DataTable _usermodels;
    public DataTable UserModels
    {
        get
        {
            if (_usermodels == null)
            {
                _usermodels = getUserModels(ApplicationID);
                /*
                DataRow[] rows;
                string RoldID = "";
                rows = eBase.a_eke_sysUsers.Select("UserID='" + user["ID"].ToString() + "'");
                if (rows.Length > 0) RoldID = rows[0]["roleid"].ToString();

                rows = eBase.a_eke_sysPowers.Select("canList=1 and ApplicationID='" + ApplicationID + "' and (UserID='" + user["ID"].ToString() + "' or Convert(RoleID, 'System.String') in ('" + RoldID.Replace(",", "','") + "'))");
                if (rows.Length == 0)
                {
                    _usermodels = new DataTable();
                    _usermodels.Columns.Add("ApplicationItemID", typeof(string));
                    _usermodels.Columns.Add("ModelID", typeof(string));
                }
                else
                {

                    _usermodels = rows[0].Table.Clone();
                    foreach (DataRow dr in rows)
                    {
                        DataRow[] drs = eBase.a_eke_sysPowers.Select("canList=0 and ApplicationItemID='" + ApplicationItemID + "' and ModelID='" + dr["ModelID"].ToString() + "' and RoleID is null");
                        if (drs.Length == 0)
                        {
                            _usermodels.Rows.Add(dr.ItemArray);
                        }
                    }
                    //_models = eBase.toDataTable(rows);
                    _usermodels = _usermodels.DefaultView.ToTable(true, "ApplicationItemID", "ModelID");
                }
                */

            }
            //eBase.PrintDataTable(_usermodels);
            return _usermodels;
        }
    }
    private DataTable getUserModels(string ApplicationID)
    {
        DataTable _usermodels;
        DataRow[] rows;
        // string RoldID = eOleDB.getValue("select roleid from a_eke_sysUsers where UserID='" + user["ID"].ToString() + "'");
        string RoldID = "";
        rows = eBase.a_eke_sysUsers.Select("UserID='" + user["ID"].ToString() + "'");
        if (rows.Length > 0)
        {
            RoldID = rows[0]["roleid"].ToString();
        }
        else
        {
            RoldID = eBase.UserInfoDB.getValue("select roleid from a_eke_sysUsers where UserID='" + user["ID"].ToString() + "'");
        }
       


        rows = eBase.a_eke_sysPowers.Select("canList=1 and ApplicationID='" + ApplicationID + "' and (UserID='" + user["ID"].ToString() + "' or Convert(RoleID, 'System.String') in ('" + RoldID.Replace(",", "','") + "'))");
        if (rows.Length == 0)
        {
            _usermodels = new DataTable();
            _usermodels.Columns.Add("ApplicationItemID", typeof(string));
            _usermodels.Columns.Add("ModelID", typeof(string));
        }
        else
        {

            _usermodels = rows[0].Table.Clone();
            foreach (DataRow dr in rows)
            {
                DataRow[] drs = eBase.a_eke_sysPowers.Select("canList=0 and ApplicationItemID='" + ApplicationItemID + "' and ModelID='" + dr["ModelID"].ToString() + "' and RoleID is null and UserID='" + user["ID"].ToString() + "'");
                if (drs.Length == 0)
                {
                    _usermodels.Rows.Add(dr.ItemArray);
                }
            }
            //_models = eBase.toDataTable(rows);
            _usermodels = _usermodels.DefaultView.ToTable(true, "ApplicationItemID", "ModelID");
            
        }
        return _usermodels;
    }
    //应用下所有模块
    private DataTable _appitems;
    public DataTable AppItems
    {
        get
        {
            if (_appitems == null)
            {
                DataRow[] rows = eBase.a_eke_sysApplicationItems.Select("ApplicationID='" + ApplicationID + "'");
                if (rows.Length == 0)
                {
                    _appitems = eBase.a_eke_sysApplicationItems.Clone();
                    _appitems.Columns.Add("AspxFile", typeof(string));
                    _appitems.Columns.Add("AutoLayout", typeof(bool));
                    
                }
                else
                {

                    _appitems = eBase.toDataTable(rows);
                    _appitems.Columns.Add("AspxFile", typeof(string));
                    _appitems.Columns.Add("AutoLayout", typeof(bool));
                    DataRow[] rs;
                    foreach (DataRow dr in _appitems.Rows)
                    {
                        rs = eBase.a_eke_sysModels.Select("ModelID='" + dr["modelID"].ToString() + "'");
                        if (rs.Length > 0)
                        {
                            dr["AspxFile"] = rs[0]["AspxFile"].ToString();
                            dr["AutoLayout"] = rs[0]["AutoLayout"];
                        }
                    }

                }


            }
            return _appitems;
        }
    }
    private string curmenuids = "";
    public string curMenuIDS  //当前菜单ID及所有上级
    {
        get
        {
            return curmenuids;
        }
        set
        {
            curmenuids = value;
        }
    }
    private List<string> _allMenuIDS = new List<string>();////所有模块及模块的上级菜单编号
    public List<string> allMenuIDS
    {
        get 
        {
            return _allMenuIDS;
        }
    }
    
    private DataTable _userapps;
    public DataTable UserApps
    {
        get
        {
            if (_userapps == null)
            {
               // string RoldID = eOleDB.getValue("select roleid from a_eke_sysUsers where UserID='" + user["ID"].ToString() + "'");
                string RoldID = "";
                DataRow[] rows = eBase.a_eke_sysUsers.Select("UserID='" + user["ID"].ToString() + "'");
                if (rows.Length > 0)
                {
                    RoldID = rows[0]["roleid"].ToString();
                }
                else
                {
                    RoldID = eBase.UserInfoDB.getValue("select roleid from a_eke_sysUsers where UserID='" + user["ID"].ToString() + "'");
                }
                //eBase.Writeln(RoldID);
                string sql = "SELECT c.Finsh,c.ApplicationItemID,a.ApplicationID,a.ModelID,a.RoleID,a.UserID,b.MC,c.MC as modelName,c.url,c.ParentID,c.px,'../' + b.pic as Pic,d.AutoLayout,d.AspxFile,c.addTime,b.px as appSort  FROM a_eke_sysPowers2 a ";
                sql += " inner join a_eke_sysApplications b on a.ApplicationID=b.ApplicationID ";
                sql += " inner join a_eke_sysApplicationItems c on a.ApplicationItemID=c.ApplicationItemID and a.ModelID=c.ModelID ";
                sql += " left join a_eke_sysModels d on c.ModelID=d.ModelID";
                sql += " where a.delTag=0 and a.canList=1 and a.ApplicationID is not null ";
                sql += " and (a.UserID='" + user["ID"].ToString() + "'" + (RoldID.Length > 0 ? " or a.RoleID in ('" + RoldID.Replace(",", "','") + "')" : " and a.RoleID is null") + ") ";
                //sql += " and a.ApplicationID in (select ApplicationID from a_eke_sysSiteItems where SiteID='" + user["siteid"] + "' and delTag=0)";
                //sql += "order by b.ApplicationID, b.PX,b.addTime ";
                 //eBase.Writeln(sql);
                //_userapps = eOleDB.getDataTable(sql);                
                //eBase.PrintDataTable(_userapps);


                rows = eBase.a_eke_sysSiteItems.Select("SiteID='" + user["siteid"] + "'");
                string appids = "";
                for (int i = 0; i < rows.Length; i++)
                {
                    if (i > 0) appids += ",";
                    appids += "'" + rows[i]["ApplicationID"].ToString() + "'";
                }
                DataRow[] rs = eBase.a_eke_sysPowers.Select("(UserID='" + user["ID"].ToString() + "'" + (RoldID.Length > 0 ? " or Convert(RoleID, 'System.String') in ('" + RoldID.Replace(",", "','") + "')" : " and RoleID is null") + ")  and canList=1 and ApplicationID is not null and Convert(ApplicationID, 'System.String') in (" + appids + ")");

               // eBase.PrintDataRow(rs);
                _userapps = rs.toDataTable().Select("ApplicationID,ApplicationItemID,ModelID,RoleID,UserID", "", "");


                _userapps.Columns.Add("MC", typeof(string));
                _userapps.Columns.Add("Pic", typeof(string));
                _userapps.Columns.Add("appSort", typeof(int));


                _userapps.Columns.Add("modelName", typeof(string));
                _userapps.Columns.Add("Finsh", typeof(bool));
                _userapps.Columns.Add("url", typeof(string));
                _userapps.Columns.Add("ParentID", typeof(Guid));
                _userapps.Columns.Add("px", typeof(int));
                _userapps.Columns.Add("addTime", typeof(DateTime));


                _userapps.Columns.Add("AutoLayout", typeof(bool));
                _userapps.Columns.Add("AspxFile", typeof(string));

                foreach (DataRow dr in _userapps.Rows)
                {
                    DataRow[] _rs = eBase.a_eke_sysApplications.Select("ApplicationID='" + dr["ApplicationID"].ToString() + "'");
                    if (_rs.Length > 0)
                    { 
                        dr["mc"] = _rs[0]["mc"];
                        dr["Pic"] = "../" + _rs[0]["Pic"];
                        dr["appSort"] = _rs[0]["PX"];
                    }
                    _rs = eBase.a_eke_sysApplicationItems.Select("ApplicationItemID='" + dr["ApplicationItemID"].ToString() + "'");
                    if (_rs.Length > 0)
                    {
                        dr["modelName"] = _rs[0]["mc"];
                        dr["Finsh"] = _rs[0]["Finsh"];
                        dr["url"] = _rs[0]["url"];
                        dr["ParentID"] = _rs[0]["ParentID"];
                        dr["px"] = _rs[0]["px"];
                        dr["addTime"] = _rs[0]["addTime"];
                    }
                    _rs = eBase.a_eke_sysModels.Select("ModelID='" + dr["ModelID"].ToString() + "'");
                    if (_rs.Length > 0)
                    {
                        dr["AutoLayout"] = _rs[0]["AutoLayout"];
                        dr["AspxFile"] = _rs[0]["AspxFile"];
                    }
                }

                

                //eBase.PrintDataRow(rs);
                //eBase.Writeln(rs.Length.ToString());
                //eBase.Writeln(appids);
               // eBase.End();
            }
            return _userapps;
        }
    }

    public ApplicationMenu(eUser user)
	{
       
        this.user = user;
       // eBase.PrintDataTable(UserModels);
        ApplicationItemID = eParameters.Request("AppItem");
        ApplicationID = eParameters.Request("AppID");       
        DataRow[] rows;
        if (ApplicationItemID.Length == 0)
        {
            if (UserApps.Rows.Count == 0) return;
            if (ApplicationID.Length == 0)
            {              
                UserApps.DefaultView.Sort = "appSort";
                DataTable tb = UserApps.DefaultView.ToTable(true, "ApplicationID", "MC", "Pic");
                if (tb.Rows.Count == 0) return;
                ApplicationID = tb.Rows[0]["ApplicationID"].ToString();
            }

            //rows = UserApps.Select("ApplicationID='" + ApplicationID + "'", "px,addTime");
            //if (rows.Length == 0) return;
            //ApplicationItemID = rows[0]["ApplicationItemID"].ToString();
            //ModelID = rows[0]["ModelID"].ToString();
            //string topappitemid = getTopAppItemID(ApplicationID, "");
           // 
            ApplicationItemID = getTopAppItemID(ApplicationID, "");
            if (ApplicationItemID.Length > 0)
            {
                rows = UserApps.Select("ApplicationItemID='" + ApplicationItemID + "'", "px,addTime");
                if (rows.Length > 0)
                {
                    ModelID = rows[0]["ModelID"].ToString();
                }
            }
         
        }
        else
        {

            rows = eBase.a_eke_sysApplicationItems.Select("ApplicationItemID='" + ApplicationItemID + "'");
            if (rows.Length == 0) return;
            ApplicationID = rows[0]["ApplicationID"].ToString();
            ModelID = rows[0]["ModelID"].ToString();
        }

        curMenuIDS = getCurMenuIDS(ApplicationItemID);
        //eBase.Writeln(curMenuIDS);
        //eBase.PrintDataTable(UserModels);
        foreach (DataRow dr in UserModels.Rows)
        {
            addAllMenuIDS(dr["ApplicationItemID"].ToString());
        }

	}
    public string gethref(DataRow dr)
    {
        string url = "";
        if (dr["Finsh"].ToString() == "False")
        {
            url = "Model.aspx?AppItem=" + dr["ApplicationItemID"].ToString() + "&act=building";
        }
        else
        {
            if ( dr["URL"].ToString().Length > 0 || dr["AspxFile"].ToString().Length > 0)
            {
                if (dr["URL"].ToString().Length > 0)
                {
                    url = dr["URL"].ToString();
                    if (url.ToLower().IndexOf("appitem=") == -1)
                    {
                        url += (url.IndexOf("?") == -1 ? "?" : "&") + "AppItem=" + dr["ApplicationItemID"].ToString();
                    }
                }
                else
                {

                    url = (dr["AutoLayout"].ToString().ToLower() == "true" ? "Custom.aspx" : dr["AspxFile"].ToString()) + "?AppItem=" + dr["ApplicationItemID"].ToString();
                }
            }
            else
            {
                url = "Model.aspx?AppItem=" + dr["ApplicationItemID"].ToString();
            }
        }
        if (HttpContext.Current.Request.QueryString["debug"] != null)
        {
            url += (url.IndexOf("?") == -1 ? "?" : "&") + "debug=1";
        }
        return url;
    }
    public string getTopAppItemID(string ApplicationID, string ParentID)
    {
        DataTable tb = getUserModels(ApplicationID);
        DataRow[] rows = eBase.a_eke_sysApplicationItems.Select("ApplicationID='" + ApplicationID + "' and Show=1" + (ParentID.Length == 0 ? " and ParentID is Null and Show=1" : " and ParentID='" + ParentID + "'"), "PX,addTime");
        for (int i = 0; i < rows.Length; i++)
        {
            if (rows[i]["ModelID"].ToString().Length == 0) return getTopAppItemID(ApplicationID, rows[i]["ApplicationItemID"].ToString());
            if (rows[i]["Finsh"].ToString() == "False" && rows[i]["ModelID"].ToString().Length > 0) return rows[i]["ApplicationItemID"].ToString();
            DataRow[] rs = tb.Select("ApplicationItemID='" + rows[i]["ApplicationItemID"].ToString() + "'");
            if (rs.Length == 0) continue;
            if (rows[i]["ModelID"].ToString().Length > 0)
            {
                return rows[i]["ApplicationItemID"].ToString();
            }
        }
        return "";
    }
    public string getTopModelUrl(string ApplicationID)
    {
        if (ApplicationID.Length == 0) return "javascript:;";
        string topAppItemID = getTopAppItemID(ApplicationID, "");
        DataRow dr;
        if (topAppItemID.Length == 0)
        {
            DataRow[] rows = UserApps.Select("ApplicationID='" + ApplicationID + "'");
            if (rows.Length == 0) return "javascript:;";
            dr = rows[0];
        }
        else
        {
            DataRow[] rows = UserApps.Select("ApplicationItemID='" + topAppItemID + "'");
            if (rows.Length == 0) return "javascript:;";
            dr = rows[0];
        }
        if (dr["Finsh"].ToString() == "False")
        {
            return "Model.aspx?AppItem=" + dr["ApplicationItemID"].ToString() + "&act=building";
        }
        else
        {
            if (dr["URL"].ToString().Length > 0)
            {
                string url = dr["URL"].ToString();
                if (url.ToLower().IndexOf("appitem=") == -1)
                {
                    url += (url.IndexOf("?") == -1 ? "?" : "&") + "AppItem=" + dr["ApplicationItemID"].ToString();
                }
                return url;                
            }
            else
            {
                if (dr["AutoLayout"].ToString().ToLower() == "false" && dr["AspxFile"].ToString().Length>0)
                {
                    return dr["AspxFile"].ToString() + "?AppItem=" + dr["ApplicationItemID"].ToString();
                }
                return (dr["AspxFile"].ToString().Length > 0 ? "Custom.aspx" : "Model.aspx") + "?AppItem=" + dr["ApplicationItemID"].ToString();
            }
        }
    }
    private string getCurMenuIDS(string ApplicationItemID)
    {
        if (ApplicationItemID.Length == 0) return "";
        string _back = "";
        DataRow[] rows = AppItems.Select("ApplicationItemID='" + ApplicationItemID + "'");
        if (rows.Length == 0) return "";
        if (rows[0]["PackID"].ToString().Length > 0) _back = rows[0]["PackID"].ToString() + ",";

        string pid = rows[0]["ParentID"].ToString();

        if (pid.Length == 0)
        {

            _back += ApplicationItemID;
        }
        else
        {

            _back += getCurMenuIDS(pid) + "," + ApplicationItemID;
        }

        return _back;
    }
    private void addAllMenuIDS(string ApplicationItemID)
    {


        DataRow[] rows = AppItems.Select("ApplicationItemID='" + ApplicationItemID + "'");
        if (rows.Length > 0)
        {
            if (!allMenuIDS.Contains(ApplicationItemID))   allMenuIDS.Add(ApplicationItemID);
       
            string ParentID = rows[0]["ParentID"].ToString();
            if (ParentID.Length > 0)
            {
                addAllMenuIDS(ParentID);
            }
        }
    }
}
public class ModelMenu
{
    private eUser user;
    private string modelid = "";
    public string ModelID
    {
        get
        {
            return modelid;
        }
        set
        {
            modelid = value;
        }
    }
    private string curmenuids = "";
    public string curMenuIDS  //当前菜单ID及所有上级
    {
        get
        {
            return curmenuids;
        }
        set
        {
            curmenuids = value;
        }
    }
    private List<string> _allMenuIDS = new List<string>();//所有模块及模块的上级菜单编号
    public List<string> allMenuIDS
    {
        get {
            return _allMenuIDS;
        }
    }

    //当前用户有权限的所有模块
    private DataTable _usermodels;
    public DataTable UserModels
    {
        get
        {
            if (_usermodels == null)
            {
                // string roleids = eOleDB.getValue("select roleid from a_eke_sysUsers where UserID='" + user["ID"].ToString() + "'");
                string roleids = "";
                DataRow[] rows = eBase.a_eke_sysUsers.Select("UserID='" + user.ID + "'");
                if (rows.Length > 0)
                {
                    roleids = rows[0]["RoleID"].ToString();
                }
                else
                {
                    roleids = eBase.UserInfoDB.getValue("select roleid from a_eke_sysUsers where UserID='" + user["ID"].ToString() + "'");
                }
               

                _usermodels = eBase.a_eke_sysModels.Clone();
                _usermodels.PrimaryKey = null;
                rows = eBase.a_eke_sysPowers.Select("canList=1 and (UserID='" + user.ID + "'" + (" or Convert(RoleID, 'System.String') in ('" + roleids.Replace(",", "','") + "')") + ") and ApplicationID is Null");
                string ids = "";
                int idx = 0;
                foreach (DataRow dr in rows)
                {
                    if (idx > 0) ids += ",";
                    ids += "'" + dr["ModelID"].ToString() + "'";
                    idx++;
                    DataRow[] rowsa = eBase.a_eke_sysModels.Select("ModelID='" + dr["ModelID"].ToString() + "'");
                    if (rowsa.Length > 0)
                    {
                        _usermodels.Rows.Add(rowsa[0].ItemArray);
                    }

                }
            }
            return _usermodels;
        }
    }
    //所有模块
    private DataTable _allmodels;
    public DataTable allModels
    {
        get
        {
            if (_allmodels == null)
            {
                DataRow[] rows = eBase.a_eke_sysModels.Select("subModel=0", "px,addTime desc");
                if (rows.Length == 0)
                {
                    _allmodels = eBase.a_eke_sysModels.Clone();
                }
                else
                {
                    _allmodels = eBase.toDataTable(rows);
                }
            }

            return _allmodels;
        }
    }
    public ModelMenu(eUser user)
    {
        this.user = user;
        modelid = eParameters.Request("modelid");
        if (modelid.Length == 0) return;
        curMenuIDS = getCurMenuIDS(modelid);
        foreach (DataRow dr in UserModels.Rows)
        {
            addAllMenuIDS(dr["ModelID"].ToString());
        }
    }
    public string gethref(DataRow dr)
    {
        string url = "";
        if (dr["Finsh"].ToString() == "False")
        {
            url = "Model.aspx?ModelID=" + dr["ModelID"].ToString() + "&act=building";
        }
        else
        {
            if (dr["AspxFile"].ToString().Length > 0 && dr["Auto"].ToString() == "False")
            {
                url = "Custom.aspx?ModelID=" + dr["ModelID"].ToString();
            }
            else
            {
                url = "Model.aspx?ModelID=" + dr["ModelID"].ToString();
            }
        }
        url+= HttpContext.Current.Request.QueryString["debug"] != null ? "&debug=1" : "";
        return url;
    }
    private string getCurMenuIDS(string ModelID)
    {
        if (ModelID.Length == 0) return "";
        string _back = "";
        DataRow[] rows = allModels.Select("ModelID='" + ModelID + "'");
        if (rows.Length == 0) return "";
        string pid = rows[0]["ParentID"].ToString();
        if (pid.Length == 0)
        {
            _back = ModelID;
        }
        else
        {
            _back = getCurMenuIDS(pid) + "," + ModelID;
        }
        return _back;
    }
    private void addAllMenuIDS(string ModelID)
    {
        DataRow[] rows = allModels.Select("ModelID='" + ModelID + "'");
        if (rows.Length > 0)
        {
            allMenuIDS.Add(ModelID);
            string ParentID = rows[0]["ParentID"].ToString();
            if (ParentID.Length > 0)
            {
                addAllMenuIDS(ParentID);
            }
        }
    }
}