﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using EKETEAM.Data;
using EKETEAM.FrameWork;
using ICSharpCode.SharpZipLib.Zip;
using System.IO;


namespace eFrameWork.Manage
{
    public partial class DBManage : System.Web.UI.Page
    {
        public string UserArea = "Manage";
        public eModel model;
        public eUser user;
        protected void Page_Load(object sender, EventArgs e)
        {
            user = new eUser(eBase.getUserArea(UserArea));
            user.Check();
            eModelInfo customModel = new eModelInfo(user);
            model = customModel.Model;

           
            

            if (Request.Files.Count > 0)
            {
                HttpPostedFile file = imgFile.PostedFile;
                if (file.ContentLength > 0)
                {                    
                    string dirpath = Server.MapPath("../backup/db/");
                    file.SaveAs(dirpath + file.FileName);
                    Response.Write("<script>alert('上传成功!');document.location.href='" + Request.UrlReferrer.PathAndQuery + "';</script>");
                    Response.End();
                }
            }
            string act = eParameters.QueryString("act");
            if (act.Length > 0)
            {
                string name = eParameters.QueryString("name");
                switch (act.ToLower())
                {
                    case "backup":
                        backup(name);
                        //Response.Redirect(Request.UrlReferrer.PathAndQuery, true);
                        Response.Write("<script>alert('备份成功!');document.location.href='" + Request.UrlReferrer.PathAndQuery + "';</script>");
                        Response.End();
                        break;
                    case "restore":
                        if (!model.Power.Table.Columns.Contains("restore") || model.Power["restore"].ToString().ToLower() == "false")
                        {
                            Response.Write("<script>alert('没有权限!');document.location.href='" + Request.UrlReferrer.PathAndQuery + "';</script>");
                            Response.End();
                        }
                        Restore(name);
                        //Response.Redirect(Request.UrlReferrer.PathAndQuery, true);
                        Response.Write("<script>alert('恢复成功!');document.location.href='" + Request.UrlReferrer.PathAndQuery + "';</script>");
                        Response.End();
                        break;
                    case "download":
                        string fileName = "db" + name + ".zip";//客户端保存的文件名 
                        string filePath = Server.MapPath("../backup/db/db" + name + ".zip");//路径 
                        FileInfo fileInfo = new FileInfo(filePath);
                        Response.Clear();
                        Response.ClearContent();
                        Response.ClearHeaders();
                        Response.AddHeader("Content-Disposition", "attachment;filename=" + fileName);
                        Response.AddHeader("Content-Length", fileInfo.Length.ToString());
                        Response.AddHeader("Content-Transfer-Encoding", "binary");
                        Response.ContentType = "application/octet-stream";
                        Response.ContentEncoding = System.Text.Encoding.GetEncoding("utf-8");
                        Response.WriteFile(fileInfo.FullName);
                        Response.Flush();
                        Response.End();
                        break;
                    case "del":     
                        try
                        {
                            string path = Server.MapPath("../backup/db/db" + name + ".zip");
                            File.Delete(path);
                        }
                        catch { }
                        //Response.Redirect(Request.UrlReferrer.PathAndQuery, true);
                        Response.Write("<script>alert('删除成功!');document.location.href='" + Request.UrlReferrer.PathAndQuery + "';</script>");
                        Response.End();
                        break;
                }
            }
            else
            {
                LitBody.Text = list();
            }
        }
        private string list()
        {
            StringBuilder sb = new StringBuilder();

            string basepath = Server.MapPath("../backup/db/");


            sb.Append("<table border=\"0\" cellpadding=\"6\" cellspacing=\"1\" bgcolor=\"#cccccc\" style=\"font-size:12px;\">\r\n");
            sb.Append("<tr bgcolor=\"#f2f2f2\">\r\n");
            sb.Append("<td width=\"60\" height=\"21\" style=\"padding:6px;\">序号</td>\r\n");
            sb.Append("<td width=\"80\" style=\"padding:6px;\">文件名称</td>\r\n");
            sb.Append("<td width=\"150\" style=\"padding:6px;\">备份时间</td>\r\n");
            sb.Append("<td width=\"180\" style=\"padding:6px;\">操作</td>\r\n");
            sb.Append("</tr>\r\n");

            for (int i = 1; i < 4; i++)
            {
                sb.Append("<tr bgcolor=\"#ffffff\">\r\n");
                sb.Append("<td style=\"padding:6px;\">" + i.ToString() + "</td>\r\n");

                string path = basepath + "db" + i.ToString() + ".zip";
                if (File.Exists(path))
                {
                    FileInfo file = new FileInfo(path);
                    sb.Append("<td style=\"padding:6px;\">" + file.Name + "</td>\r\n");
                    sb.Append("<td style=\"padding:6px;\">" + string.Format("{0:yyyy-MM-dd HH:mm:ss}", file.CreationTime) + "</td>\r\n");
                    sb.Append("<td style=\"padding:6px;\">");

                   
                    sb.Append("<a href=\"?act=restore&name=" + i.ToString() + "\" onclick=\"javascript:return confirm('确认要恢复吗？');\">恢复</a>&nbsp;&nbsp;");
                    sb.Append("<a href=\"?act=download&name=" + i.ToString() + "\" target=\"_blank\">下载</a>&nbsp;&nbsp;");
                    sb.Append("<a href=\"?act=del&name=" + i.ToString() + "\" onclick=\"javascript:return confirm('确认要删除吗？');\">删除</a>&nbsp;&nbsp;");
                    sb.Append("</td>\r\n"); 
                }
                else
                {
                    sb.Append("<td style=\"padding:6px;\">&nbsp;</td>\r\n");
                    sb.Append("<td style=\"padding:6px;\">&nbsp;</td>\r\n");
                    sb.Append("<td style=\"padding:6px;\">");
                    sb.Append("<a href=\"?act=backup&name=" + i.ToString() + "\">建立备份</a>&nbsp;&nbsp;");
                    

                    sb.Append("</td>\r\n");
                }
                  sb.Append("</tr>\r\n");

            }



            sb.Append("</table>\r\n");
            return sb.ToString();
        }
        private void backup(string name)
        {
            string dbname = eOleDB.Connection.Database;
            string basePath = Server.MapPath("../backup/db/");
            if (!Directory.Exists(basePath)) Directory.CreateDirectory(basePath);


            string path = Server.MapPath("../backup/db/db" + name + ".bak");
            string sql = "BACKUP DATABASE [" + dbname + "] TO DISK = '" + path + "' With format,init";
            eOleDB.Execute(sql);

            FastZip zip = new FastZip();
            string targetpath = Server.MapPath("../backup/db/db" + name + ".zip");
            zip.CreateZip(targetpath, Server.MapPath("../backup/db/"), true,  "db" + name + ".bak");

            try
            {
                System.IO.File.Delete(path);
            }
            catch
            {
            }
        }
        private void Restore(string name)
        {
            FastZip zip = new FastZip();
            string targetpath = Server.MapPath("../backup/db/db" + name + ".zip");
            zip.ExtractZip(targetpath, Server.MapPath("../backup/db/"), "");


            string dbname = eOleDB.Connection.Database;
            string path = Server.MapPath("../backup/db/db" + name + ".bak");

            string sql = "select spid from  master..sysprocesses where db_name(dbid)= '" + dbname + "'";
            DataTable tb = eOleDB.getDataTable(sql);
            foreach (DataRow dr in tb.Rows)
            {
                eOleDB.Execute("exec('kill " + dr["spid"].ToString() + "')");
            }

            eOleDB.Execute("use master ");
            sql = "RESTORE DATABASE " + dbname + " FROM DISK='" + path + "' WITH REPLACE,RECOVERY";
            eOleDB.Execute(sql);


            try
            {
                System.IO.File.Delete(path);
            }
            catch
            {
            }
        }
        protected void Page_PreRender(object sender, EventArgs e)
        {
            Literal lit = (Literal)Master.FindControl("LitTitle");
            if (lit != null)
            {
                lit.Text = "备份还原 - " + eConfig.manageName();
            }
        }
    }
}