﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using EKETEAM.FrameWork;
using EKETEAM.Data;
using LitJson;


namespace eFrameWork.Manage
{
    public partial class ModelItems_Basic : System.Web.UI.Page
    {
        public string modelid = eParameters.QueryString("modelid");
        public string getJsonText(string jsonstr,string name)
        {
            StringBuilder sb = new StringBuilder();
            if (jsonstr.Length > 0)
            {
                eJson json = new eJson(jsonstr);
                foreach (eJson m in json.GetCollection())
                {
                    sb.Append("<span style=\"display:inline-block;margin-right:6px;border:1px solid #ccc;padding:3px 12px 3px 12px;\">" + HttpUtility.HtmlDecode(m.GetValue(name)) + "</span>");
                }
            }
            return sb.ToString();
        }
        private DataTable _allmodels;
        public DataTable allModels
        {
            get
            {
                if (_allmodels == null)
                {
                    _allmodels = eOleDB.getDataTable("select * from a_eke_sysModels where delTag=0");
                }
                return _allmodels;
            }
        }

        private JsonData _propertys;
        public JsonData Propertys
        {
            get
            {
                if (_propertys == null)
                {
                    _propertys = JsonMapper.ToObject("{}");
                    if (ModelInfo.Table.Columns.Contains("Propertys") && ModelInfo["Propertys"].ToString().Length > 2 && ModelInfo["Propertys"].ToString().StartsWith("{"))
                    {
                        _propertys = JsonMapper.ToObject(ModelInfo["Propertys"].ToString());
                    }
                }
                return _propertys;
            }
        }
        private DataRow _modelinfo;
        public DataRow ModelInfo
        {
            get
            {
                if (_modelinfo == null)
                {
                    DataTable dt = eOleDB.getDataTable("select * from a_eke_sysModels where ModelID='" + modelid + "'");
                    if (dt.Rows.Count > 0) _modelinfo = dt.Rows[0];
                }
                return _modelinfo;
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {

            DataRow dr = allModels.Select("modelid='" + modelid + "'")[0];



            if (eConfig.showHelp())
            {
                Response.Write("<div class=\"tips\" style=\"margin-bottom:6px;\">");
                Response.Write("<b>基本设置</b><br>管理列在表单的添加、编辑、查看的基本参数。");
                Response.Write("</div> ");
            }



            Response.Write("&nbsp;表单列数：<input type=\"text\" value=\"" + dr["AddColumnCount"].ToString() + "\" oldvalue=\"" + dr["AddColumnCount"].ToString() + "\"  class=\"edit\" style=\"width:40px;\" onBlur=\"setModel(this,'addcolumncount');\" />");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(61);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");

           

            Response.Write("&nbsp;&nbsp;查看状态显示编辑、删除按钮：");
            Response.Write("<select onchange=\"setModelPropertys(this,'viewActionBotton');\">");//移动端-默认打开
            Response.Write("<option value=\"true\"" + (Propertys.getValue("viewActionBotton") == "true" ? " selected=\"true\"" : "") + ">显示</option>");
            Response.Write("<option value=\"false\"" + (Propertys.getValue("viewActionBotton") == "false" || Propertys.getValue("viewActionBotton").Length == 0 ? " selected=\"true\"" : "") + ">不显示</option>");
            Response.Write("</select>");
            Response.Write("<br>");

            if (dr["subModel"].ToString()=="False" && dr["auto"].ToString().ToLower() == "false")
            {
                Response.Write("&nbsp;启用母版页：");
                Response.Write("<select onchange=\"setModel(this,'AutoLayout');\">");
                Response.Write("<option value=\"true\"" + (dr["AutoLayout"].ToString().ToLower() == "true" ? " selected=\"true\"" : "") + ">是</option>");
                Response.Write("<option value=\"false\"" + (dr["AutoLayout"].ToString().ToLower() == "false" ? " selected=\"true\"" : "") + ">否</option>");
                Response.Write("</select><br>");
            }

            //Response.Write("&nbsp;保存文本：<input type=\"text\" value=\"" + System.Web.HttpUtility.HtmlEncode(dr["TextFields"].ToString()) + "\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(dr["TextFields"].ToString()) + "\"  class=\"edit\" style=\"width:540px;\" onBlur=\"setModel(this,'textfields');\" />");
            //Response.Write("&nbsp;模块权限：<input type=\"text\" value=\"" + System.Web.HttpUtility.HtmlEncode(dr["Power"].ToString()) + "\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(dr["Power"].ToString()) + "\"  class=\"edit\" style=\"width:540px;\" onBlur=\"setModel(this,'power');\" />"); 

            if (dr["subModel"].ToString() == "True" && dr["JoinMore"].ToString() == "True")
            {
                Response.Write("&nbsp;添加方式：");
                Response.Write("<select onchange=\"setModel(this,'AddMode');\">");
                Response.Write("<option value=\"0\"" + (dr["AddMode"].ToString() == "0" ? " selected=\"true\"" : "") + ">逐个添加</option>");
                Response.Write("<option value=\"1\"" + (dr["AddMode"].ToString() == "1" ? " selected=\"true\"" : "") + ">选择添加</option>");
                Response.Write("</select><br>");
            }

            Response.Write("<div>");
            Response.Write("&nbsp;保存文本：");
            Response.Write("<textarea reload=\"true\" id=\"model_textfields\" jsonformat=\"[{&quot;text&quot;:&quot;表单Name&quot;,&quot;value&quot;:&quot;frmName&quot;},{&quot;text&quot;:&quot;字段编码&quot;,&quot;value&quot;:&quot;Field&quot;}]\" name=\"textarea\" style=\"width:80%;display:none;\" rows=\"2\"  onBlur=\"setModel(this,'textfields');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(dr["TextFields"].ToString()) + "\">" + System.Web.HttpUtility.HtmlEncode(dr["TextFields"].ToString()) + "</textarea>");
            Response.Write("<img src=\"images/jsonedit.png\" style=\"cursor:pointer;margin-right:5px;\" align=\"absmiddle\" onclick=\"Json_Edit('model_textfields','保存文本');\">");
            Response.Write(getJsonText(dr["TextFields"].ToString(), "Field"));
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(62);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("</div>");

            if (dr["subModel"].ToString()=="False")
            {
                Response.Write("<div>");
                Response.Write("&nbsp;模块权限：");
                Response.Write("<textarea reload=\"true\" id=\"model_power\" jsonformat=\"[{&quot;text&quot;:&quot;文本&quot;,&quot;value&quot;:&quot;text&quot;},{&quot;text&quot;:&quot;值&quot;,&quot;value&quot;:&quot;value&quot;}]\" name=\"textarea\" style=\"width:80%;display:none;\" rows=\"2\"  onBlur=\"setModel(this,'power');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(dr["Power"].ToString()) + "\">" + System.Web.HttpUtility.HtmlEncode(dr["Power"].ToString()) + "</textarea>");
                Response.Write("<img src=\"images/jsonedit.png\" style=\"cursor:pointer;margin-right:5px;\" align=\"absmiddle\" onclick=\"Json_modelPowerEdit('model_power');\">");
                Response.Write(getJsonText(dr["Power"].ToString(), "text"));
                if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(63);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
                Response.Write("</div>");
            }



            Response.Write("<div style=\"padding:10px 0px 10px 0px;\">");
            Response.Write("<input type=\"button\" name=\"Submit\" value=\"同步编码\" onclick=\"copyCode();\" />");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(64);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("<input type=\"button\" name=\"Submit\" value=\"还原编码\" onclick=\"restoreCode();\" style=\"margin-left:20px;\" />");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(65);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("</div>");
            
            eList datalist = new eList("a_eke_sysModelItems");
            datalist.Where.Add("ModelID='" + modelid + "' and delTag=0 and (Custom=0 or len(ProgrameFile)>0 or len(cast(BindModelID as varchar(50)))>0)");
            datalist.OrderBy.Add("showadd desc,addorder, PX, addTime");
            datalist.Bind(Rep);


            eList elist = new eList("a_eke_sysModelItems");
            elist.Where.Add("ModelID='" + modelid + "' and Custom=1");
            elist.OrderBy.Add("px,addTime");
            elist.Bind(RepCustom);

            System.IO.StringWriter sw = new System.IO.StringWriter();
            HtmlTextWriter htw = new HtmlTextWriter(sw);
            Rep.RenderControl(htw);
            Rep.Visible = false;//不输出，要在获取后设，不然取不到内容。
            sw.Close();
            Response.Write(sw.ToString());

            Response.Write("<strong>自定义列：</strong><br />");
            sw = new System.IO.StringWriter();
            htw = new HtmlTextWriter(sw);
            RepCustom.RenderControl(htw);
            RepCustom.Visible = false;
            Response.Write(sw.ToString());
            sw.Close();
            Response.End();
        }
    }
}