﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using EKETEAM.FrameWork;
using EKETEAM.Data;

public partial class Manage_RunModel : System.Web.UI.Page
{
    public string UserArea = "Manage";
    public eModel model;
    public string ModelID = eParameters.Request("modelid");
    eUser user;
    protected void Page_Load(object sender, EventArgs e)
    {
        user = new eUser(eBase.getUserArea(UserArea));
        user.Check();
        model = new eModel(ModelID, user);

        #region 赋权限
        //eBase.PrintDataRow(model.Power);
        DataRow power = model.Power.Table.NewRow();     
        for (int i = 0; i < power.Table.Columns.Count; i++)
        {
            power[power.Table.Columns[i].ColumnName] = "true";            
        }
        //eBase.PrintDataRow(power);
        model.Power=power;
        #endregion

        switch (model.Action.Value)
        {
            case "building":
                LitBody.Text = "<div style=\"padding:50px; height:100%; text-align:center; \"><img src=\"../images/Building.jpg\" style=\"width:390px;\" /></div>";
                break;
            case "delmore": //批量删除
                string ids = eParameters.QueryString("ids");
                ids = "'" + ids.Replace(",", "','") + "'";
                eTable etb = new eTable(model.eForm.TableName, user);
                etb.Where.Add(model.eForm.primaryKey + " in (" + ids + ")");
                etb.DeleteTrue();
                Response.Redirect(Request.UrlReferrer.PathAndQuery, true);
                break;
            case "":
                if (model.ModelInfo["type"].ToString() == "4")//报表
                {
                    LitBody.Text = model.getReportList();
                }
                else
                {
                    LitBody.Text = model.getListHTML();
                }
                break;
            case "add":
                LitBody.Text = model.getAddHTML();
                break;
            case "edit":
                LitBody.Text = model.getEditHTML();
                break;
            case "copy":
                LitBody.Text = model.getEditHTML();
                break;
            case "view":
                LitBody.Text = model.getViewHTML();
                break;
            case "print":
                eBase.Write(model.getPrintHTML());
                eBase.End();
                break;
            case "save":
                model.Save();
                break;
            case "del":
                model.Delete();
                break;
            case "addsub":
                eBase.Write(model.getAddHTML());
                eBase.End();
                break;
            case "viewsub":
                eBase.Write(model.getViewHTML());
                eBase.End();
                break;
            case "export":
                model.ExportExcel();
                break;
            case "getrole":
                string roleid = eParameters.QueryString("roleid");
                string userid = eParameters.QueryString("id");
                DataTable rolePower = eBase.getUserPowerDefault(roleid, userid, "");
                eJson json = new eJson(rolePower);
                json.Convert = true;
                eBase.Write(json.ToString());
                Response.End();
                break;
        }
    }
    protected void Page_PreRender(object sender, EventArgs e)
    {
        Literal lit = (Literal)Master.FindControl("LitTitle");
        if (lit != null)
        {
            lit.Text = "运行测试 - " + eConfig.manageName();
        }


        lit = (Literal)Master.FindControl("LitJavascript");
        if (lit != null && model.Javasctipt.Length > 0) lit.Text = model.Javasctipt;


        lit = (Literal)Master.FindControl("LitStyle");
        if (lit != null && model.cssText.Length > 0) lit.Text = model.cssText;
    }
}