﻿URL1 = "https://webdemo.myscript.com/views/math/index.html";
URL2 = "https://webdemo.myscript.com/views/diagram/index.html#/edit"; 
OPTIONS = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];

function IsMobile() {
    if (/Android|webOS|iPhone|iPod|BlackBerry/i.test(navigator.userAgent.toLowerCase())) {
        return true;
    }
    return false;

}

function _P(url, w, h, t) {
    layer.open({ type: 2, content: url, area: [w + 'px', h + 'px'], title: t })
}


function Init() {


    tinymce.init({
        selector: "textarea",
        external_plugins: { 'mathjax': APPPATH+'tinymce/js/tinymce/plugins/mathjax/plugin.js' },
        mathjax: { lib: APPPATH+'javascript/mathjax/tex-mml-chtml.js', symbols: { start: '\\(', end: '\\)' } },
        plugins: " charmap code table   ",
        toolbar: "bold italic underline strikethrough forecolor  | table |  charmap  | mathjax mathsymbol |   sx  jh      | code  pic ",
        menubar: false,
        force_br_newlines: false,
        force_p_newlines: false,
        forced_root_block: '',

        setup: function (editor) {

            editor.ui.registry.addButton('pic', {
                text: '上传图片',
                onAction: function (_) {
                    layer.open({ type: 2, content: '../SimlpeUploadFile.aspx?t=img&id=' + editor.id, area: ['600px', '360px'], title: '上传图片' })
                }
            });


            editor.ui.registry.addButton('mathsymbol', {
                text: 'LaTex符号',
                onAction: function (_) {
                    layer.open({ type: 2, content: 'mathSymbol.aspx?id=' + editor.id, area: ['1200px', '650px'], title: '数学符号' })
                }
            });



            editor.ui.registry.addButton('sx', {
                text: '手写公式',
                onAction: function (_) {

                    if (IsMobile()) {
                        _P(URL1, 300, 600, '手写数理化');
                    }
                    else {
                        _P(URL1, 900, 700, '手写数理化');
                    }
                }
            });


            editor.ui.registry.addButton('jh', {
                text: '几何图形',
                onAction: function (_) {

                    if (IsMobile()) {
                        _P(URL2, 300, 600, '手写几何图形');
                    }
                    else {
                        _P(URL2, 900, 700, '手写几何图形');
                    }


                }
            });


        }

    });
}


 