﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace yinLouSys
{
    static class Program
    {
        /// <summary>
        /// 应用程序的主入口点。
        /// </summary>
        [STAThread]
        static void Main()
        {
            string conStr = System.Configuration.ConfigurationSettings.AppSettings["connectionString"];
            string my = System.Configuration.ConfigurationSettings.AppSettings["passwordKey"];
            if (my != null)
            {
                conStr = code.Base.Decrypt(conStr, my);
            }

            bool dbConnState = code.DataBaseTest.IsConnectionDB(conStr);
            if (!dbConnState)
            {
                MessageBox.Show("您设置的连接字符串不正确，请重新设置！", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                System.Diagnostics.Process.Start("ProgramSetting.exe");
                Application.Exit();
                return;
            }

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());
        }
    }
}