using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;

namespace yinLouSys.code
{
    public class SQLHelp
    {
        //ȡַ(web.configȡַ)
        private static String connStr = ConfigurationSettings.AppSettings["connectionString"];

        private static int _runC = 0;

        //־
        private static bool isTransaction = false;

        //
        private static SqlTransaction objSqlTransaction;

        //ִSQLĶ
        private static SqlCommand dbCommand;

        //ݿӶ
        private static SqlConnection dbConnection;

        //ֹʵ
        private SQLHelp() { }


        //ⲿַ
        public static string SetConnectionStr
        {
            set { connStr = value; }
            get
            {
                string my = ConfigurationSettings.AppSettings["passwordKey"];
                if (my != null && _runC == 0)
                {
                    connStr = Base.Decrypt(connStr, my);
                    _runC++;
                }
                return connStr;
            }
        }

        /// <summary>
        /// жǷ
        /// </summary>
        public static bool IsTransaction
        {
            get { return isTransaction; }
        }

        /// <summary>
        /// ִзصһеһеSQL(int)
        /// </summary>
        /// <param name="sql">ҪִеĴ洢SQL</param>
        /// <param name="parms">б</param>
        /// <returns></returns>
        public static int ExecuteScalarCommonByInt(String sql, SqlParameter[] parms, CommandType type)
        {
            SqlConnection con = new SqlConnection(SetConnectionStr);
            try
            {
                con.Open();
                SqlCommand dbCommand = new SqlCommand(sql, con);
                dbCommand.Parameters.Clear();
                dbCommand.Connection = con;
                dbCommand.CommandText = sql;
                dbCommand.CommandType = type;

                if (parms != null)
                {
                    for (int i = 0; i < parms.Length; i++)
                    {
                        dbCommand.Parameters.Add(parms[i]);
                    }
                }
                object obj = dbCommand.ExecuteScalar();

                if (obj is DBNull)
                {
                    throw new Exception("ûвҵӦ!");
                }

                return (int)obj;
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [ExecuteScalarCommonByInt()] ʱ:" + ex.Message);
            }
            finally
            {
                con.Close();
                con.Dispose();
            }
        }

        #region ִһSQL(2012324)
        /// <summary>
        /// ִһSQL
        /// </summary>
        /// <returns></returns>
        public static bool ExecuteByGroup(object[] sqls)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            connObj.Open();
            SqlTransaction tran = connObj.BeginTransaction();
            string sql = "";
            int count = 0;
            bool isSuccess = true;
            try
            {
                SqlCommand cmdObj = new SqlCommand();
                cmdObj.Transaction = tran;
                cmdObj.Connection = connObj;

                for (int i = 0; i < sqls.Length; i++)
                {
                    sql = sqls[i].ToString();
                    cmdObj.CommandText = sqls[i].ToString();
                    count = cmdObj.ExecuteNonQuery();
                    if (count <= 0)
                    {
                        isSuccess = false;
                        break;
                    }
                }
                if (isSuccess)
                {
                    tran.Commit();
                    return true;

                }
                else
                {
                    tran.Rollback();
                    return false;
                }
            }
            catch (SqlException ex)
            {
                tran.Rollback();
                throw new Exception("ִ [ExecuteScalarByInt()] SQL(" + sql + ") ʱ:" + ex.Message);
            }
            finally
            {
                connObj.Close();
                connObj.Dispose();
            }
        }
        #endregion

        /// <summary>
        /// ִSQLѯ䲢ݼ
        /// </summary>
        /// <param name="sql">ҪִеSQL</param>
        /// <param name="tabName"></param>
        /// <returns></returns>
        public static DataTable ExecuteDataTable(String sql)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            try
            {
                SqlCommand dbCommand = new SqlCommand(sql, connObj);
                DataSet ds = new DataSet();
                ds.Clear();
                dbCommand.Connection = connObj;
                dbCommand.CommandType = System.Data.CommandType.Text;
                dbCommand.CommandText = sql;
                SqlDataAdapter adapter = new SqlDataAdapter();
                adapter.SelectCommand = dbCommand;
                adapter.Fill(ds, "aa1");

                DataTable bbb = new DataTable("aa1");
                bbb = ds.Tables["aa1"];
                ds.Tables.Clear();
                return bbb;
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [ExecuteDataTable()]SQL(" + sql + ") ʱ:" + ex.Message);
            }
        }

        /// <summary>
        /// ȡһõ
        /// </summary>
        /// <returns></returns>
        public static SqlConnection GetConnection()
        {

            try
            {
                dbConnection = new SqlConnection(SetConnectionStr);
                dbCommand = new SqlCommand();

                if (dbConnection.State != ConnectionState.Open)
                {
                    dbConnection.Open();
                }
                return dbConnection;
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [GetConnection()] ʱ:" + ex.Message);
            }
        }


        /// <summary>
        /// 
        /// </summary>
        public static void StartTransaction()
        {
            GetConnection();
            objSqlTransaction = dbConnection.BeginTransaction();
            dbCommand.Transaction = objSqlTransaction;
            isTransaction = true;
        }

        /// <summary>
        /// ύ
        /// </summary>
        public static void CommitTransaction()
        {
            objSqlTransaction.Commit();
            isTransaction = false;

        }

        /// <summary>
        /// ع
        /// </summary>
        public static void BackTransacton()
        {
            if (isTransaction)
            {
                objSqlTransaction.Rollback();
                isTransaction = false;
            }
            Dispose();
        }

        /// <summary>
        /// ִSQLѯ䲢ݶȡ
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static SqlDataReader ExecuteDataReader(String sql)
        {
            SqlConnection con = new SqlConnection(SetConnectionStr);
            try
            {
                con.Open();
                SqlCommand comm = new SqlCommand(sql, con);
                return comm.ExecuteReader();
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [ExecuteDataReader()]SQL(" + sql + ") ʱ:" + ex.Message);
            }
        }




        /// <summary>
        /// ִSQLѯ䲢صһеһеֵ
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static object ExecuteScalar(String sql, SqlParameter[] parms)
        {
            SqlConnection con = new SqlConnection(SetConnectionStr);
            try
            {
                //GetConnection();
                con.Open();
                SqlCommand dbCommand = new SqlCommand(sql, con);
                if (parms != null)
                {
                    for (int i = 0; i < parms.Length; i++)
                    {
                        dbCommand.Parameters.Add(parms[i]);
                    }
                }
                object obj = dbCommand.ExecuteScalar();

                dbCommand.Dispose();
                if (obj is DBNull)
                {
                    return null;
                }

                return obj;
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [ExecuteScalar()] SQL(" + sql + ") ʱ:" + ex.Message);
            }
            finally
            {
                con.Close();
                con.Dispose();
            }
        }

        /// <summary>
        /// ִзصһеһеSQL(int)
        /// </summary>
        /// <param name="sql">ҪִеSQL</param>
        /// <param name="parms">б</param>
        /// <returns></returns>
        public static int ExecuteScalarByInt(String sql, SqlParameter[] parms)
        {
            SqlConnection con = new SqlConnection(SetConnectionStr);
            try
            {

                con.Open();
                SqlCommand dbCommand = new SqlCommand(sql, con);
                if (parms != null)
                {
                    for (int i = 0; i < parms.Length; i++)
                    {
                        dbCommand.Parameters.Add(parms[i]);
                    }
                }
                object obj = dbCommand.ExecuteScalar();

                if (obj is DBNull)
                {
                    throw new Exception("ûвҵӦ!");
                }

                return (int)obj;
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [ExecuteScalarByInt()]SQL(" + sql + ")  ʱ:" + ex.Message);
            }
            finally
            {
                con.Close();
                con.Dispose();
            }
        }

        /// <summary>
        /// ִһ޷ֵSQL
        /// </summary>
        /// <param name="sqls"></param>
        public static void ExecuteSingleValueByGroup(object[] sqls)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            connObj.Open();
            SqlTransaction tran = connObj.BeginTransaction();
            string sql = "";
            try
            {
                SqlCommand cmdObj = new SqlCommand();
                cmdObj.Transaction = tran;
                cmdObj.Connection = connObj;

                for (int i = 0; i < sqls.Length; i++)
                {
                    sql = sqls[i].ToString();
                    cmdObj.CommandText = sqls[i].ToString();
                    cmdObj.ExecuteNonQuery();
                }
                tran.Commit();
            }
            catch (SqlException ex)
            {
                tran.Rollback();
                throw new Exception("ִ [ExecuteScalarByInt()] SQL(" + sql + ") ʱ:" + ex.Message);
            }
            finally
            {
                connObj.Close();
                connObj.Dispose();
            }


        }


        /// <summary>
        /// ִSQLѯ䲢ݼ
        /// </summary>
        /// <param name="sql">ҪִеSQL</param>
        /// <returns></returns>
        public static DataSet ExecuteDataSet(String sql)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            try
            {

                SqlCommand dbCommand = new SqlCommand(sql, connObj);
                DataSet ds = new DataSet();
                dbCommand.Connection = connObj;
                dbCommand.CommandType = System.Data.CommandType.Text;
                dbCommand.CommandText = sql;
                dbCommand.CommandTimeout = 150;
                SqlDataAdapter adapter = new SqlDataAdapter();
                adapter.SelectCommand = dbCommand;
                adapter.Fill(ds);
                return ds;
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [ExecuteDataSet()]SQL(" + sql + ") ʱ:" + ex.Message);
            }
        }


        /// <summary>
        /// ִSQLѯ䲢ݼ
        /// </summary>
        /// <param name="sql">ҪִеSQL</param>
        /// <param name="tabName"></param>
        /// <returns></returns>
        public static DataTable ExecuteDataTable(String sql, String tabName)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            try
            {
                SqlCommand dbCommand = new SqlCommand(sql, connObj);
                DataSet ds = new DataSet();
                ds.Clear();
                dbCommand.Connection = connObj;
                dbCommand.CommandType = System.Data.CommandType.Text;
                dbCommand.CommandText = sql;
                SqlDataAdapter adapter = new SqlDataAdapter();
                adapter.SelectCommand = dbCommand;
                adapter.Fill(ds, tabName);

                DataTable bbb = new DataTable(tabName);
                bbb = ds.Tables[tabName];
                ds.Tables.Clear();
                return bbb;
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [ExecuteDataTable()]SQL(" + sql + ") ʱ:" + ex.Message);
            }
        }

        /// <summary>
        /// ִзעʽĲѯ(ͨ÷)
        /// </summary>
        /// <param name="sql">洢SQL</param>
        /// <param name="parms">б</param>
        /// <param name="type">SQL</param>
        /// <returns></returns>
        public static DataSet ExecuteSQLCommon(String sql, SqlParameter[] parms, CommandType type)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            try
            {
                connObj.Open();
                SqlCommand dbCommand = new SqlCommand(sql, connObj);
                dbCommand.Parameters.Clear();
                dbCommand.Connection = connObj;
                dbCommand.CommandText = sql;
                dbCommand.CommandType = type;

                SqlDataAdapter adapter = new SqlDataAdapter(dbCommand);
                DataSet ds = new DataSet();
                if (parms != null)
                {
                    for (int i = 0; i < parms.Length; i++)
                    {
                        dbCommand.Parameters.Add(parms[i]);
                    }
                }

                adapter.Fill(ds);

                return ds;
            }
            catch (SqlException ex)
            {
                if (isTransaction)
                {
                    objSqlTransaction.Rollback();
                }
                throw new Exception("ִ [ExecuteSQLCommon()]SQL(" + sql + ") ʱ:" + ex.Message);
            }
            finally
            {
                connObj.Close();
                connObj.Dispose();
            }
        }

        /// <summary>
        /// ִɾĲ
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static int ExecuteNoResult(String sql)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            try
            {
                connObj.Open();
                SqlCommand dbCommand = new SqlCommand(sql, connObj);
                dbCommand.Connection = connObj;
                dbCommand.CommandText = sql;
                return dbCommand.ExecuteNonQuery();
            }
            catch (SqlException ex)
            {
                if (isTransaction)
                {
                    objSqlTransaction.Rollback();
                }

                throw new Exception("ִ [ExecuteNoResult()] SQL(" + sql + ")ʱ:" + ex.Message);
            }
            finally
            {
                connObj.Close();
                connObj.Dispose();
            }
        }

        /// <summary>
        /// ִɾĲ
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static int ExecuteNoResult(String sql, SqlParameter[] parms, CommandType type)
        {
            SqlConnection connObj = new SqlConnection(SetConnectionStr);
            try
            {
                connObj.Open();
                SqlCommand dbCommand = new SqlCommand(sql, connObj);
                dbCommand.Connection = connObj;
                dbCommand.CommandText = sql;
                dbCommand.CommandType = type;
                dbCommand.Parameters.Clear();

                if (parms != null)
                {
                    for (int i = 0; i < parms.Length; i++)
                    {
                        dbCommand.Parameters.Add(parms[i]);
                    }
                }

                return dbCommand.ExecuteNonQuery();
            }
            catch (SqlException ex)
            {
                if (isTransaction)
                {
                    objSqlTransaction.Rollback();
                }

                throw new Exception("ִд [ExecuteNoResult()] SQL(" + sql + ")ʱ:" + ex.Message);
            }
            finally
            {
                connObj.Close();
                connObj.Dispose();
            }
        }

        /// <summary>
        /// ͷݿԴ
        /// </summary>
        public static void Dispose()
        {
            try
            {
                if (dbConnection != null)
                {
                    dbConnection.Close();
                    dbConnection.Dispose();
                    dbConnection = null;
                }
            }
            catch (SqlException ex)
            {
                throw new Exception("ִ [Dispose()] ʱ:" + ex.Message);
            }
        }
    }
}
