using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace yinLouSys
{
    public partial class frmClient : Form
    {
        private string _selectId="";

        private frmMain _frmParent;

        public frmMain FrmParent
        {
            get { return _frmParent; }
            set { _frmParent = value; }
        }

        public frmClient()
        {
           // _frmParent = frm1;
            InitializeComponent();
        }

        private void frmClient_Load(object sender, EventArgs e)
        {
            //this.WindowState = FormWindowState.Maximized;
            SetFormSize();
            cbbType.SelectedIndex = 0;
            cbbSex.SelectedIndex = 0;
            txtZqrq.Text = DateTime.Now.ToString("yyyy-MM-dd");
            LoadTx();
            txtKyrq.Text = "";

            txtJdr.Text = frmMain.OperName;
        }

        private void SetFormSize()
        {
            this.Top = 30;
            this.Left = 0;
            this.Width = _frmParent.ClientSize.Width - 150;
            this.Height = _frmParent.ClientSize.Height-130;

            //this.Size=_frmParent.ClientSize.Height;
        }

        private void LoadTx()
        {
            object obj = code.SQLHelp.ExecuteScalar("select isnull(s_values,'') from tab_setting where s_name='ϵ'", null);
            if (obj != null && obj.ToString().Trim() != "")
            {
                string[] list = obj.ToString().Split('|');

                cbbTaoXi.Items.Clear();
                for (int i = 0; i < list.Length; i++)
                {
                    cbbTaoXi.Items.Add(list[i]);
                }
            }
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            try
            {
                string sql = "";

                if ("" == txtName.Text)
                {
                    MessageBox.Show("", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txtName.Focus();
                    return;
                }

                if ("" == txtTel.Text)
                {
                    MessageBox.Show("ϵ绰", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txtTel.Focus();
                    return;
                }

                string txTemp = "";

                for (int i = 0; i < cbbTaoXi.Items.Count; i++)
                {
                    if (cbbTaoXi.GetItemChecked(i))
                    {
                        txTemp += cbbTaoXi.Items[i].ToString() + "|";
                    }
                }

                if ("" != txTemp)
                {
                    txTemp = txTemp.Substring(0, txTemp.Length - 1);
                }

                code.LogInfor bean = new yinLouSys.code.LogInfor();

                if (_selectId == "")
                {
                    bean.OperType = "ӿͻϢ";
                    sql = "insert into tab_clientInfor (c_firstDate,c_name,c_sex,c_tel,c_baby,c_taoXi,c_dingJ,c_yuKuan,c_addItem,c_addMoney,c_shiJiMoney,c_paiDate,c_xuanDate,c_kanYangDate,c_quDate,c_jieDai,c_remark"
                        + ")values('" + txtZqrq.Text + "','" + txtName.Text + "','" + cbbSex.Text + "','" + code.Base.SBCToDBC(txtTel.Text) + "','" + txtBrithday.Text + "','" + txTemp + "','" + code.Base.SBCToDBC(txtDingJ.Text) + "','" + code.Base.SBCToDBC(txtYk.Text) + "','"
                        + txtAddItem.Text + "','" + code.Base.SBCToDBC(txtAItemJe.Text) + "','" + code.Base.SBCToDBC(txtSjje.Text) + "','" + txtPzrq.Text + "','" + txtXprq.Text + "','" + txtKyrq.Text + "','" + txtQprq.Text + "','" + txtJdr.Text + "','" + txtBz.Text + "')";
                }
                else
                {
                    bean.OperType = "޸ĿͻϢ";

                    sql = "update tab_clientInfor set c_firstDate='" + txtZqrq.Text + "',c_name='" + txtName.Text + "',c_sex='" + cbbSex.Text + "',c_tel='" + txtTel.Text + "',c_baby='"
                        + txtBrithday.Text + "',c_taoXi='" + txTemp + "',c_dingJ='" + code.Base.SBCToDBC(txtDingJ.Text) + "',c_yuKuan='" + code.Base.SBCToDBC(txtYk.Text) + "',c_addItem='" + txtAddItem.Text + "',c_addMoney='"
                        + code.Base.SBCToDBC(txtAItemJe.Text) + "',c_shiJiMoney='" + code.Base.SBCToDBC(txtSjje.Text) + "',c_paiDate='" + txtPzrq.Text + "',c_xuanDate='" + txtXprq.Text + "',c_kanYangDate='" + txtKyrq.Text + "',c_quDate='" + txtQprq.Text + "',c_jieDai='" 
                        + txtJdr.Text + "',c_remark='" + txtBz.Text + "' where c_id='" + _selectId + "'";
                }

                code.SQLHelp.ExecuteNoResult(sql);
                MessageBox.Show("ɹ", "ϵͳϢ", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Query();

          
                bean.UserName = _frmParent.UserName;
                bean.Ip = "";

                bean.Discrible = "ͻ" + txtName.Text + "  绰" + txtTel.Text + " ע"+txtBz.Text+"";

                code.LogMan.AddLog(bean);

                if (_selectId == "")
                {
                    ClearForm();
                }



            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "ϵͳ", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void ClearForm()
        {
            txtName.Text = "";
            txtTel.Text = "";
            txtBrithday.Text = "";
            txtAddItem.Text = "";
            txtPzrq.Text = "";
            txtXprq.Text = "";
            txtQprq.Text = "";
            txtBz.Text = "";
            _selectId = "";
            lblState.Text = "";
        }

        private void Query()
        {
            string sql = "select c_id,c_firstDate as ѯ,c_name as ,c_sex as Ա,c_tel as ϵ绰,c_baby as ,replace(c_taoXi,'|','') as ϵ,convert(varchar(20),c_dingJ) as ,"
                + "convert(varchar(20),c_yuKuan) as ,c_addItem as Ŀ,convert(varchar(20),c_addMoney) as ,convert(varchar(20),c_shiJiMoney) as ʵʽ,c_paiDate as ,c_xuanDate ѡƬ,c_kanYangDate as ,c_quDate as "
                +"ȡƬ,c_jieDai as Ӵ,c_remark as ע from tab_clientInfor where 1=1";

            if (cbbType.SelectedIndex > 0)
            {
                switch (cbbType.Text)
                {
                    case "ѯ":
                        sql += " and c_firstDate between '" + dtpStart.Value.ToString("yyyy-MM-dd") + "' and '" + dtpEnd.Value.ToString("yyyy-MM-dd") + "'";
                        break;
                    case "":
                        sql += " and  convert(datetime,c_paiDate) between '" + dtpStart.Value.ToString("yyyy-MM-dd") + "' and '" + dtpEnd.Value.ToString("yyyy-MM-dd") + "'";
                        break;
                    case "ѡƬ":
                        sql += " and  convert(datetime,c_xuanDate) between '" + dtpStart.Value.ToString("yyyy-MM-dd") + "' and '" + dtpEnd.Value.ToString("yyyy-MM-dd") + "'";
                        break;
                    case "":
                        sql += " and  convert(datetime,c_kanYangDate) between '" + dtpStart.Value.ToString("yyyy-MM-dd") + "' and '" + dtpEnd.Value.ToString("yyyy-MM-dd") + "'";
                        break;
                    case "ȡƬ":
                        sql += " and  convert(datetime,c_quDate) between '" + dtpStart.Value.ToString("yyyy-MM-dd") + "' and '" + dtpEnd.Value.ToString("yyyy-MM-dd") + "'";
                        break;
                }
            }

            if ("" != txtQname.Text)
            {
                sql += " and c_name like '%"+txtQname.Text+"%'";
            }

            this.dgList.DataSource = null;
            dgList.DataSource = code.SQLHelp.ExecuteDataTable(sql);
            lblSum.Text = dgList.Rows.Count.ToString();

            dgList.Columns[0].Visible = false;

            dgList.Columns[4].Frozen = true;

            

        }

        private void groupBox2_Enter(object sender, EventArgs e)
        {
            this.AcceptButton = btnQuery;
        }

        private void groupBox1_Enter(object sender, EventArgs e)
        {
            this.AcceptButton = btnSave;
        }

        private void cbbType_SelectedIndexChanged(object sender, EventArgs e)
        {
            dtpStart.Enabled = cbbType.SelectedIndex > 0;
            dtpEnd.Enabled = cbbType.SelectedIndex > 0;
        }

        private void btnQuery_Click(object sender, EventArgs e)
        {
            Query();
        }

        private void dgList_CellMouseUp(object sender, DataGridViewCellMouseEventArgs e)
        {
            if (e.RowIndex > -1)
            {
                dgList.Rows[e.RowIndex].Selected = true;
            }
        }

        private void dgList_SelectionChanged(object sender, EventArgs e)
        {
            btnDel.Enabled = dgList.SelectedRows.Count > 0;
            btnPl.Enabled = dgList.SelectedRows.Count > 0;

            if (dgList.CurrentRow != null && dgList.CurrentRow.Selected)
             {
                 lblState.Text = "޸";
                 _selectId = dgList.CurrentRow.Cells[0].Value.ToString();
                 txtName.Text = dgList.CurrentRow.Cells[2].Value.ToString();
                 txtZqrq.Text = Convert.ToDateTime(dgList.CurrentRow.Cells[1].Value.ToString()).ToString("yyyy-MM-dd");
                 cbbSex.Text = dgList.CurrentRow.Cells[3].Value.ToString();
                 txtTel.Text = dgList.CurrentRow.Cells[4].Value.ToString();
                 txtBrithday.Text = dgList.CurrentRow.Cells[5].Value.ToString();
                 string temp1 = dgList.CurrentRow.Cells[6].Value.ToString().Trim();
                 ArrayList arr=new ArrayList(dgList.CurrentRow.Cells[6].Value.ToString().Trim().Replace("", "|").Split('|'));
                
                 for (int i = 0; i < cbbTaoXi.Items.Count; i++)
                 {
                     cbbTaoXi.SetItemChecked(i, arr.Contains(cbbTaoXi.Items[i].ToString()));
                 }
                 //    txtKyrq.Text = dgList.CurrentRow.Cells[6].Value.ToString();
                 txtDingJ.Text = dgList.CurrentRow.Cells[7].Value.ToString();
                 txtYk.Text = dgList.CurrentRow.Cells[8].Value.ToString();
                 txtAddItem.Text = dgList.CurrentRow.Cells[9].Value.ToString();
                 txtAItemJe.Text = dgList.CurrentRow.Cells[10].Value.ToString();
                 txtSjje.Text = dgList.CurrentRow.Cells[11].Value.ToString();
                 txtPzrq.Text = dgList.CurrentRow.Cells[12].Value.ToString();
                 txtXprq.Text = dgList.CurrentRow.Cells[13].Value.ToString();
                 txtKyrq.Text = dgList.CurrentRow.Cells[14].Value.ToString();   
                 txtQprq.Text = dgList.CurrentRow.Cells[15].Value.ToString();
                 txtJdr.Text = dgList.CurrentRow.Cells[16].Value.ToString();
                 txtBz.Text = dgList.CurrentRow.Cells[17].Value.ToString();

             }
        }

        private void btnDel_Click(object sender, EventArgs e)
        {
            if (dgList.SelectedRows.Count > 0)
            {
                string xmL = "";
                string list = "";
                for (int i = 0; i < dgList.SelectedRows.Count; i++)
                {
                    list += "'" + dgList.SelectedRows[i].Cells[0].Value.ToString() + "'";
                    xmL += dgList.SelectedRows[i].Cells[""].Value.ToString() + ",";
                    if (i < dgList.SelectedRows.Count - 1)
                    {
                        list += ",";
                    }
                }

                if ("" != list)
                {
                    DialogResult resu = MessageBox.Show("ȷҪɾЩϢ", "ϵͳʾ", MessageBoxButtons.YesNo, MessageBoxIcon.Information);
                    if (resu == DialogResult.Yes)
                    {
                        code.SQLHelp.ExecuteNoResult("delete from tab_clientInfor where c_id in (" + list + ")");                     
   
                        Query();

                        code.LogInfor bean = new yinLouSys.code.LogInfor();
                        bean.UserName = _frmParent.UserName;
                        bean.Ip = "";
                        bean.OperType = "ɾͻϢ";
                        bean.Discrible = "ͻ" + xmL + " ";

                        code.LogMan.AddLog(bean);

                        ClearForm();
                    }

                }
            }
        }

        private void btnExcel_Click(object sender, EventArgs e)
        {
            if (dgList.DataSource != null && dgList.Rows.Count > 0)
            {
                this.saveFileDialog1.Filter = "Excel files(*.xls)|*.xls";
                DialogResult dr = this.saveFileDialog1.ShowDialog();
                if (this.saveFileDialog1.FileName.Trim() != string.Empty && dr == DialogResult.OK)
                {
                    string fileName = this.saveFileDialog1.FileName;
                    code.ExcelTrue.Export(fileName, dgList);

                    code.LogInfor bean = new yinLouSys.code.LogInfor();
                    bean.UserName = _frmParent.UserName;
                    bean.Ip = "";
                    bean.OperType = "ͻϢ";
                    bean.Discrible = "" + dgList.Rows.Count.ToString() + "Ϣ";

                    code.LogMan.AddLog(bean);

                    DialogResult dr2 = MessageBox.Show("ѳɹEXCELļУǷ򿪸ļ", "ϵͳԻ", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                    if (dr2 == DialogResult.Yes)
                    {
                        System.Diagnostics.Process.Start(fileName);
                    }
                }
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            frmMain._strDate = txtZqrq.Text;
            selectDate cc = new selectDate(this.Left+454,this.Top+157);
            cc.IsClear = 0;
            cc.ShowDialog();
            this.txtZqrq.Text = frmMain._strDate;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            frmMain._strDate = txtPzrq.Text;
            selectDate cc = new selectDate(this.Left + 522, this.Top + 210);
            cc.ShowDialog();
            this.txtPzrq.Text = frmMain._strDate;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            frmMain._strDate = txtXprq.Text;
            selectDate cc = new selectDate(this.Left + 349, this.Top + 210);
            cc.ShowDialog();
            this.txtXprq.Text = frmMain._strDate;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            frmMain._strDate = txtQprq.Text;
            selectDate cc = new selectDate(this.Left + 522, this.Top + 210);
            cc.ShowDialog();
            this.txtQprq.Text = frmMain._strDate;
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            ClearForm();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            frmSet frm = new frmSet();
            frm.ShowDialog();

            if (frm.ExecFlag == 1)
            {
                LoadTx();
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            frmMain._strDate = txtKyrq.Text;
            selectDate cc = new selectDate(this.Left + 349, this.Top + 210);
            cc.ShowDialog();
            this.txtKyrq.Text = frmMain._strDate;
        }
    }
}