﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace yinLouSys
{
    public partial class frmMain : Form
    {
        private Point mPoint = new Point();
        private string _currenFormName = null; //当前子窗体名称

        public static string _strDate;
        private string _userName;

        public string UserName
        {
            get { return _userName; }
            set { _userName = value; }
        }

        private int isMax = 0;

        private static string _operName;

        public static string OperName
        {
            get { return _operName; }
            set { _operName = value; }
        }

        private Hashtable _allForm=new Hashtable(); //已打开的子窗体信息

        private int childFormNumber = 0;

        public frmMain()
        {
            InitializeComponent();
        }

      

        public virtual void SetFormMax(Form frm)
        {
            frm.Top = 0;
            frm.Left = 0;
            frm.Width = Screen.PrimaryScreen.WorkingArea.Width;
            frm.Height = Screen.PrimaryScreen.WorkingArea.Height;
            isMax = 1;
        }

     
              
        private void button2_Click(object sender, EventArgs e)
        {
           // this.Close();
            ExitSys();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.WindowState = FormWindowState.Minimized;
            isMax = 0;
        }

        private void button7_Click(object sender, EventArgs e)
        {
            //this.Close();
            ExitSys();
        }

        private void ExitSys()
        {
            DialogResult dr = MessageBox.Show("您确认要退出本系统吗？", "系统提示", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (dr == DialogResult.Yes)
            {
                //string sql = "update tab_Login set State=0 where UserName='" + MDIguanli.LoginName + "'";
                //code.SQLHelp.ExecuteNoResult(sql);
                code.SQLHelp.ExecuteNoResult("update tab_user set state='0'  where userName='" + UserName + "'");
                Application.Exit();

            }
            
        }


        private void frmMain_Load(object sender, EventArgs e)
        {
            OperName = code.SQLHelp.ExecuteScalar("select realName from tab_user where userName='"+UserName+"'", null).ToString();

            int gly = code.SQLHelp.ExecuteScalarByInt("select isnull(isManager,0) from tab_user where userName='" + UserName + "'", null);

            if (gly == 0)
            {
                button5.Enabled = false;
                button6.Enabled = false;
            }


            //this.WindowState = FormWindowState.Maximized;
            this.statusStrip.Items["tsslOpertaor"].Text = OperName;
            SetFormMax(this);
        }

        private void panel1_MouseDown(object sender, MouseEventArgs e)
        {
            mPoint.X = e.X;
            mPoint.Y = e.Y;
        }

        private void panel1_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                Point myPosittion = MousePosition;
                myPosittion.Offset(-mPoint.X, -mPoint.Y);
                Location = myPosittion;
            } 
        }

        private void button3_Click(object sender, EventArgs e)
        {
            frmClient frmC = new frmClient();
            frmC.FrmParent = this;
            //frmC.MdiParent = this;
            //frmC.Show();
            AddForm(frmC, sender);
          
           // this.FilmShow(typeof(frmClient));
        }

        /// 控制只弹出一个子窗体
        /// </summary>
        /// <param name="type">子窗体类型</param>
        public void FilmShow(Type type)
        {
           

            Form[] f = this.MdiChildren;
            foreach (Form form in f)
            {
                if (form.GetType().Name == type.Name)
                {
                    form.Activate();
                    return;
                }
            }
            System.Reflection.Assembly a = System.Reflection.Assembly.GetExecutingAssembly();
            Form ff = (Form)a.CreateInstance(type.FullName);
            ff.StartPosition = FormStartPosition.CenterScreen;
            ff.Icon = null;

            //if (!ff.IsMdiContainer)
            //{
            //    ff.FormBorderStyle = FormBorderStyle.FixedSingle;
            //}

            ff.MdiParent = this;
           // ff.FormClosed += new FormClosedEventHandler(CloseWindows);
            ff.Show();
            //全部关闭ToolStripMenuItem.Enabled = true;
        }

        private void button8_Click(object sender, EventArgs e)
        {
            if (isMax!=1)
            {
                SetFormMax(this);
            }
            else
            {
                SetFormNormal(this);
            }
        }

        private void SetFormNormal(Form frm)
        {
            frm.Width = 1003;
            frm.Height = 513;
            this.StartPosition = FormStartPosition.CenterScreen;
            isMax = 0;

        }

        private void button5_Click(object sender, EventArgs e)
        {
            frmUserMan frmC = new frmUserMan();
            frmC.FrmParent = this;            
            AddForm(frmC, sender);
           
        }

        private void button6_Click(object sender, EventArgs e)
        {
            frmLogMan frmC = new frmLogMan();
            frmC.FrmParent = this;           
            AddForm(frmC, sender);
           
        }

        private void button4_Click(object sender, EventArgs e)
        {
            frmUpdatePwd frmC = new frmUpdatePwd();
            frmC.FrmParent = this;         
            AddForm(frmC, sender);
           
        }

        private void AddForm(Form frm, object btnO)
        {
            Button btn = (Button)btnO;
            _currenFormName = btn.Text;
            if (!_allForm.Contains(btn.Text))
            {
                if (frm.Text != "影楼系统")
                {
                    frm.FormClosing += new FormClosingEventHandler(MDIguanli_FormClosing);
                }
                frm.MdiParent = this;
                frm.Show();
                

                _allForm.Add(btn.Text, frm);

                AddButton(btn.Text);
            }
            else
            {
                ((Form)_allForm[btn.Text]).Activate();
              
            }

            ChangeFrm();
        }

        private void MDIguanli_FormClosing(object sender, FormClosingEventArgs e)
        {
            _currenFormName = ((Form)sender).Text;
            CloseChiledF2();
            ResetButton();
        }

        private void ChangeFrm()
        {
            button9.Visible = _allForm.Count > 0;

            if (_allForm.Count > 0)
            {
                if (_currenFormName != null)
                {
                    foreach (Control c in panel4.Controls)
                    {
                        if (c.Text.Trim() == "")
                        {
                            continue;
                        }

                        if (c.Text.Equals(_currenFormName))
                        {
                            ((Button)c).FlatStyle = FlatStyle.Flat;
                            ((Button)c).BackColor = button3.BackColor;
                            ((Button)c).Top = 5;

                        }
                        else
                        {
                            ((Button)c).Top = 5;
                            ((Button)c).FlatStyle = FlatStyle.Standard;
                            ((Button)c).BackColor = panel4.BackColor;
                        }
                    }
                }
            }
        }

        private void AddButton(string txt)
        { 
            //panel4

            Button obj = new Button();
            obj.Text = txt;
            obj.AutoSize = true;
            obj.Click += new EventHandler(common_click);
            obj.FlatStyle = FlatStyle.Standard;
            obj.BackColor = button3.BackColor;

            _currenFormName = txt;
            int cnt = 0;

            for (int i = 0; i < panel4.Controls.Count; i++)
            {
                string type = panel4.Controls[i].GetType().ToString();

                if (type.EndsWith("Button") && ((Button)panel4.Controls[i]).Text.Trim()!="")
                {
                    cnt++;
                }
            }

            Button last = null;

            for (int i = panel4.Controls.Count - 1; i > 0; i--)
            {
                string type = panel4.Controls[i].GetType().ToString();
                if (type.EndsWith("Button") && ((Button)panel4.Controls[i]).Text.Trim() != "关")
                {
                    last = (Button)panel4.Controls[i];
                    break;
                }
            }

             panel4.Controls.Add(obj);

            if (cnt == 0)
            {
                obj.Left = 5;
            }
            else
            {
                int lVal = 0;
                int wz = panel4.Controls.Count - 2;

                obj.Left =last.Left+last.Width + 10;
            }
            ChangeFrm();
        }

        private void common_click(object sender, EventArgs e)
        {
            Button btn = (Button)sender;

            ((Form)_allForm[btn.Text]).Activate();

            _currenFormName = btn.Text;
            ChangeFrm();
            
        }

        public void CloseChiledF2()
        {
            if (_currenFormName != null)
            {
                int index = -1;
                ArrayList arr = new ArrayList(_allForm.Keys);

                for (int i = 0; i < arr.Count; i++)
                {
                    if (arr[i].Equals(_currenFormName))
                    {
                        index = i;
                        break;
                    }
                }
                Control cn = null;
                foreach (Control c in panel4.Controls)
                {
                    if (c.Text.Equals(_currenFormName))
                    {
                        cn = c;
                        break;
                    }
                }

                //((Form)_allForm[_currenFormName]).Close();

                if (cn != null)
                    panel4.Controls.Remove(cn);

                arr.RemoveAt(index);
                _allForm.Remove(_currenFormName);
                if (index < arr.Count)
                {
                    _currenFormName = arr[index].ToString();
                }
                else
                {
                    if (index - 1 >= 0)
                    {
                        _currenFormName = arr[index - 1].ToString();
                    }
                }
            }

            ChangeFrm();
        }

        public void CloseChiledF()
        {
            if (_currenFormName != null)
            {
                int index = -1;
                ArrayList arr = new ArrayList(_allForm.Keys);

                for (int i = 0; i < arr.Count; i++)
                {
                    if (arr[i].Equals(_currenFormName))
                    {
                        index = i;
                        break;
                    }
                }
                Control cn = null;
                foreach (Control c in panel4.Controls)
                {
                    if (c.Text.Equals(_currenFormName))
                    {
                        cn = c;
                        break;
                    }
                }
                               
               ((Form)_allForm[_currenFormName]).Close();

                if (cn != null)
                    panel4.Controls.Remove(cn);

                arr.RemoveAt(index);
              //  _allForm.Remove(_currenFormName);
                if (index < arr.Count)
                {
                    _currenFormName = arr[index].ToString();
                }
                else
                {
                    if (index - 1 >= 0)
                    {
                        _currenFormName = arr[index-1].ToString();
                    }
                }
            }

            ChangeFrm();
        }

        private void button9_Click(object sender, EventArgs e)
        {
            CloseChiledF();
            ResetButton();
        }

        private void frmMain_FormClosed_1(object sender, FormClosedEventArgs e)
        {
            code.SQLHelp.ExecuteNoResult("update tab_user set state='0'  where userName='" + UserName + "'");
            Application.Exit();
        }

        private void ResetButton()
        { 
            ArrayList arr=new ArrayList(panel4.Controls);

            for (int i = 0; i < arr.Count; i++)
            {
                if (((Control)arr[i]).Text.Trim() != "")
                {
                    panel4.Controls.Remove((Control)arr[i]);
                }
            }

            ArrayList arrName = new ArrayList(_allForm.Keys);
            ArrayList arrCon = new ArrayList();

            for (int i = 0; i < arrName.Count; i++)
            {
                Button obj = new Button();
                obj.Text = arrName[i].ToString();
                obj.AutoSize = true;
                obj.Click += new EventHandler(common_click);
                obj.FlatStyle = FlatStyle.Standard;
                obj.BackColor = button3.BackColor;

                arrCon.Add(obj);
                panel4.Controls.Add(obj);
                if (i == 0)
                {
                    obj.Left = 5;
                }
                else
                {
                    Button last = (Button)arrCon[i-1];
                    obj.Left = last.Left + last.Width + 10;
                }
            }

            ChangeFrm();

        }

    }
}
