using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace yinLouSys
{
    public partial class frmUserMan : Form
    {
        private string _selectUser = "";
        private string _selectPwd = "";

        private frmMain _frmParent;

        public frmMain FrmParent
        {
            get { return _frmParent; }
            set { _frmParent = value; }
        }

        public frmUserMan()
        {
            InitializeComponent();
        }

        private void frmUserMan_Load(object sender, EventArgs e)
        {
            Query();
            SetFormSize();
        }

        private void SetFormSize()
        {
            this.Top = 30;
            this.Left = 0;
            this.Width = _frmParent.ClientSize.Width - 150;
            this.Height = _frmParent.ClientSize.Height - 130;

            //this.Size=_frmParent.ClientSize.Height;
        }

        private void Query()
        {
            string sql = "select userName as û,password as ,realName as ,case when isnull(state,0)='0' then '' else '' end as û״̬,ip as ¼IP from tab_user";
            dvList.DataSource = code.SQLHelp.ExecuteDataTable(sql);
            lblSum.Text = dvList.Rows.Count.ToString();
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void dvList_CellMouseUp(object sender, DataGridViewCellMouseEventArgs e)
        {
            if (e.RowIndex > -1)
            {
                dvList.Rows[e.RowIndex].Selected = true;
            }
        }

        private void clearForm()
        {
            txtUseName.Text = "";
            txtPwd.Text = "";
            txtXm.Text = "";
            _selectUser = "";
            lblState.Text = "";
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            clearForm();
            txtUseName.Focus();
        }

        private void dvList_SelectionChanged(object sender, EventArgs e)
        {
            btnDel.Enabled = dvList.SelectedRows.Count > 0;

            if (dvList.CurrentRow != null && dvList.CurrentRow.Selected)
            {
                lblState.Text = "޸";
                _selectUser = dvList.CurrentRow.Cells[0].Value.ToString();
                txtUseName.Text = dvList.CurrentRow.Cells[0].Value.ToString();
                txtPwd.Text = dvList.CurrentRow.Cells[1].Value.ToString();
                _selectPwd = dvList.CurrentRow.Cells[1].Value.ToString();
                txtXm.Text = dvList.CurrentRow.Cells[2].Value.ToString();
            }
        }

        private void dvList_CellFormatting(object sender, DataGridViewCellFormattingEventArgs e)
        {
            // ѵ4ʾ*ţ*ŵĸʵݵĳͬ
            if (e.ColumnIndex == 1)
            {
                if (e.Value != null && e.Value.ToString().Length > 0)
                {
                    e.Value = new string('*', e.Value.ToString().Length);
                }
            }
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            try
            {
                string sql = "";

                if ("" == txtUseName.Text)
                {
                    MessageBox.Show("û", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txtUseName.Focus();
                    return;
                }

                if ("" == txtPwd.Text)
                {
                    MessageBox.Show("", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txtPwd.Focus();
                    return;
                }

                string isExistSql = "select count(*) from tab_user where userName='"+txtUseName.Text+"'";

                if ("" != _selectUser)
                {
                    isExistSql = "select count(*) from tab_user where userName='" + txtUseName.Text + "' and userName!='"+_selectUser+"'";
                }

                int flag = code.SQLHelp.ExecuteScalarByInt(isExistSql, null);
                if (flag > 0)
                {
                    MessageBox.Show("ûѾ", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txtUseName.Focus();
                    return;
                }
                code.LogInfor bean = new yinLouSys.code.LogInfor();

                if ("" == _selectUser)
                {
                    bean.OperType = "ӲԱ";
                    string pwdS = code.Base.StringToMD5Hash(txtPwd.Text);
                    sql = "insert into tab_user (userName,password,realName)values('" + txtUseName.Text + "','"+pwdS+"','" + txtXm.Text + "')";
                }
                else
                {
                    bean.OperType = "޸ĲԱ";
                    string pwdS = txtPwd.Text;

                    if (!_selectPwd.Equals(pwdS))
                    {
                        pwdS = code.Base.StringToMD5Hash(txtPwd.Text);
                    }
                    sql = "update tab_user set userName='" + txtUseName.Text + "',password='" + pwdS + "',realName='" + txtXm.Text + "' where userName='" + _selectUser + "'";
                }

                code.SQLHelp.ExecuteNoResult(sql);

                MessageBox.Show("ɹ", "ϵͳϢ", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Query();

                
                bean.UserName = _frmParent.UserName;
                bean.Ip = "";
                
                bean.Discrible = "ӵû"+txtUseName.Text+"";

                code.LogMan.AddLog(bean);

                if (_selectUser == "")
                {
                    clearForm();
                }


            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "ϵͳ", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void txtUseName_Leave(object sender, EventArgs e)
        {
            if (_selectUser == "" && txtXm.Text == "" && ""!=txtUseName.Text)
            {
                txtXm.Text = txtUseName.Text;
            }
        }

        private void btnDel_Click(object sender, EventArgs e)
        {
            if (dvList.SelectedRows.Count > 0)
            {
                string userL = "";
                string list = "";
                for (int i = 0; i < dvList.SelectedRows.Count; i++)
                {
                    if (dvList.SelectedRows[i].Cells[0].Value.ToString().Equals(_frmParent.UserName))
                    {
                        MessageBox.Show("ɾǰ¼û", "", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        return;
                    }
                    list += "'" + dvList.SelectedRows[i].Cells[0].Value.ToString() + "'";
                    userL += dvList.SelectedRows[i].Cells[0].Value.ToString() + ",";
                    if (i < dvList.SelectedRows.Count - 1)
                    {
                        list += ",";
                    }
                }

                if ("" != list)
                {
                    DialogResult resu = MessageBox.Show("ȷҪɾЩϢ", "ϵͳʾ", MessageBoxButtons.YesNo, MessageBoxIcon.Information);
                    if (resu == DialogResult.Yes)
                    {
                        code.SQLHelp.ExecuteNoResult("delete from tab_clientInfor where c_id in (" + list + ")");

                        Query();

                        code.LogInfor bean = new yinLouSys.code.LogInfor();
                        bean.UserName = _frmParent.UserName;
                        bean.Ip = "";
                        bean.OperType = "ɾûϢ";
                        bean.Discrible = "û" + userL + " ";

                        code.LogMan.AddLog(bean);

                        clearForm();
                    }

                }
            }
        }

    }
}