﻿using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;

using Paper.BusinessObject;
using Paper.DataAccessLayer;
using Sky.Darkness.Commons.Util;
namespace Paper.BusinessLogicLayer
{
    /// <summary>
    /// ClassesManager 的摘要说明
    /// </summary>
    public class ClassesManager
    {
        private ClassesDAO classesDao;

        public ClassesManager()
        {
            classesDao = new ClassesDAO();
        }

        /// <summary>
        /// Retrieves all Classes
        /// </summary>
        /// <returns></returns>
        public List<Classes> SelectAll()
        {
            return classesDao.SelectAll();
        }

        /// <summary>
        /// Retrieves all teachers
        /// 分页查询班级信息
        /// </summary>
        /// <returns>json格式的数据</returns>
        public string SearchPaging(int start, int limit)
        {
            JsonHelper json = new JsonHelper();

            string jsons = "";
            json.Success = true;

            List<Classes> claes = classesDao.SearchPaging(start, limit);

            foreach (Classes cla in claes)
            {
                json.AddItem("SpecialtyID", cla.SpecialtyID);
                json.AddItem("ClassID", cla.ClassID);
                json.AddItem("ClassName", cla.ClassName);
                json.AddItem("ClassNum", cla.ClassNum.ToString());
                json.AddItem("YearOfGrade", cla.YearOfGrade);
                json.AddItem("DepartmentID", cla.DepartmentID);
                json.AddItem("Id", cla.Id.ToString());
                json.ItemOk();
            }

            json.TotalCount = classesDao.GetAllCount();
            jsons = json.ToString();
            return jsons;
        }

        /// <summary>
        /// Updates a particular Classes
        /// </summary>
        public int Update(Classes classesToUpdate)
        {
            return classesDao.Update(classesToUpdate);
        }

        /// <summary>
        /// Inserts a new Classes
        /// </summary>
        /// <param name="Classes">newClasses</param>
        public int Insert(Classes newClasses)
        {
            return classesDao.Insert(newClasses);
        }

        /// <summary>
        /// Deletes an existing Classes
        /// </summary>
        /// <param name="id">Classes Id</param>
        public int Delete(string classesID)
        {
            return classesDao.Delete(classesID);
        }
    }
}