﻿using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;
using Sky.Darkness.Commons.Util;
using Paper.BusinessObject;
using Paper.DataAccessLayer;

namespace Paper.BusinessLogicLayer
{
    /// <summary>
    /// CourseManager 的摘要说明
    /// </summary>
    public class CourseManager
    {
        private CourseDAO courseDao;

        public CourseManager()
        {
            courseDao = new CourseDAO();
        }

        /// <summary>
        /// Retrieves all Courses
        /// </summary>
        /// <returns></returns>
        public List<Course> SelectAll()
        {
            return courseDao.SelectAll();
        }

        /// <summary>
        /// Retrieves all teachers
        /// 分页查询课程信息
        /// </summary>
        /// <returns>json格式的数据</returns>
        public string SearchPaging(int start, int limit)
        {
            JsonHelper json = new JsonHelper();

            string jsons = "";
            json.Success = true;

            List<Course> courses = courseDao.SearchPaging(start, limit);

            foreach (Course course in courses)
            {
                json.AddItem("DepartmentID", course.DepartmentID);
                json.AddItem("SpecialtyID", course.SpecialtyID);
                json.AddItem("CourseID", course.CourseID);
                json.AddItem("CourseName", course.CourseName);
                json.AddItem("CourseType", course.CourseType);
                json.AddItem("Remark", course.Remark);
                json.AddItem("Id", course.Id.ToString());
                json.ItemOk();
            }

            json.TotalCount = courseDao.GetAllCount();
            jsons = json.ToString();
            return jsons;
        }

        /// <summary>
        /// Updates a particular Course
        /// </summary>
        public int Update(Course courseToUpdate)
        {
            return courseDao.Update(courseToUpdate);
        }

        /// <summary>
        /// Inserts a new Course
        /// </summary>
        /// <param name="Department">newCourse</param>
        public int Insert(Course newCourse)
        {
            return courseDao.Insert(newCourse);
        }

        /// <summary>
        /// Deletes an existing Course
        /// </summary>
        /// <param name="id">Course Id</param>
        public int Delete(string courseID)
        {
            return courseDao.Delete(courseID);
        }
    }
}