﻿using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;

using Paper.BusinessObject;
using Paper.DataAccessLayer;

using Sky.Darkness.Commons.Util;

namespace Paper.BusinessLogicLayer
{
    /// <summary>
    /// TeacherManager 的摘要说明
    /// </summary>
    public class DepartmentManager
    {
        private DepartmentDAO departmentDao;

        public DepartmentManager()
        {
            departmentDao = new DepartmentDAO();
        }

        /// <summary>
        /// Retrieves all departments
        /// </summary>
        /// <returns></returns>
        public List<Department> SelectAll()
        {
            return departmentDao.SelectAll();
        }

        /// <summary>
        /// Retrieves all Department
        /// 分页查询部门信息
        /// </summary>
        /// <returns>json格式的数据</returns>
        public string SearchPaging(int start, int limit)
        {
            JsonHelper json = new JsonHelper();

            string jsons = "";
            json.Success = true;

            List<Department> departments = departmentDao.SearchPaging(start, limit);

            foreach (Department department in departments)
            {
                json.AddItem("DepartmentID", department.DepartmentID);
                json.AddItem("DepartmentName", department.DepartmentName);
                json.AddItem("BelongToAcademy", department.BelongToAcademy);
                json.AddItem("FoundDepartmentTime", department.FoundDepartmentTime.ToString());
                json.AddItem("BearingOfCultivate", department.BearingOfCultivate);
                json.AddItem("Id", department.Id.ToString());
                json.ItemOk();
            }

            json.TotalCount = departmentDao.GetAllCount();
            jsons = json.ToString();
            return jsons;
        }

        /// <summary>
        /// Updates a particular Department
        /// </summary>
        public int Update(Department departmentToUpdate)
        {
            return departmentDao.Update(departmentToUpdate);
        }

        /// <summary>
        /// Inserts a new Department
        /// </summary>
        /// <param name="Department">newDepartment</param>
        public int Insert(Department newDepartment)
        {
            return departmentDao.Insert(newDepartment);
        }

        /// <summary>
        /// Deletes an existing Department
        /// </summary>
        /// <param name="id">Department Id</param>
        public int Delete(string departmentID)
        {
            return departmentDao.Delete(departmentID);
        }
    }
}