﻿using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;

using Paper.BusinessObject;
using Paper.DataAccessLayer;
using Sky.Darkness.Commons.Util;
namespace Paper.BusinessLogicLayer
{
    /// <summary>
    /// SpecialtyManager 的摘要说明
    /// </summary>
    public class SpecialtyManager
    {
        private SpecialtyDAO specialtyDao;

        public SpecialtyManager()
        {
            specialtyDao = new SpecialtyDAO();
        }

        /// <summary>
        /// Retrieves all Specialtys
        /// </summary>
        /// <returns></returns>
        public List<Specialty> SelectAll()
        {
            return specialtyDao.SelectAll();
        }


        /// <summary>
        /// Retrieves all Specialtys
        /// </summary>
        /// <returns></returns>
        public string GetAllSpecialty()
        {
            string jsons = "[";

            List<Specialty> specialties = specialtyDao.SelectAll();

            foreach (Specialty specialy in specialties)
            {
                jsons += "['" + specialy.SpecialtyID + "','" + specialy.SpecialtyName + "'],";
            }
            jsons = jsons.Substring(0, jsons.Length - 1);
            jsons += "]";
            return jsons;
        }


        /// <summary>
        /// Retrieves all specialties
        /// 分页查询专业信息
        /// </summary>
        /// <returns>json格式的数据</returns>
        public string SearchPaging(int start, int limit)
        {
            JsonHelper json = new JsonHelper();

            string jsons = "";
            json.Success = true;

            List<Specialty> specialties = specialtyDao.SearchPaging(start, limit);

            foreach (Specialty specialty in specialties)
            {
                json.AddItem("specialtyID", specialty.SpecialtyID);
                json.AddItem("specialtyName", specialty.SpecialtyName);
                json.AddItem("lengthOfSchooling", specialty.LengthOfSchooling);
                json.AddItem("compulsoryCreditHour", specialty.CompulsoryCreditHour.ToString());
                json.AddItem("selectCreditHour", specialty.SelectCreditHour.ToString());
                json.AddItem("minCreditHour", specialty.MinCreditHour.ToString());
                json.AddItem("departmentID", specialty.DepartmentID);
                json.AddItem("Id", specialty.Id.ToString());
                json.ItemOk();
            }

            json.TotalCount = specialtyDao.GetAllCount();
            jsons = json.ToString();
            return jsons;
        }

        /// <summary>
        /// Updates a particular Specialty
        /// </summary>
        public int Update(Specialty specialtyToUpdate)
        {
            return specialtyDao.Update(specialtyToUpdate);
        }

        /// <summary>
        /// Inserts a new Specialty
        /// </summary>
        /// <param name="Specialty">newSpecialty</param>
        public int Insert(Specialty newSpecialty)
        {
            return specialtyDao.Insert(newSpecialty);
        }

        /// <summary>
        /// Deletes an existing Specialty
        /// </summary>
        /// <param name="id">Specialty Id</param>
        public int Delete(string specialtyID)
        {
            return specialtyDao.Delete(specialtyID);
        }
    }
}