﻿using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;

using Paper.BusinessObject;
using Paper.DataAccessLayer;

using Sky.Darkness.Commons.Util;

namespace Paper.BusinessLogicLayer
{
    /// <summary>
    /// TeacherManager 的摘要说明
    /// </summary>
    public class TeacherManager
    {
        private TeacherDAO teacherDao;

        public TeacherManager()
        {
            teacherDao = new TeacherDAO();
        }

        /// <summary>
        /// Retrieves all teachers
        /// </summary>
        /// <returns></returns>
        public List<Teacher> SelectAll(string departmentID)
        {
            return teacherDao.SelectAll();//departmentID);
        }

        /// <summary>
        /// Retrieves all teachers
        /// 分页查询教师信息
        /// </summary>
        /// <returns>json格式的数据</returns>
        public string SearchPaging(int start, int limit)
        {
            JsonHelper json = new JsonHelper();

            string jsons = "";
            json.Success = true;

            List<Teacher> teachers = teacherDao.SearchPaging(start, limit);

            foreach (Teacher teacher in teachers)
            {
                json.AddItem("teacherID",teacher.TeacherID);
                json.AddItem("teacherName", teacher.TeacherName);
                json.AddItem("teacherSex", teacher.TeacherSex);
                json.AddItem("postName", teacher.PostName);
                json.AddItem("PID", teacher.PID);
                json.AddItem("teacherPassword", teacher.TeacherPassword);
                json.AddItem("Id", teacher.Id.ToString());
                json.ItemOk();
            }

            json.TotalCount = teacherDao.GetAllCount();
            jsons = json.ToString();
            return jsons;
        }

        /// <summary>
        /// Updates a particular teacher
        /// </summary>
        public int Update(Teacher teacherToUpdate)
        {
            return teacherDao.Update(teacherToUpdate);
        }

        /// <summary>
        /// Inserts a new teacher
        /// </summary>
        /// <param name="Teacher">newTeacher</param>
        public int Insert(Teacher newTeacher)
        {
            return teacherDao.Insert(newTeacher);
        }

        /// <summary>
        /// Deletes an existing teacher
        /// </summary>
        /// <param name="id">teacher Id</param>
        public int Delete(string teacherID)
        {
            return teacherDao.Delete(teacherID);
        }
    }
}